/*
 *   Copyright (c) Gejian Semiconductors 2024
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* Includes ------------------------------------------------------------------*/
#include <sys/stat.h>

#include "device.h"
#include "board_cfg.h"
#include "flash_programming_gs32.h"
#include "gs32_flashAPI_lib.h"
#include "board_cfg.h"

#include "gs32f0039a_dsp.h"

#define TEST_SECTOR_ADDR Bzero_Sector0_start

#define BUFF_NODE_COUNT 128
uint32 buff[BUFF_NODE_COUNT] = {0};


int main(void)
{
	volatile uint32 ret = 0;
	volatile uint32 index = 0;
	volatile uint32 lenth = (((gs32f0039a_dsp_bin_len/(2*FlashMainPageSize))+1)*(2*FlashMainPageSize))/sizeof(uint32_t);
	volatile uint32 u32FlashMode = Fapi_GetBankMode();

	Device_init();

	ret = GS32Fapi_Init(DEVICE_SYSCLK_FREQ);
	if ( 0 != ret )
	{
		goto while_loop;
	}

#if 1
	ret = GS32Fapi_EraseSector(TEST_SECTOR_ADDR);
	if ( 0 != ret )
	{
		goto while_loop;
	}
#endif
#if 0
	ret = GS32Fapi_EraseRegion(TEST_SECTOR_ADDR, lenth);
	if ( 0 != ret )
	{
		goto while_loop;
	}
#endif
	for ( index=0; index<BUFF_NODE_COUNT; index++ )
	{
		buff[index] = index;
	}

	ret = GS32Fapi_Program(TEST_SECTOR_ADDR, (uint32 )buff, BUFF_NODE_COUNT);
	//ret = GS32Fapi_Program(TEST_SECTOR_ADDR, (uint32 )gs32f0039a_dsp_bin, gs32f0039a_dsp_bin_len/sizeof(uint32_t));
	if ( 0 != ret )
	{
		goto while_loop;
	}


while_loop:
	for(;;);
	return 0;
}

/*****END OF FILE****/
