/*
 * 	File: hrpwm_ex01_duty_Up_sfo
 *
 *	ʾUPģʽHRPWMĸ߾ռձȿЧ
 *
 *  ePWM1ePWM2ʹõԶģʽePWM3ePWM4ʹֶģʽ
 *
 *  ʾePWM1A ->IO0ePWM1B->IO1۲첨
 *  ʾePWM2A ->IO2ePWM2B->IO3۲첨
 *  ʾePWM3A ->IO4ePWM3B->IO5۲첨
 *  ʾePWM4A ->IO6ePWM4B->IO7۲첨
 *
 *	dutyFine   			-> ռձ
 *	EPWM_TIMER_TBPRD	->  ֵ
 *
 *
 *	ͨ IDE  dutyFine,Ȼ dutyFine_ControlFlag Ϊ 1 ݸ
 *
 *
 *
*/
/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "hrpwm_ex01_board.h"
#include "SFO_v2.h"


#define EPWM_TIMER_TBPRD            100UL
#define MIN_HRPWM_DUTY_PERCENT      4.0/((float32_t)EPWM_TIMER_TBPRD)*100.0
//
// Defines
//
#define LAST_EPWM_INDEX_FOR_EXAMPLE    5

//
// Globals
//

float32_t dutyFine = MIN_HRPWM_DUTY_PERCENT;

//SFO״̬
SFO_Status_t SFO_Status;
//SFOṹ
SFO_Params_t SFO_Params;

volatile uint8_t dutyFine_ControlFlag = 1;

volatile uint32_t ePWM[] =
    {0, myEPWM1_BASE, myEPWM2_BASE, myEPWM3_BASE, myEPWM4_BASE};
//
// Function Prototypes
//
void error(void);

//
// Main
//
void main(void)
{
    uint16_t i = 0;

    //
    // Initialize device clock and peripherals
    //
    Device_init();


    //
    // Calling SFO() updates the HRMSTEP register with calibrated MEP_ScaleFactor.
    // HRMSTEP must be populated with a scale factor value prior to enabling
    // high resolution period control.
    //
    SFO_Struct_init(&SFO_Params,5);

    do
    {
    	SFO_Status = SFO(&SFO_Params);

        if(SFO_Success != SFO_Status)
        {
            error();   	//Look at the enumeration type to see the error type
        }
    }while(SFO_Status != SFO_Success);


    //
    // Disable sync(Freeze clock to PWM as well)
    //
    SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    //
    // Initialize the EPWM GPIO Pins and change the XBAR inputs from using GPIO0
    //
    Board_init();

    //
    // Enable sync and clock to PWM
    //
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);


    //
    // Enable Global Interrupt (INTM) and realtime interrupt (DBGM)
    //
    EINT;
    ERTM;


    for(;;)
    {
         //
         // Sweep DutyFine
         //

         if(dutyFine_ControlFlag)
          {
             dutyFine_ControlFlag = 0;

             for(i=1; i<LAST_EPWM_INDEX_FOR_EXAMPLE; i++)
             {
            	 uint32_t  duty_i;
            	 uint32_t  duty_f;
            	 uint32_t  cmp_set;

            	 // Auto
            	 if( i <=2 )
            	 {
//                 	duty_i  = (uint32_t)(dutyFine/100.0f*EPWM_TIMER_TBPRD);
//                 	duty_f  = (uint32_t)((dutyFine/100.0f*EPWM_TIMER_TBPRD - duty_i)*SFO_Params.HR_mstep_Auto  + 0.5);
//                 	cmp_set = duty_i<<8|duty_f;
                 	uint32_t cmp_set = (dutyFine * (float32_t)(EPWM_TIMER_TBPRD << 8))/100;
                	HRPWM_setCounterCompareValue(ePWM[i],HRPWM_COUNTER_COMPARE_A,cmp_set);
                	HRPWM_setCounterCompareValue(ePWM[i],HRPWM_COUNTER_COMPARE_B,cmp_set);

            	 }else //Not Auto
            	 {
                	duty_i  = (uint32_t)(dutyFine/100.0f*EPWM_TIMER_TBPRD);
                	duty_f  = (uint32_t)((dutyFine/100.0f*EPWM_TIMER_TBPRD - duty_i)* SFO_Params.HR_mstep + 0.5);
                	cmp_set = duty_i<<8|duty_f;

                	HRPWM_setCounterCompareValue(ePWM[i],HRPWM_COUNTER_COMPARE_A,cmp_set);
                	HRPWM_setCounterCompareValue(ePWM[i],HRPWM_COUNTER_COMPARE_B,cmp_set);
            	 }
             }


             //
             // Call the scale factor optimizer lib function SFO()
             // periodically to track for any change due to temp/voltage.
             // This function generates MEP_ScaleFactor by running the
             // MEP calibration module in the HRPWM logic. This scale
             // factor can be used for all HRPWM channels. The SFO()
             // function also updates the HRMSTEP register with the
             // scale factor value.
             //
             SFO_Status = SFO(&SFO_Params); // in background, MEP calibration module
                             	 	 	 	 // continuously updates MEP_ScaleFactor

             if (SFO_Status)
             {
                 error();   // Look at the enumeration type to see the error type

             }
          }
         }

}













void error (void)
{
    ESTOP0;         // Stop here and handle error
}




