/*
 * 	File: hrpwm_ex03_prd_updown_and_up_Auto_sfo
 *
 *	ʾHRPWMĸ߾ڿЧ
 *
 *  ePWM1\2ʾUP_DownģʽĿЧ
 *  ePWM3\4ʾUPģʽĿЧ
 *  (Downģʽ߾ȿƲ֧)
 *
 *	 UP_Down
 *   ʾePWM1A ->IO0ePWM1B->IO1۲첨
 *   ʾePWM2A ->IO2ePWM2B->IO3۲첨
 *	 EPWM_TIMER_UO_DOWN_TBPRD  ->	Up_Down ģʽֵ
 *	 periodFine_Updown		   ->	Up_Down ģʽСֵ
 *
 *
 *   Up
 *   ʾePWM3A ->IO4ePWM3B->IO5۲첨
 *   ʾePWM4A ->IO6ePWM4B->IO7۲첨
 *	 EPWM_TIMER_UP_TBPRD  ->	Up ģʽֵ
 *	 periodFine_Up	      ->	Up_Down ģʽСֵ
 *
 *	ͨ IDE  periodFine_Updown  periodFine_Upݸ
 *
*/
/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "hrpwm_ex03_board.h"
#include "SFO_v2.h"

//
// Defines
//
#define EPWM_TIMER_UO_DOWN_TBPRD       20UL
#define EPWM_TIMER_UP_TBPRD            40UL
#define LAST_EPWM_INDEX_FOR_EXAMPLE    5
#define MIN_HRPWM_PRD_PERCENT   	   0.2



//Сλ
float32_t periodFine_Updown = MIN_HRPWM_PRD_PERCENT;
float32_t periodFine_Up     = MIN_HRPWM_PRD_PERCENT;
// SFO״̬
SFO_Status_t SFO_Status;
// SFOṹ
SFO_Params_t SFO_Params;

volatile uint32_t ePWM[] =
    {0, myEPWM1_BASE, myEPWM2_BASE, myEPWM3_BASE, myEPWM4_BASE};
//
// Function Prototypes
//
void error(void);

//
// Main
//
void main(void)
{
    uint16_t i = 0;

    //
    // Initialize device clock and peripherals
    //
    Device_init();



    //
    // Calling SFO() updates the HRMSTEP register with calibrated MEP_ScaleFactor.
    // HRMSTEP must be populated with a scale factor value prior to enabling
    // high resolution period control.
    //
    SFO_Struct_init(&SFO_Params,5);

    do
    {
    	SFO_Status = SFO(&SFO_Params);

        if(SFO_Success != SFO_Status)
        {
            error();   	//Look at the enumeration type to see the error type
        }
    }while(SFO_Status != SFO_Success);


    //
    // Disable sync(Freeze clock to PWM as well)
    //
    SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    //
    // Initialize EPWM GPIOs and change XBAR inputs from using GPIO0
    //
    Board_init();

    //
    // Enable sync and clock to PWM
    //
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    //
    // Enable Global Interrupt (INTM) and realtime interrupt (DBGM)
    //
    EINT;
    ERTM;


    for(;;)
    {
       for(i=1; i<LAST_EPWM_INDEX_FOR_EXAMPLE; i++)
       {
				 // UP_Down
			 if( i <=2 )
			 {
				 float32_t count = (EPWM_TIMER_UO_DOWN_TBPRD << 8UL) + (float32_t)(periodFine_Updown * SFO_Params.HR_mstep_Auto);
				 uint32_t compCount = count;
				 HRPWM_setTimeBasePeriod(ePWM[i], compCount);

			 }else
			 {
				 // UP
				 float32_t count = ((EPWM_TIMER_UP_TBPRD-1) << 8UL) + (float32_t)(periodFine_Up * SFO_Params.HR_mstep_Auto);
				 uint32_t compCount = count;
				 HRPWM_setTimeBasePeriod(ePWM[i], compCount);
			  }

        }

             //
             // Call the scale factor optimizer lib function SFO()
             // periodically to track for any change due to temp/voltage.
             // This function generates MEP_ScaleFactor by running the
             // MEP calibration module in the HRPWM logic. This scale
             // factor can be used for all HRPWM channels. The SFO()
             // function also updates the HRMSTEP register with the
             // scale factor value.
             //

		 SFO_Status = SFO(&SFO_Params); // in background, MEP calibration module
										 // continuously updates MEP_ScaleFactor

		 if (SFO_Success != SFO_Status)
		 {
			 error();   // Look at the enumeration type to see the error type

		 }
    }

}

//
// error - Halt debugger when called
//
void error (void)
{
    ESTOP0;         // Stop here and handle error
}


