/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hrpwm_ex05_board.c
*   @brief
*   @details
*
*/

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "hrpwm_ex05_board.h"


//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	EALLOW;

	PinMux_init();
	EPWM1_init();
	EPWM2_init();
	EPWM3_init();
	EPWM4_init();

	EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
	//
	// PinMux for modules assigned to CPU1
	//

	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM2 -> myEPWM2 Pinmux
	//
	GPIO_setPinConfig(myEPWM2_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM2_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM2_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM2_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM2_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM2_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM3 -> myEPWM3 Pinmux
	//
	GPIO_setPinConfig(myEPWM3_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM3_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM3_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM3_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM3_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM3_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM4 -> myEPWM4 Pinmux
	//
	GPIO_setPinConfig(myEPWM4_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM4_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM4_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM4_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM4_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM4_EPWMB_GPIO, GPIO_QUAL_SYNC);


}

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
void EPWM1_init()
{
	//HRPWM1
	//TB
	//  ģʽ
    HRPWM_setEmulationMode(myEPWM1_BASE, EPWM_EMULATION_FREE_RUN);
	//	ePWMʱ1Ƶ
	HRPWM_setClockPrescaler(myEPWM1_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	//	ģʽ¼
	HRPWM_setTimeBaseCounterMode(myEPWM1_BASE, EPWM_COUNTER_MODE_UP_DOWN);
	//	ֵTBPRD = 180
	EPWM_setTimeBasePeriod(myEPWM1_BASE, 180);
    //	ֵTBCTR = 0
	HRPWM_setTimeBaseCounter(myEPWM1_BASE, 0);
    //	ฺʧ
	EPWM_disablePhaseShiftLoad(myEPWM1_BASE);
    //	߾ฺʧ
    HRPWM_disablePhaseShiftLoad(myEPWM1_BASE);
    //	ֵTBPHS = 0  ߾ֵ: TBPHSHR = 0
	HRPWM_setPhaseShift(myEPWM1_BASE,0);
    //	ePWM1ڼֵ TBCTR = 0 ͬź
    EPWM_enableSyncOutPulseSource(myEPWM1_BASE, EPWM_SYNC_OUT_PULSE_ON_CNTR_ZERO);


	//CC
    //	ñȽAֵCMPA = 90
    EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, 90);
    //	ñȽAļģʽTBCTR = 0 ʱµCMPA
    HRPWM_setCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
    //	ñȽBֵCMPB = 90
    EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, 90);
    //	ñȽBļģʽTBCTR = 0 ʱµCMPB
    HRPWM_setCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);


    //AQ
    //	Aͨ¼: TBCTR = UP_CMPA -> ePWM1AHIGH
    HRPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //	Aͨ¼: TBCTR = Down_CMPA -> ePWM1BLOW
    HRPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
    //	Aͨ¼ӰӼģʽ -> Aͨ¼Ϊ
    HRPWM_disableActionQualifierShadowLoadMode(myEPWM1_BASE,EPWM_ACTION_QUALIFIER_A);
    //	Bͨ¼: TBCTR = UP_CMPB -> ePWM1AHIGH
    HRPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    //	Bͨ¼: TBCTR = Down_CMPB -> ePWM1BLOW
    HRPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
    //	Bͨ¼ӰӼģʽ -> Bͨ¼Ϊ
    HRPWM_disableActionQualifierShadowLoadMode(myEPWM1_BASE,EPWM_ACTION_QUALIFIER_B);
}

void EPWM2_init()
{

	//HRPWM2
	//TB
	//  ģʽ
    HRPWM_setEmulationMode(myEPWM2_BASE, EPWM_EMULATION_FREE_RUN);
	//	ePWMʱ1Ƶ
	HRPWM_setClockPrescaler(myEPWM2_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	//	ģʽ¼
	HRPWM_setTimeBaseCounterMode(myEPWM2_BASE, EPWM_COUNTER_MODE_UP_DOWN);
	//	ֵTBPRD = 180
	EPWM_setTimeBasePeriod(myEPWM2_BASE, 180);
    //	ֵTBCTR = 0
	HRPWM_setTimeBaseCounter(myEPWM2_BASE, 0);
    //	ฺʹ
    EPWM_enablePhaseShiftLoad(myEPWM2_BASE);
    //	߾ฺʹ
    HRPWM_enablePhaseShiftLoad(myEPWM2_BASE);
    //	ֵTBPHS = 0  ߾ֵ: TBPHSHR = 0
    HRPWM_setPhaseShift(myEPWM2_BASE, 0);
    //	ePWM1ͬźΪePWM2ͬźԴ
    EPWM_setSyncInPulseSource(myEPWM2_BASE, EPWM_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM1);
    //	ͬźŵʱֵ
    HRPWM_selectPeriodLoadEvent(myEPWM2_BASE, EPWM_SHADOW_LOAD_MODE_SYNC);


	//CC
    //	ñȽAֵCMPA = 90
    EPWM_setCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_A, 90);
    //	ñȽAļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPA
    EPWM_setCounterCompareShadowLoadMode(myEPWM2_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
    //	ñȽBֵCMPB = 90
    EPWM_setCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_B, 90);
    //	ñȽBļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPB
    EPWM_setCounterCompareShadowLoadMode(myEPWM2_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);


    //AQ
    //	Aͨ¼: TBCTR = UP_CMPA -> ePWM2AHIGH
    HRPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //	Aͨ¼: TBCTR = Down_CMPA -> ePWM2ALOW
    HRPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
    //	Aͨ¼ӰӼģʽ -> Aͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM2_BASE,EPWM_ACTION_QUALIFIER_A);
    //	Bͨ¼: TBCTR = UP_CMPB -> ePWM2BHIGH
    HRPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    //	Bͨ¼: TBCTR = Down_CMPB -> ePWM2BLOW
    HRPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
    //	Bͨ¼ӰӼģʽ -> Bͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM2_BASE,EPWM_ACTION_QUALIFIER_B);


    //HR
    //	ʹԶת
    HRPWM_enableAutoConversion(myEPWM2_BASE);
    //	Aͨɸ߾λ TBPHSHR 
    HRPWM_setMEPControlMode(myEPWM2_BASE,HRPWM_CHANNEL_A,HRPWM_MEP_PHASE_CTRL);
    //	Aͨʹ˫ؿ
    HRPWM_setMEPEdgeSelect(myEPWM2_BASE, HRPWM_CHANNEL_A,HRPWM_MEP_CTRL_RISING_AND_FALLING_EDGE);
    //	Bͨɸ߾λ TBPHSHR 
    HRPWM_setMEPControlMode(myEPWM2_BASE,HRPWM_CHANNEL_B,HRPWM_MEP_PHASE_CTRL);
    //	Bͨʹ˫ؿ
    HRPWM_setMEPEdgeSelect(myEPWM2_BASE, HRPWM_CHANNEL_B,HRPWM_MEP_CTRL_RISING_AND_FALLING_EDGE);


}

void EPWM3_init()
{

	//HRPWM3
	//TB
	//  ģʽ
    HRPWM_setEmulationMode(myEPWM3_BASE, EPWM_EMULATION_FREE_RUN);
	//	ePWMʱ1Ƶ
	HRPWM_setClockPrescaler(myEPWM3_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	//	ģʽϼ
	HRPWM_setTimeBaseCounterMode(myEPWM3_BASE, EPWM_COUNTER_MODE_UP);
	//	ֵTBPRD = 359
	EPWM_setTimeBasePeriod(myEPWM3_BASE, 359);
    //	ֵTBCTR = 0
	HRPWM_setTimeBaseCounter(myEPWM3_BASE, 0);
    //	ฺʧ
	EPWM_disablePhaseShiftLoad(myEPWM3_BASE);
    //	߾ฺʧ
    HRPWM_disablePhaseShiftLoad(myEPWM3_BASE);
    //	ֵTBPHS = 0  ߾ֵ: TBPHSHR = 0
	HRPWM_setPhaseShift(myEPWM3_BASE,0);
    //	ePWM1ڼֵ TBCTR = 0 ͬź
    EPWM_enableSyncOutPulseSource(myEPWM3_BASE, EPWM_SYNC_OUT_PULSE_ON_CNTR_ZERO);

	//CC
    //	ñȽAֵCMPA = 180
    EPWM_setCounterCompareValue(myEPWM3_BASE, EPWM_COUNTER_COMPARE_A, 180);
    //	ñȽAļģʽTBCTR = 0 ʱµCMPA
    HRPWM_setCounterCompareShadowLoadMode(myEPWM3_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
    //	ñȽBֵCMPB = 180
    EPWM_setCounterCompareValue(myEPWM3_BASE, EPWM_COUNTER_COMPARE_B, 180);
    //	ñȽBļģʽTBCTR = 0 ʱµCMPB
    HRPWM_setCounterCompareShadowLoadMode(myEPWM3_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);


    //AQ
    //	Aͨ¼: TBCTR = 0 -> ePWM3AHIGH
    HRPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    //	Aͨ¼: TBCTR = UP_CMPA -> ePWM3ALOW
    HRPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //	Aͨ¼ӰӼģʽ -> Aͨ¼Ϊ
    HRPWM_disableActionQualifierShadowLoadMode(myEPWM3_BASE,EPWM_ACTION_QUALIFIER_A);
    //	Bͨ¼: TBCTR = 0 -> ePWM3BHIGH
    HRPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    //	Bͨ¼: TBCTR = UP_CMPB -> ePWM3BLOW
    HRPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    //	Bͨ¼ӰӼģʽ -> Bͨ¼Ϊ
    HRPWM_disableActionQualifierShadowLoadMode(myEPWM3_BASE,EPWM_ACTION_QUALIFIER_B);

}

void EPWM4_init()
{

	//HRPWM4
	//TB
	//  ģʽ
    HRPWM_setEmulationMode(myEPWM4_BASE, EPWM_EMULATION_FREE_RUN);
	//	ePWMʱ1Ƶ
	HRPWM_setClockPrescaler(myEPWM4_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	//	ģʽϼ
	HRPWM_setTimeBaseCounterMode(myEPWM4_BASE, EPWM_COUNTER_MODE_UP);
	//	ֵTBPRD = 359
	EPWM_setTimeBasePeriod(myEPWM4_BASE, 359);
    //	ֵTBCTR = 0
	HRPWM_setTimeBaseCounter(myEPWM4_BASE, 0);
    //	ฺʹ
    EPWM_enablePhaseShiftLoad(myEPWM4_BASE);
    //	߾ฺʹ
    HRPWM_enablePhaseShiftLoad(myEPWM4_BASE);
    //	ֵTBPHS = 0  ߾ֵ: TBPHSHR = 0
    HRPWM_setPhaseShift(myEPWM4_BASE, 0);
    //	ePWM3ͬźΪePWM4ͬźԴ
    EPWM_setSyncInPulseSource(myEPWM4_BASE, EPWM_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM3);
    //	ͬźŵʱֵ
    HRPWM_selectPeriodLoadEvent(myEPWM4_BASE, EPWM_SHADOW_LOAD_MODE_SYNC);


	//CC
    //	ñȽAֵCMPA = 180
    EPWM_setCounterCompareValue(myEPWM4_BASE, EPWM_COUNTER_COMPARE_A, 180);
    //	ñȽAļģʽTBCTR = 0 ʱµCMPA
    EPWM_setCounterCompareShadowLoadMode(myEPWM4_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
    //	ñȽBֵCMPB = 180
    EPWM_setCounterCompareValue(myEPWM4_BASE, EPWM_COUNTER_COMPARE_B, 180);
    //	ñȽBļģʽTBCTR = 0 ʱµCMPB
    EPWM_setCounterCompareShadowLoadMode(myEPWM4_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);

    //AQ
    //	Aͨ¼: TBCTR = 0 -> ePWM4AHIGH
    HRPWM_setActionQualifierAction(myEPWM4_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    //	Aͨ¼: TBCTR = UP_CMPA -> ePWM4ALOW
    HRPWM_setActionQualifierAction(myEPWM4_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //	Aͨ¼ӰӼģʽ -> Aͨ¼Ϊ
    HRPWM_disableActionQualifierShadowLoadMode(myEPWM4_BASE,EPWM_ACTION_QUALIFIER_A);
    //	Bͨ¼: TBCTR = 0 -> ePWM4BHIGH
    HRPWM_setActionQualifierAction(myEPWM4_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    //	Bͨ¼: TBCTR = UP_CMPB -> ePWM4BLOW
    HRPWM_setActionQualifierAction(myEPWM4_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    //	Bͨ¼ӰӼģʽ -> Bͨ¼Ϊ
    HRPWM_disableActionQualifierShadowLoadMode(myEPWM4_BASE,EPWM_ACTION_QUALIFIER_B);


    //HR
    //	ʹԶת
    HRPWM_enableAutoConversion(myEPWM4_BASE);
    //	Aͨɸ߾λ TBPHSHR 
    HRPWM_setMEPControlMode(myEPWM4_BASE,HRPWM_CHANNEL_A,HRPWM_MEP_PHASE_CTRL);
    //	Aͨʹ˫ؿ
    HRPWM_setMEPEdgeSelect(myEPWM4_BASE, HRPWM_CHANNEL_A,HRPWM_MEP_CTRL_RISING_AND_FALLING_EDGE);
    //	Bͨɸ߾λ TBPHSHR 
    HRPWM_setMEPControlMode(myEPWM4_BASE,HRPWM_CHANNEL_B,HRPWM_MEP_PHASE_CTRL);
    //	Aͨʹ˫ؿ
    HRPWM_setMEPEdgeSelect(myEPWM4_BASE, HRPWM_CHANNEL_B,HRPWM_MEP_CTRL_RISING_AND_FALLING_EDGE);


}


