/*
 * 	File: hrpwm_ex05_phase_sfo
 *
 *	ʾHRPWMĸ߾λЧ(߾λDownģʽ)
 *
 *
 *	ePWM1\2Ϊһ  Up_Downģʽʾ
 *	ʾePWM1A ->IO0ePWM2A->IO2۲첨νǶ
 *	ʼλΪ 90.75
 *	ûɿ PhaseInt1  ֵλ
 *	ûɿ PhaseFine1 ֵλС
 *
 *
 *	ePWM3\4Ϊһ  Upģʽʾ
 *	ʾePWM2A ->IO2ePWM2B->IO3۲첨
 *	ʼλΪ 90.25
 *	ûɿ PhaseInt2  ֵλ
 *	ûɿ PhaseFine2 ֵλС
 *
 *
 *
 *
*/
/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "hrpwm_ex05_board.h"
#include "SFO_v2.h"

//SOF״̬
SFO_Status_t SFO_Status;
//SOFṹ
SFO_Params_t SFO_Params;

//ĺͬʱ2̶ֵλӳ(ƫ)
//ܽƫ StaticError1  StaticError2 Ϊ0


//Up-Down
float32_t StaticError1 = 2.0305f;  //̬ҪûԼ
uint32_t  PhaseInt1    = 90;        
float32_t PhaseFine1   = 0.75;

//Up
float32_t StaticError2 = 3.8225f;  //̬ҪûԼ
uint32_t  PhaseInt2    = 90;
float32_t PhaseFine2   = 0.25;

void error (void);
void configurePhase(uint32_t base, uint32_t masterBase, float32_t phaseVal);

int main(void)
{
    //
    // Initialize device clock and peripherals
    //
    Device_init();

    SFO_Struct_init(&SFO_Params,5);

    do
    {
    	SFO_Status = SFO(&SFO_Params);

        if(SFO_Success != SFO_Status)
        {
            error();   	//Look at the enumeration type to see the error type
        }
    }while(SFO_Status != SFO_Success);

    SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    Board_init();

    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    //
    // Enable Global Interrupt (INTM) and realtime interrupt (DBGM)
    //
    EINT;
    ERTM;


    while (1)
    {

        // λʽһΪUpDownģʽTBPHSļغĬ¼UPģʽϼ
    	//
    	//Up-Down
        configurePhase(myEPWM2_BASE,myEPWM1_BASE,PhaseInt1 + PhaseFine1 - StaticError1);

    	//Up
        configurePhase(myEPWM4_BASE,myEPWM3_BASE,PhaseInt2 - PhaseFine2 + StaticError2);




        SFO(&SFO_Params);

        if(SFO_Success != SFO_Status)
        {
            error();   	//Look at the enumeration type to see the error type
        }

        DEVICE_DELAY_US(1000);
    }

    return 0;
}


//
// error - Halt debugger when called
//
void error (void)
{
    ESTOP0;         // Stop here and handle error
}


//
// configurePhase - Configure ePWMx Phase
//
void configurePhase(uint32_t base, uint32_t masterBase, float32_t phaseVal)
{
    float32_t readPrdVal, phaseRegVal;

    if( phaseVal < 0)
    {
        phaseVal = 0;
    }

    //
    // Read Period value to calculate value for Phase Register
    //
    readPrdVal = EPWM_getTimeBasePeriod(masterBase);

    //
    // Caluclate phase register values based on Time Base counter mode
    //
    if((HWREGH(base + EPWM_O_TBCTL) & 0x3U) == EPWM_COUNTER_MODE_UP_DOWN )
    {

        phaseRegVal  = ((2.0f * readPrdVal * phaseVal) / 360.0f ) ;

        phaseRegVal *= 256;

    }
    else if((HWREGH(base + EPWM_O_TBCTL) & 0x3U) == EPWM_COUNTER_MODE_UP )
    {
        phaseRegVal  = ((readPrdVal+1) * phaseVal) / 360.0f ;

        phaseRegVal *= 256;
    }

    HRPWM_setPhaseShift(base, phaseRegVal);

}
