/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 * @examplespi loopback dma
 * @brief  
 *   SPI uses DMA for internal loopback testing.
 *
 *   This test routine uses DMA combined with SPI for the internal loopback test
 *   of data transmission. The DMA trigger thresholds (RXFFIL and TXFFIL) for SPITX
 *   and SPIRX are configured. After the SPI triggers the DMA sending request,
 *   the DMA will transfer the data in sdata byte by byte to SPITXBUF. When the
 *   received data by SPI reaches the FIFO waterline threshold, it will trigger
 *   the DMA receiving request. At this point, the DMA will transfer the data in
 *   the FIFO to rdata, and after transmitting 512 data, a verification will be
 *   conducted (block size is 128).
 *
 *   Watch Variables:
 *                   - sData[512] - Data to send
 *                   - rData[512] - Received data
 *
 * @note:
 *   1.To utilize the DMA function, it is necessary to employ the FIFO mode and
 *     set the FIFO waterline.
 *   2.Avoid setting the transmit FIFO waterline (TXFFIL) to 0h or 10h to ensure
 *     that the DMA configuration is correct.
 *   3.Avoid setting the Receive FIFO Waterline (RXFFIL) to 0h to ensure
 *     that the DMA configuration is correct.
 *
 */

/**
 * @examplespi loopback dma
 * @brief  
 *   SPIʹDMAڲز
 *
 *   ʹDMASPIڲزݵĴ䡣SPITXSPIRXDMAֵ
 *  RXFFIL and TXFFILSPIDMADMAὫsdataеݰְ˵SPITXBUF
 *   SPIյݴﵽFIFOˮֵʱᴥDMA󣬴ʱDMAὫFIFOеݰ˵rdataУ
 *   512ݺУ飨blockСΪ128
 *
 *   :
 *           - sData - ͵
 *           - rData - յ
 *           - rDataPoint - ڼ¼еλãԱд顣
 *
 * @note:
 *   1.ʹDMAܣʹFIFOģʽFIFOˮ;
 *   2.⽫FIFOˮ(TXFFIL)Ϊ 0h  10hȷDMA;
 *   3.⽫FIFOˮ(RXFFIL)Ϊ 0hȷDMA
 *
 */

#include "device.h"
#include "log.h"
#include "spi_loopback_dma.h"

int main(void)
{
    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_set_level(LOG_DEBUG);

    __disable_irq();

    /** @brief Initialize the SPI version 3.0 (Clock,Pinmux and Function). */
    spi_init();

    __enable_irq();

    spi_process();

    while (1) {

    }

    return 0;
}
