#ifndef UID_IP_8_H
#define UID_IP_8_H

#include <stdint.h>
#include <string.h>
#define DATE_TIME_ADDRESS 0x1fff40b0
#define DATE_IP_ADDRESS 0x1fff40b6
#define DATE_serial_ADDRESS 0x1fff40ba
typedef struct {
    uint8_t second;
    uint8_t minute;
    uint8_t hour;
    uint8_t day;
    uint8_t month;
    uint8_t year;
} DateTime;

typedef struct {
    uint32_t timestamp;
    uint32_t ip_serial;
} UniqueID;

uint32_t datetime_to_seconds(const DateTime* dt);
void seconds_to_datetime(uint32_t seconds, DateTime* dt);
void create_unique_id(const DateTime* dt, uint32_t ip, uint8_t serial, uint8_t* output);
void parse_unique_id(const uint8_t* input, UniqueID* unique_id);
uint32_t ip_string_to_uint(const char* ip_str);
void ip_uint_to_string(uint32_t ip, char* buffer);
uint32_t extract_ip_from_serial(uint32_t ip_serial);
uint8_t extract_serial_from_ip_serial(uint32_t ip_serial);
uint64_t get_uid_8();
#endif
