/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    board_cfg.h
*   @brief   board level configurations
*
*/

#ifndef __BOARD_CFG_H__
#define __BOARD_CFG_H__

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */


/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/****************************************************
    GS32_PART_NUM == 0x0039; => 0039
    GS32_PART_NUM == 0x0049; => 0049
    GS32_PART_NUM == 0x0025A; => 0025A

    GS32_PIN_COUNT == 100 => 100pin
    GS32_PIN_COUNT == 80 =>  80pin
    GS32_PIN_COUNT == 64 =>  64pin
******************************************************/

/**
  * @brief Configuration of the CRG
  */

/* ʹⲿپ */
#define __HSE_ENABLE                    1 

/* ⲿ: 0 Դ, 1 Դ */
#define __HSE_CLOCK_TYPE                0

/* 趨PLLʱԴƵ: 10MHz IRC10MHz/20MHzⲿ */
#if __HSE_ENABLE == 0
    #define DEVICE_OSCSRC_FREQ          (10*1000*1000U)
#else
    #define DEVICE_OSCSRC_FREQ          (20*1000*1000U)
#endif

/* ϵͳʱ <= 180MHz  */
#define DEVICE_SYSCLK_FREQ              (120*1000*1000U)

/* ϵͳʱӷƵ */
#define DEVICE_SYSCLK_DIV               (2)

/* PLLʱ */
#define DEVICE_PLLCLK_FREQ              (DEVICE_SYSCLK_FREQ * DEVICE_SYSCLK_DIV)

/* AHBʱӷƵ */
#define DEVICE_AHBCLK_DIV               (2)

/* AHBʱӵϵͳʱ */
#define DEVICE_AHBCLK_FREQ              (DEVICE_SYSCLK_FREQ/DEVICE_AHBCLK_DIV)

/* APBʱӷƵ = 1248 */
#define DEVICE_APBCLK_DIV               (4)

/* APBʱƵ MHz */
#define DEVICE_APBCLK_FREQ              (DEVICE_SYSCLK_FREQ/DEVICE_APBCLK_DIV)

/* ʱʱƵʵAPBʱƵ */
#define SOC_TIMER_FREQ                  (DEVICE_APBCLK_FREQ)

/**
  * @brief Configuration of the LED pins
  */


/**
  * @brief Configuration of the SCI pins
  */



#define LOG_SCI_BASE                    SCIA_BASE

#ifdef __cplusplus
}
#endif

#endif  /* __BOARD_CFG_H__ */
