/*
 *   Copyright (c) GeJian Semiconductors 2025
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "flash_programming_gs32.h"
#include "gs32_flashAPI_lib.h"
/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
volatile uint16_t nmiflag;
void user_default_exception_handler(unsigned long mcause, unsigned long sp)
{
	nmiflag = SysCtl_getNMIFlagStatus();
	while(1);
}
/**
  * @brief  main function.
  * @param  None
  * @return None
  */
int main(void)
{
	/**
	*   @details  ʾFlash˫bitECC
	*   쳣
	*
	*   ɹ۲ĴԼ쳣
	*   EFC1 => flash_status_register : DED_DETECTED˫bitECC⵽
	*	NMI_WDG_PARA => DSP0_NMI_CLG(SysCtl_getNMIFlagStatus())
	*	variable : exc_info
	*	$mcause
	*   $mdcause
	*/
    __disable_irq();

    Device_init();

    GS32Fapi_Init(DEVICE_SYSCLK_FREQ);
    extern void Flash_UnLockReg(uint32 flashCtlBase);
	Flash_UnLockReg(FLASH_INTERFACE_EFC_BASE);
	//ECCжϣ˫bitжʹ
	HWREG(FLASH_INTERFACE_EFC_BASE + FLASH_O_STATUS) = FLASH_STATUS_ALL;
	HWREG(FLASH_INTERFACE_EFC_BASE) |= (1<<9);  //ʹܴϱ
	HWREG(FLASH_INTERFACE_EFC_BASE) |= (1<<11); //ʹECCж
	HWREG(FLASH_INTERFACE_EFC_BASE) |= (1<<12); //ʹ˫bitж
	extern void Flash_LockReg(uint32 flashCtlBase);
	Flash_LockReg(FLASH_INTERFACE_EFC_BASE);

	volatile Fapi_StatusType oReturnCheck = Fapi_Status_Success;
	oReturnCheck = Fapi_issueAsyncCommand(Fapi_FlashBank0, Fapi_ClearMore);
	oReturnCheck = Fapi_issueAsyncCommandWithAddress(Fapi_FlashBank0, Fapi_EraseSector, (uint32 *)0x08020000);
	while (Fapi_checkFsmForReady(Fapi_FlashBank0) != Fapi_Status_FsmReady){}
	volatile uint32_t r1;
	volatile uint32_t data[4] = {0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF,0xFFFFFFFF};
	oReturnCheck = Fapi_issueProgrammingCommand(Fapi_FlashBank0, (uint32 *)0x08020000, (uint16 *)(data), 8, 0, 0, Fapi_AutoEccGeneration);
	while(Fapi_checkFsmForReady(Fapi_FlashBank0) == Fapi_Status_FsmBusy);
	data[0] = 0xAAAAAAAA;//eraseprogramECC
	oReturnCheck = Fapi_issueProgrammingCommand(Fapi_FlashBank0, (uint32 *)0x08020000, (uint16 *)(data), 8, 0, 0, Fapi_AutoEccGeneration);
	while(Fapi_checkFsmForReady(Fapi_FlashBank0) == Fapi_Status_FsmBusy);
	r1 = HWREG(0x08020000);
    while (1) {
    }

    for(;;);

    return 0;
}

#ifdef __cplusplus
}
#endif
