/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    gcc_gs32f3xx_regs.ld
*   @brief   
*   @details
*
*/

/*
 * commit history
 * 20240324, Jason, initial release
 * 20240410, Jason, change NOLOAD to COPY so that these sections are not counted as bss
 * 20240708. Hezhiyuan, update peripheral registers for 2.2
 * 20240809, WenGuangYong,add peripheral SDFM FOR 2.2
 * 20240927, Zhengyulong,add APB_COMM_PARA register in lines 230-232,407,1148-1153
 */
/********************  CMPSS registers *********************/
__CMPSS1_REGS_BASE = 0x40040000;
__CMPSS2_REGS_BASE = 0x40040200;
__CMPSS3_REGS_BASE = 0x40040400;
__CMPSS4_REGS_BASE = 0x40040600;
__CMPSS5_REGS_BASE = 0x40040800;
__CMPSS6_REGS_BASE = 0x40040A00;
__CMPSS7_REGS_BASE = 0x40040C00;
__CMPSS8_REGS_BASE = 0x40040E00;
__CMPSS9_REGS_BASE = 0x40041000;
__CMPSS10_REGS_BASE = 0x40041200;
__CMPSS11_REGS_BASE = 0x40041400;
__CMPSS12_REGS_BASE = 0x40041600;
__CMPSS_REGS_SIZE = 0x00000200;

/********************  EPWM registers *********************/
__PREEPWM_REGS_BASE = 0x40008000;
__EPWM1_REGS_BASE = 0x40008800;
__EPWM2_REGS_BASE = 0x40009000;
__EPWM3_REGS_BASE = 0x40009800;
__EPWM4_REGS_BASE = 0x4000A000;
__EPWM5_REGS_BASE = 0x4000A800;
__EPWM6_REGS_BASE = 0x4000B000;
__EPWM7_REGS_BASE = 0x4000B800;
__EPWM8_REGS_BASE = 0x4000C000;
__EPWM9_REGS_BASE = 0x4000C800;
__EPWM10_REGS_BASE = 0x4000D000;
__EPWM11_REGS_BASE = 0x4000D800;
__EPWM12_REGS_BASE = 0x4000E000;
__EPWM13_REGS_BASE = 0x4000E800;
__EPWM14_REGS_BASE = 0x4000F000;
__EPWM15_REGS_BASE = 0x4000F800;
__EPWM16_REGS_BASE = 0x40010000;
__EPWM17_REGS_BASE = 0x40010800;  
__EPWM18_REGS_BASE = 0x40011000;  
__EPWM_REGS_SIZE = 0x00000800;

__EPWM1_EXTEND_REGS_BASE = 0x40008BFC;
__EPWM2_EXTEND_REGS_BASE = 0x400093FC;
__EPWM3_EXTEND_REGS_BASE = 0x40008BFC;
__EPWM4_EXTEND_REGS_BASE = 0x4000A3FC;
__EPWM5_EXTEND_REGS_BASE = 0x4000ABFC;
__EPWM6_EXTEND_REGS_BASE = 0x4000B3FC;
__EPWM7_EXTEND_REGS_BASE = 0x4000BBFC;
__EPWM8_EXTEND_REGS_BASE = 0x4000C3FC;
__EPWM9_EXTEND_REGS_BASE = 0x4000CBFC;
__EPWM10_EXTEND_REGS_BASE = 0x4000D3FC;
__EPWM11_EXTEND_REGS_BASE = 0x4000DBFC;
__EPWM12_EXTEND_REGS_BASE = 0x4000E3FC;
__EPWM13_EXTEND_REGS_BASE = 0x4000EBFC;
__EPWM14_EXTEND_REGS_BASE = 0x4000F3FC;
__EPWM15_EXTEND_REGS_BASE = 0x4000FBFC;
__EPWM16_EXTEND_REGS_BASE = 0x400103FC;
__EPWM17_EXTEND_REGS_BASE = 0x40010BFC;  
__EPWM18_EXTEND_REGS_BASE = 0x400113FC; 
__EPWM_EXTEND_REGS_SIZE = 0x00000300;

/********************  ADC registers *********************/
__ADCA_REGS_BASE = 0x40000000;
__ADCB_REGS_BASE = 0x40000800;
__ADCC_REGS_BASE = 0x40001000;
__ADCD_REGS_BASE = 0x40001800;
__ADC_REGS_SIZE = 0x00000800;

/********************  ADC result registers *********************/
__ADCARESULT_REGS_BASE = 0x40000400;
__ADCBRESULT_REGS_BASE = 0x40000C00;
__ADCCRESULT_REGS_BASE = 0x40001400;
__ADCDRESULT_REGS_BASE = 0x40001C00;
__ADCRESULT_REGS_SIZE = 0x00000400;



/********************  ECAP registers *********************/
__ECAP1_REGS_BASE = 0x40028000;
__ECAP2_REGS_BASE = 0x40028200;
__ECAP3_REGS_BASE = 0x40028400;
__ECAP4_REGS_BASE = 0x40028600;
__ECAP5_REGS_BASE = 0x40028800;
__ECAP6_REGS_BASE = 0x40028A00;
__ECAP7_REGS_BASE = 0x40028C00;
__ECAP_REGS_SIZE = 0x00000200;  

/********************  EQEP registers *********************/
__EQEP1_REGS_BASE = 0x40030000;
__EQEP2_REGS_BASE = 0x40030200;
__EQEP3_REGS_BASE = 0x40030400;
__EQEP4_REGS_BASE = 0x40030600;
__EQEP5_REGS_BASE = 0x40030800;
__EQEP6_REGS_BASE = 0x40030A00;
__EQEP_REGS_SIZE = 0x00000200;  

/********************  DAC registers *********************/
__DACA_REGS_BASE = 0x40080000;
__DACB_REGS_BASE = 0x40080200;
__DACC_REGS_BASE = 0x40080400;
__DAC_REGS_SIZE = 0x00000200;

/********************  SDFM registers *********************/
__SDFM1_REGS_BASE = 0x40043000;
__SDFM2_REGS_BASE = 0x40043200;
__SDFM3_REGS_BASE = 0x40043400;
__SDFM4_REGS_BASE = 0x40043600;
__SDFM_REGS_SIZE = 0x00000200;
/********************  CPUTimer registers *********************/
__CPUTIME0_REGS_BASE = 0x400C8000;
__CPUTIME1_REGS_BASE = 0x400C8020;
__CPUTIME2_REGS_BASE = 0x400C9000;
__CPUTIME3_REGS_BASE = 0x400C9020;
__CPUTIME4_REGS_BASE = 0x400CA000;
__CPUTIME5_REGS_BASE = 0x400CA020;
__CPUTIME_REGS_SIZE = 0x00000020;

/********************  XBAR registers *********************/
__INPUTXBAR_REGS_BASE    = 0x4006D000;
__INPUTXBAR_REGS_SIZE    = 0x00000040;

__XBAR_REGS_BASE         = 0x4006D040;
__XBAR_REGS_SIZE         = 0x00000080;

__CLBINPUTXBAR_REGS_BASE = 0x4006D0C0;
__CLBINPUTXBAR_REGS_SIZE = 0x00000040;

__EPWMXBAR_REGS_BASE     = 0x4006D100;
__EPWMXBAR_REGS_SIZE     = 0x00000300;

__CLBXBAR_REGS_BASE      = 0x4006D400;
__CLBXBAR_REGS_SIZE      = 0x00000300;

__OUTPUTXBAR_REGS_BASE   = 0x4006D700;
__OUTPUTXBAR_REGS_SIZE   = 0x00000200;

__CLBOUTPUTXBAR_REGS_BASE = 0x4006D900;
__CLBOUTPUTXBAR_REGS_SIZE = 0x00000100;


/********************  GPIO data registers *********************/
__GPIO0_REGS_BASE = 0x40045000;
__GPIO1_REGS_BASE = 0x40046000;
__GPIO2_REGS_BASE = 0x40047000;
__GPIO3_REGS_BASE = 0x40048000;
__GPIO4_REGS_BASE = 0x40049000;
__GPIO5_REGS_BASE = 0x4004A000;
__GPIO6_REGS_BASE = 0x4004B000;
__GPIO7_REGS_BASE = 0x4004C000;
__GPIO8_REGS_BASE = 0x4004D000;
__GPIO9_REGS_BASE = 0x4004E000;
__GPIO10_REGS_BASE = 0x4004F000;
__GPIO11_REGS_BASE = 0x40050000;
__GPIO12_REGS_BASE = 0x40051000;
__GPIO13_REGS_BASE = 0x40052000;
__GPIO_REGS_SIZE = 0x00001000;


/***************** Watchdog ***************/
 __WD0_REGS_BASE =  0x400D1000;
 __WD1_REGS_BASE =  0x400D2000;
 __WD_REGS_SIZE = 0X00001000;


/********************  SysCtl *********************/
__IO_CFG_REGS_BASE = 0x400CC000;
__IO_CFG_REGS_SIZE = 0x00001000;

__ANACFG_REGS_BASE = 0x400CD000;
__ANACFG_REGS_SIZE = 0x00001000;

__CRGCFG_REGS_BASE = 0x400CD000;
__CRGCFG_REGS_SIZE = 0x00001000;

__SYSCTL_REGS_BASE = 0x400CF000;
__SYSCTL_REGS_SIZE = 0x00001000;


 /********************  DMA CORE0 *********************/
__DMA_REGS_BASE = 0x40082000;
__DMA_CH0_REGS_BASE = 0x40082100;
__DMA_CH1_REGS_BASE = 0x40082200;
__DMA_CH2_REGS_BASE = 0x40082300;
__DMA_CH3_REGS_BASE = 0x40082400;
__DMA_CH4_REGS_BASE = 0x40082500;
__DMA_CH5_REGS_BASE = 0x40082600;
__DMA_CH6_REGS_BASE = 0x40082700;
__DMA_CH7_REGS_BASE = 0x40082800;
__DMA_CH_REGS_SIZE = 0x00000100;

__DMA_MUX_REGS_BASE = 0x40085000;
__DMA_MUX_REGS_SIZE = 0x00001000;


 /********************  DMA CORE1 *********************/
__DMA1_REGS_BASE = 0x4008F000;
__DMA1_CH0_REGS_BASE = 0x4008F100;
__DMA1_CH1_REGS_BASE = 0x4008F200;
__DMA1_CH2_REGS_BASE = 0x4008F300;
__DMA1_CH3_REGS_BASE = 0x4008F400;
__DMA1_CH4_REGS_BASE = 0x4008F500;
__DMA1_CH5_REGS_BASE = 0x4008F600;
__DMA1_CH6_REGS_BASE = 0x4008F700;
__DMA1_CH7_REGS_BASE = 0x4008F800;
__DMA1_CH_REGS_SIZE = 0x00000100;

__DMA1_MUX_REGS_BASE = 0x40092000;
__DMA1_MUX_REGS_SIZE = 0x00001000;

 /********************  eFlash *********************/
__FLASH0_INTERFACE_REGS_BASE = 0x40087000;
__FLASH1_INTERFACE_REGS_BASE = 0x400E3000;
__FLASH_INTERFACE_REGS_SIZE = 0x00006000;


/********************  CRC registers *********************/
__CRC_REGS_BASE = 0x40088000;
__CRC_REGS_SIZE = 0x00000200;

/***************  APB_COMM_PARA registers ****************/
__APBCOMMPARA_REGS_BASE = 0x400C0000;
__APBCOMMPARA_REGS_SIZE = 0x00001000;

/********************  SCI registers *********************/
__SCIA_REGS_BASE = 0x400C1000;
__SCIB_REGS_BASE = 0x400C1200;
__SCIC_REGS_BASE = 0x400C1400;
__SCI_REGS_SIZE  = 0x00000200;

/********************  SPI registers *********************/
__SPIA_REGS_BASE = 0x400C3000;
__SPIB_REGS_BASE = 0x400C3200;
__SPIC_REGS_BASE = 0x400C3400;
__SPID_REGS_BASE = 0x400C3600;
__SPI_REGS_SIZE  = 0x00000200;

/********************  I2C registers *********************/
__I2CA_REGS_BASE = 0x400C2000;
__I2CB_REGS_BASE = 0x400C2200;
__I2CC_REGS_BASE = 0x400C2400;
__I2C_REGS_SIZE  = 0x00000200;

/********************  CAN registers *********************/
__CANA_REGS_BASE = 0x400C4000;
__CANB_REGS_BASE = 0x400C4200;
__CANC_REGS_BASE = 0x400C4400;
__CAND_REGS_BASE = 0x400C4600;
__CAN_REGS_SIZE  = 0x00000200;

/********************  LIN registers *********************/
__LINA_REGS_BASE = 0x400C5000;
__LINB_REGS_BASE = 0x400C5200;
__LIN_REGS_SIZE  = 0x00000200;


/********************  QSPI registers *********************/


MEMORY
{  
  MEM_CMPSS1_REGS (rw) : ORIGIN = __CMPSS1_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS2_REGS (rw) : ORIGIN = __CMPSS2_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS3_REGS (rw) : ORIGIN = __CMPSS3_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS4_REGS (rw) : ORIGIN = __CMPSS4_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS5_REGS (rw) : ORIGIN = __CMPSS5_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS6_REGS (rw) : ORIGIN = __CMPSS6_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS7_REGS (rw) : ORIGIN = __CMPSS7_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS8_REGS (rw) : ORIGIN = __CMPSS8_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS9_REGS (rw) : ORIGIN = __CMPSS9_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS10_REGS (rw) : ORIGIN = __CMPSS10_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS11_REGS (rw) : ORIGIN = __CMPSS11_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS12_REGS (rw) : ORIGIN = __CMPSS12_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE


  MEM_EPWM1_REGS (rw) : ORIGIN = __EPWM1_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM2_REGS (rw) : ORIGIN = __EPWM2_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM3_REGS (rw) : ORIGIN = __EPWM3_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM4_REGS (rw) : ORIGIN = __EPWM4_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM5_REGS (rw) : ORIGIN = __EPWM5_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM6_REGS (rw) : ORIGIN = __EPWM6_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM7_REGS (rw) : ORIGIN = __EPWM7_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM8_REGS (rw) : ORIGIN = __EPWM8_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM9_REGS (rw) : ORIGIN = __EPWM9_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM10_REGS (rw) : ORIGIN = __EPWM10_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM11_REGS (rw) : ORIGIN = __EPWM11_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM12_REGS (rw) : ORIGIN = __EPWM12_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM13_REGS (rw) : ORIGIN = __EPWM13_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM14_REGS (rw) : ORIGIN = __EPWM14_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM15_REGS (rw) : ORIGIN = __EPWM15_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM16_REGS (rw) : ORIGIN = __EPWM16_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM17_REGS (rw) : ORIGIN = __EPWM17_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM18_REGS (rw) : ORIGIN = __EPWM18_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_PREEPWM_REGS (rw) : ORIGIN = __PREEPWM_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  
  MEM_EPWM1_EXTEND_REGS (rw) : ORIGIN = __EPWM1_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM2_EXTEND_REGS (rw) : ORIGIN = __EPWM2_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM3_EXTEND_REGS (rw) : ORIGIN = __EPWM3_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM4_EXTEND_REGS (rw) : ORIGIN = __EPWM4_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM5_EXTEND_REGS (rw) : ORIGIN = __EPWM5_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM6_EXTEND_REGS (rw) : ORIGIN = __EPWM6_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM7_EXTEND_REGS (rw) : ORIGIN = __EPWM7_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM8_EXTEND_REGS (rw) : ORIGIN = __EPWM8_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM9_EXTEND_REGS (rw) : ORIGIN = __EPWM9_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM10_EXTEND_REGS (rw) : ORIGIN = __EPWM10_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM11_EXTEND_REGS (rw) : ORIGIN = __EPWM11_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM12_EXTEND_REGS (rw) : ORIGIN = __EPWM12_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM13_EXTEND_REGS (rw) : ORIGIN = __EPWM13_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM14_EXTEND_REGS (rw) : ORIGIN = __EPWM14_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM15_EXTEND_REGS (rw) : ORIGIN = __EPWM15_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM16_EXTEND_REGS (rw) : ORIGIN = __EPWM16_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM17_EXTEND_REGS (rw) : ORIGIN = __EPWM17_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM18_EXTEND_REGS (rw) : ORIGIN = __EPWM18_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE

  MEM_ADCA_REGS (rw) : ORIGIN = __ADCA_REGS_BASE, LENGTH = __ADC_REGS_SIZE
  MEM_ADCB_REGS (rw) : ORIGIN = __ADCB_REGS_BASE, LENGTH = __ADC_REGS_SIZE
  MEM_ADCC_REGS (rw) : ORIGIN = __ADCC_REGS_BASE, LENGTH = __ADC_REGS_SIZE
  MEM_ADCD_REGS (rw) : ORIGIN = __ADCD_REGS_BASE, LENGTH = __ADC_REGS_SIZE
  
  MEM_ADCARESULT_REGS (rw) : ORIGIN = __ADCARESULT_REGS_BASE, LENGTH = __ADCRESULT_REGS_SIZE
  MEM_ADCBRESULT_REGS (rw) : ORIGIN = __ADCBRESULT_REGS_BASE, LENGTH = __ADCRESULT_REGS_SIZE
  MEM_ADCCRESULT_REGS (rw) : ORIGIN = __ADCCRESULT_REGS_BASE, LENGTH = __ADCRESULT_REGS_SIZE
  MEM_ADCDRESULT_REGS (rw) : ORIGIN = __ADCDRESULT_REGS_BASE, LENGTH = __ADCRESULT_REGS_SIZE

  MEM_ECAP1_REGS (rw) : ORIGIN = __ECAP1_REGS_BASE, LENGTH = __ECAP_REGS_SIZE
  MEM_ECAP2_REGS (rw) : ORIGIN = __ECAP2_REGS_BASE, LENGTH = __ECAP_REGS_SIZE
  MEM_ECAP3_REGS (rw) : ORIGIN = __ECAP3_REGS_BASE, LENGTH = __ECAP_REGS_SIZE
  MEM_ECAP4_REGS (rw) : ORIGIN = __ECAP4_REGS_BASE, LENGTH = __ECAP_REGS_SIZE
  MEM_ECAP5_REGS (rw) : ORIGIN = __ECAP5_REGS_BASE, LENGTH = __ECAP_REGS_SIZE
  MEM_ECAP6_REGS (rw) : ORIGIN = __ECAP6_REGS_BASE, LENGTH = __ECAP_REGS_SIZE
  MEM_ECAP7_REGS (rw) : ORIGIN = __ECAP7_REGS_BASE, LENGTH = __ECAP_REGS_SIZE

  MEM_EQEP1_REGS (rw) : ORIGIN = __EQEP1_REGS_BASE, LENGTH = __EQEP_REGS_SIZE
  MEM_EQEP2_REGS (rw) : ORIGIN = __EQEP2_REGS_BASE, LENGTH = __EQEP_REGS_SIZE
  MEM_EQEP3_REGS (rw) : ORIGIN = __EQEP3_REGS_BASE, LENGTH = __EQEP_REGS_SIZE
  MEM_EQEP4_REGS (rw) : ORIGIN = __EQEP4_REGS_BASE, LENGTH = __EQEP_REGS_SIZE
  MEM_EQEP5_REGS (rw) : ORIGIN = __EQEP5_REGS_BASE, LENGTH = __EQEP_REGS_SIZE
  MEM_EQEP6_REGS (rw) : ORIGIN = __EQEP6_REGS_BASE, LENGTH = __EQEP_REGS_SIZE

  MEM_DACA_REGS (rw) : ORIGIN = __DACA_REGS_BASE, LENGTH = __DAC_REGS_SIZE
  MEM_DACB_REGS (rw) : ORIGIN = __DACB_REGS_BASE, LENGTH = __DAC_REGS_SIZE
  MEM_DACC_REGS (rw) : ORIGIN = __DACC_REGS_BASE, LENGTH = __DAC_REGS_SIZE
  
  MEM_SDFM1_REGS (rw) : ORIGIN = __SDFM1_REGS_BASE, LENGTH = __SDFM_REGS_SIZE
  MEM_SDFM2_REGS (rw) : ORIGIN = __SDFM2_REGS_BASE, LENGTH = __SDFM_REGS_SIZE
  MEM_SDFM3_REGS (rw) : ORIGIN = __SDFM3_REGS_BASE, LENGTH = __SDFM_REGS_SIZE
  MEM_SDFM4_REGS (rw) : ORIGIN = __SDFM4_REGS_BASE, LENGTH = __SDFM_REGS_SIZE

  MEM_CPUTIME0_REGS (rw) : ORIGIN = __CPUTIME0_REGS_BASE, LENGTH = __CPUTIME_REGS_SIZE
  MEM_CPUTIME1_REGS (rw) : ORIGIN = __CPUTIME1_REGS_BASE, LENGTH = __CPUTIME_REGS_SIZE
  MEM_CPUTIME2_REGS (rw) : ORIGIN = __CPUTIME2_REGS_BASE, LENGTH = __CPUTIME_REGS_SIZE
  MEM_CPUTIME3_REGS (rw) : ORIGIN = __CPUTIME3_REGS_BASE, LENGTH = __CPUTIME_REGS_SIZE
  MEM_CPUTIME4_REGS (rw) : ORIGIN = __CPUTIME4_REGS_BASE, LENGTH = __CPUTIME_REGS_SIZE
  MEM_CPUTIME5_REGS (rw) : ORIGIN = __CPUTIME5_REGS_BASE, LENGTH = __CPUTIME_REGS_SIZE

  MEM_INPUTXBAR_REGS (rw) : ORIGIN = __INPUTXBAR_REGS_BASE, LENGTH = __INPUTXBAR_REGS_SIZE
  MEM_XBAR_REGS (rw) : ORIGIN = __XBAR_REGS_BASE, LENGTH = __XBAR_REGS_SIZE
  MEM_CLBINPUTXBAR_REGS (rw) : ORIGIN = __CLBINPUTXBAR_REGS_BASE, LENGTH = __CLBINPUTXBAR_REGS_SIZE
  MEM_EPWMXBAR_REGS (rw) : ORIGIN = __EPWMXBAR_REGS_BASE, LENGTH = __EPWMXBAR_REGS_SIZE
  MEM_CLBXBAR_REGS (rw) : ORIGIN = __CLBXBAR_REGS_BASE, LENGTH = __CLBXBAR_REGS_SIZE
  MEM_OUTPUTXBAR_REGS (rw) : ORIGIN = __OUTPUTXBAR_REGS_BASE, LENGTH = __OUTPUTXBAR_REGS_SIZE
  MEM_CLBOUTPUTXBAR_REGS (rw) : ORIGIN = __CLBOUTPUTXBAR_REGS_BASE, LENGTH = __CLBOUTPUTXBAR_REGS_SIZE

  MEM_GPIOA_REGS (rw) : ORIGIN = __GPIO0_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOB_REGS (rw) : ORIGIN = __GPIO1_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOC_REGS (rw) : ORIGIN = __GPIO2_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOD_REGS (rw) : ORIGIN = __GPIO3_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOE_REGS (rw) : ORIGIN = __GPIO4_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOF_REGS (rw) : ORIGIN = __GPIO5_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOG_REGS (rw) : ORIGIN = __GPIO6_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOH_REGS (rw) : ORIGIN = __GPIO7_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOI_REGS (rw) : ORIGIN = __GPIO8_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOJ_REGS (rw) : ORIGIN = __GPIO9_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOK_REGS (rw) : ORIGIN = __GPIO10_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOL_REGS (rw) : ORIGIN = __GPIO11_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOM_REGS (rw) : ORIGIN = __GPIO12_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPION_REGS (rw) : ORIGIN = __GPIO13_REGS_BASE, LENGTH = __GPIO_REGS_SIZE

  MEM_WD0_REGS (rw) : ORIGIN = __WD0_REGS_BASE, LENGTH = __WD_REGS_SIZE
  MEM_WD1_REGS (rw) : ORIGIN = __WD1_REGS_BASE, LENGTH = __WD_REGS_SIZE

  MEM_IO_CFG_REGS (rw) :     ORIGIN = __IO_CFG_REGS_BASE, LENGTH = __IO_CFG_REGS_SIZE
  MEM_ANACFG_REGS (rw) :        ORIGIN = __ANACFG_REGS_BASE, LENGTH = __ANACFG_REGS_SIZE
  MEM_CRGCFG_REGS (rw) :        ORIGIN = __CRGCFG_REGS_BASE, LENGTH = __CRGCFG_REGS_SIZE
  MEM_SYSCTL_REGS (rw) :        ORIGIN = __SYSCTL_REGS_BASE, LENGTH = __SYSCTL_REGS_SIZE

  MEM_DMA_REGS (rw) : ORIGIN = __DMA_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA_CH0_REGS (rw) : ORIGIN = __DMA_CH0_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA_CH1_REGS (rw) : ORIGIN = __DMA_CH1_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA_CH2_REGS (rw) : ORIGIN = __DMA_CH2_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA_CH3_REGS (rw) : ORIGIN = __DMA_CH3_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA_CH4_REGS (rw) : ORIGIN = __DMA_CH4_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA_CH5_REGS (rw) : ORIGIN = __DMA_CH5_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA_CH6_REGS (rw) : ORIGIN = __DMA_CH6_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA_CH7_REGS (rw) : ORIGIN = __DMA_CH7_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE

  MEM_DMA_MUX_REGS (rw) : ORIGIN = __DMA_MUX_REGS_BASE, LENGTH = __DMA_MUX_REGS_SIZE

  MEM_DMA1_REGS (rw) : ORIGIN = __DMA1_REGS_BASE, LENGTH = __DMA1_CH_REGS_SIZE
  MEM_DMA1_CH0_REGS (rw) : ORIGIN = __DMA1_CH0_REGS_BASE, LENGTH = __DMA1_CH_REGS_SIZE
  MEM_DMA1_CH1_REGS (rw) : ORIGIN = __DMA1_CH1_REGS_BASE, LENGTH = __DMA1_CH_REGS_SIZE
  MEM_DMA1_CH2_REGS (rw) : ORIGIN = __DMA1_CH2_REGS_BASE, LENGTH = __DMA1_CH_REGS_SIZE
  MEM_DMA1_CH3_REGS (rw) : ORIGIN = __DMA1_CH3_REGS_BASE, LENGTH = __DMA1_CH_REGS_SIZE
  MEM_DMA1_CH4_REGS (rw) : ORIGIN = __DMA1_CH4_REGS_BASE, LENGTH = __DMA1_CH_REGS_SIZE
  MEM_DMA1_CH5_REGS (rw) : ORIGIN = __DMA1_CH5_REGS_BASE, LENGTH = __DMA1_CH_REGS_SIZE
  MEM_DMA1_CH6_REGS (rw) : ORIGIN = __DMA1_CH6_REGS_BASE, LENGTH = __DMA1_CH_REGS_SIZE
  MEM_DMA1_CH7_REGS (rw) : ORIGIN = __DMA1_CH7_REGS_BASE, LENGTH = __DMA1_CH_REGS_SIZE

  MEM_DMA1_MUX_REGS (rw) : ORIGIN = __DMA1_MUX_REGS_BASE, LENGTH = __DMA1_MUX_REGS_SIZE

  MEM_FLASH0_INTERFACE_REGS (rw) : ORIGIN = __FLASH0_INTERFACE_REGS_BASE, LENGTH = __FLASH_INTERFACE_REGS_SIZE
  MEM_FLASH1_INTERFACE_REGS (rw) : ORIGIN = __FLASH1_INTERFACE_REGS_BASE, LENGTH = __FLASH_INTERFACE_REGS_SIZE

  MEM_CRC_REGS (rw) : ORIGIN = __CRC_REGS_BASE, LENGTH = __CRC_REGS_SIZE

  MEM_APBCOMMPARA_REGS (rw) : ORIGIN = __APBCOMMPARA_REGS_BASE, LENGTH = __APBCOMMPARA_REGS_SIZE

  MEM_SCIA_REGS (rw) : ORIGIN = __SCIA_REGS_BASE, LENGTH = __SCI_REGS_SIZE
  MEM_SCIB_REGS (rw) : ORIGIN = __SCIB_REGS_BASE, LENGTH = __SCI_REGS_SIZE
  MEM_SCIC_REGS (rw) : ORIGIN = __SCIC_REGS_BASE, LENGTH = __SCI_REGS_SIZE

  MEM_SPIA_REGS (rw) : ORIGIN = __SPIA_REGS_BASE, LENGTH = __SPI_REGS_SIZE
  MEM_SPIB_REGS (rw) : ORIGIN = __SPIB_REGS_BASE, LENGTH = __SPI_REGS_SIZE
  MEM_SPIC_REGS (rw) : ORIGIN = __SPIC_REGS_BASE, LENGTH = __SPI_REGS_SIZE
  MEM_SPID_REGS (rw) : ORIGIN = __SPID_REGS_BASE, LENGTH = __SPI_REGS_SIZE

  MEM_I2CA_REGS (rw) : ORIGIN = __I2CA_REGS_BASE, LENGTH = __I2C_REGS_SIZE
  MEM_I2CB_REGS (rw) : ORIGIN = __I2CB_REGS_BASE, LENGTH = __I2C_REGS_SIZE
  MEM_I2CC_REGS (rw) : ORIGIN = __I2CC_REGS_BASE, LENGTH = __I2C_REGS_SIZE

  MEM_CANA_REGS (rw) : ORIGIN = __CANA_REGS_BASE, LENGTH = __CAN_REGS_SIZE
  MEM_CANB_REGS (rw) : ORIGIN = __CANB_REGS_BASE, LENGTH = __CAN_REGS_SIZE
  MEM_CANC_REGS (rw) : ORIGIN = __CANC_REGS_BASE, LENGTH = __CAN_REGS_SIZE
  MEM_CAND_REGS (rw) : ORIGIN = __CAND_REGS_BASE, LENGTH = __CAN_REGS_SIZE

  MEM_LINA_REGS (rw) : ORIGIN = __LINA_REGS_BASE, LENGTH = __LIN_REGS_SIZE
  MEM_LINB_REGS (rw) : ORIGIN = __LINB_REGS_BASE, LENGTH = __LIN_REGS_SIZE

}

SECTIONS
{
  /*******************************************************************************/
  /**************** Start of Peripherals Registers sections define ***************/
  /*******************************************************************************/
  
  /***************** EPWM registers sections ***************/
  .epwm1_regs (COPY):
  {
    KEEP(*(.epwm1_regs))
    KEEP(*(.epwm1_regs.*))
  } > MEM_EPWM1_REGS

  .epwm2_regs (COPY):
  {
    KEEP(*(.epwm2_regs))
    KEEP(*(.epwm2_regs.*))
  } > MEM_EPWM2_REGS

  .epwm3_regs (COPY):
  {
    KEEP(*(.epwm3_regs))
    KEEP(*(.epwm3_regs.*))
  } > MEM_EPWM3_REGS

  .epwm4_regs (COPY):
  {
    KEEP(*(.epwm4_regs))
    KEEP(*(.epwm4_regs.*))
  } > MEM_EPWM4_REGS

  .epwm5_regs (COPY):
  {
    KEEP(*(.epwm5_regs))
    KEEP(*(.epwm5_regs.*))
  } > MEM_EPWM5_REGS

  .epwm6_regs (COPY):
  {
    KEEP(*(.epwm6_regs))
    KEEP(*(.epwm6_regs.*))
  } > MEM_EPWM6_REGS

  .epwm7_regs (COPY):
  {
    KEEP(*(.epwm7_regs))
    KEEP(*(.epwm7_regs.*))
  } > MEM_EPWM7_REGS

  .epwm8_regs (COPY):
  {
    KEEP(*(.epwm8_regs))
    KEEP(*(.epwm8_regs.*))
  } > MEM_EPWM8_REGS

  .epwm9_regs (COPY):
  {
    KEEP(*(.epwm9_regs))
    KEEP(*(.epwm9_regs.*))
  } > MEM_EPWM9_REGS

  .epwm10_regs (COPY):
  {
    KEEP(*(.epwm10_regs))
    KEEP(*(.epwm10_regs.*))
  } > MEM_EPWM10_REGS

  .epwm11_regs (COPY):
  {
    KEEP(*(.epwm11_regs))
    KEEP(*(.epwm11_regs.*))
  } > MEM_EPWM11_REGS

  .epwm12_regs (COPY):
  {
    KEEP(*(.epwm12_regs))
    KEEP(*(.epwm12_regs.*))
  } > MEM_EPWM12_REGS

  .epwm13_regs (COPY):
  {
    KEEP(*(.epwm13_regs))
    KEEP(*(.epwm13_regs.*))
  } > MEM_EPWM13_REGS

  .epwm14_regs (COPY):
  {
    KEEP(*(.epwm14_regs))
    KEEP(*(.epwm14_regs.*))
  } > MEM_EPWM14_REGS

  .epwm15_regs (COPY):
  {
    KEEP(*(.epwm15_regs))
    KEEP(*(.epwm15_regs.*))
  } > MEM_EPWM15_REGS

  .epwm16_regs (COPY):
  {
    KEEP(*(.epwm16_regs))
    KEEP(*(.epwm16_regs.*))
  } > MEM_EPWM16_REGS

  .epwm17_regs (COPY):
  {
    KEEP(*(.epwm17_regs))
    KEEP(*(.epwm17_regs.*))
  } > MEM_EPWM17_REGS

  .epwm18_regs (COPY):
  {
    KEEP(*(.epwm18_regs))
    KEEP(*(.epwm18_regs.*))
  } > MEM_EPWM18_REGS


  .epwmtop_regs (COPY):
  {
    KEEP(*(.epwmtop_regs))
    KEEP(*(.epwmtop_regs.*))
  } > MEM_PREEPWM_REGS

  /***************** EPWM EXTEND registers sections ***************/

  .epwm1_extend_regs (COPY):
  {
    KEEP(*(.epwm1_extend_regs))
    KEEP(*(.epwm1_extend_regs.*))
  } > MEM_EPWM1_EXTEND_REGS
  
  .epwm2_extend_regs (COPY):
  {
    KEEP(*(.epwm2_extend_regs))
    KEEP(*(.epwm2_extend_regs.*))
  } > MEM_EPWM2_EXTEND_REGS

  .epwm3_extend_regs (COPY):
  {
    KEEP(*(.epwm3_extend_regs))
    KEEP(*(.epwm3_extend_regs.*))
  } > MEM_EPWM3_EXTEND_REGS
  
  .epwm4_extend_regs (COPY):
  {
    KEEP(*(.epwm4_extend_regs))
    KEEP(*(.epwm4_extend_regs.*))
  } > MEM_EPWM4_EXTEND_REGS
 
  .epwm5_extend_regs (COPY):
  {
    KEEP(*(.epwm5_extend_regs))
    KEEP(*(.epwm5_extend_regs.*))
  } > MEM_EPWM5_EXTEND_REGS
 
  .epwm6_extend_regs (COPY):
  {
    KEEP(*(.epwm6_extend_regs))
    KEEP(*(.epwm6_extend_regs.*))
  } > MEM_EPWM6_EXTEND_REGS
  
  .epwm7_extend_regs (COPY):
  {
    KEEP(*(.epwm7_extend_regs))
    KEEP(*(.epwm7_extend_regs.*))
  } > MEM_EPWM7_EXTEND_REGS
  
  .epwm8_extend_regs (COPY):
  {
    KEEP(*(.epwm8_extend_regs))
    KEEP(*(.epwm8_extend_regs.*))
  } > MEM_EPWM8_EXTEND_REGS
  
  .epwm9_extend_regs (COPY):
  {
    KEEP(*(.epwm9_extend_regs))
    KEEP(*(.epwm9_extend_regs.*))
  } > MEM_EPWM9_EXTEND_REGS
  
  .epwm10_extend_regs (COPY):
  {
    KEEP(*(.epwm10_extend_regs))
    KEEP(*(.epwm10_extend_regs.*))
  } > MEM_EPWM10_EXTEND_REGS
  
  .epwm11_extend_regs (COPY):
  {
    KEEP(*(.epwm11_extend_regs))
    KEEP(*(.epwm11_extend_regs.*))
  } > MEM_EPWM11_EXTEND_REGS
  
  .epwm12_extend_regs (COPY):
  {
    KEEP(*(.epwm12_extend_regs))
    KEEP(*(.epwm12_extend_regs.*))
  } > MEM_EPWM12_EXTEND_REGS
  
  .epwm13_extend_regs (COPY):
  {
    KEEP(*(.epwm13_extend_regs))
    KEEP(*(.epwm13_extend_regs.*))
  } > MEM_EPWM13_EXTEND_REGS
  
  .epwm14_extend_regs (COPY):
  {
    KEEP(*(.epwm14_extend_regs))
    KEEP(*(.epwm14_extend_regs.*))
  } > MEM_EPWM14_EXTEND_REGS
  
  .epwm15_extend_regs (COPY):
  {
    KEEP(*(.epwm15_extend_regs))
    KEEP(*(.epwm15_extend_regs.*))
  } > MEM_EPWM15_EXTEND_REGS
  
  .epwm16_extend_regs (COPY):
  {
    KEEP(*(.epwm16_extend_regs))
    KEEP(*(.epwm16_extend_regs.*))
  } > MEM_EPWM16_EXTEND_REGS
  
  .epwm17_extend_regs (COPY):
  {
    KEEP(*(.epwm17_extend_regs))
    KEEP(*(.epwm17_extend_regs.*))
  } > MEM_EPWM17_EXTEND_REGS
  
  .epwm18_extend_regs (COPY):
  {
    KEEP(*(.epwm18_extend_regs))
    KEEP(*(.epwm18_extend_regs.*))
  } > MEM_EPWM18_EXTEND_REGS
  
  /***************** ADC registers sections ***************/
  .adca_regs (COPY):
  {
    KEEP(*(.adca_regs))
    KEEP(*(.adca_regs.*))
  } > MEM_ADCA_REGS
  
  .adcb_regs (COPY):
  {
    KEEP(*(.adcb_regs))
    KEEP(*(.adcb_regs.*))
  } > MEM_ADCB_REGS
  
  .adcc_regs (COPY):
  {
    KEEP(*(.adcc_regs))
    KEEP(*(.adcc_regs.*))
  } > MEM_ADCC_REGS
  
  .adcd_regs (COPY):
  {
    KEEP(*(.adcd_regs))
    KEEP(*(.adcd_regs.*))
  } > MEM_ADCD_REGS
  
  /***************** ADC result registers sections ***************/
  .adca_result_regs (COPY):
  {
    KEEP(*(.adca_result_regs))
    KEEP(*(.adca_result_regs.*))
  } > MEM_ADCARESULT_REGS
  
  .adcb_result_regs (COPY):
  {
    KEEP(*(.adcb_result_regs))
    KEEP(*(.adcb_result_regs.*))
  } > MEM_ADCBRESULT_REGS
  
  .adcc_result_regs (COPY):
  {
    KEEP(*(.adcc_result_regs))
    KEEP(*(.adcc_result_regs.*))
  } > MEM_ADCCRESULT_REGS
  
  .adcd_result_regs (COPY):
  {
    KEEP(*(.adcd_result_regs))
    KEEP(*(.adcd_result_regs.*))
  } > MEM_ADCDRESULT_REGS
  
  /***************** CMPSS registers sections ***************/
  .cmpss1_regs (COPY):
  {
    KEEP(*(.cmpss1_regs))
    KEEP(*(.cmpss1_regs.*))
  } > MEM_CMPSS1_REGS
  
  .cmpss2_regs (COPY):
  {
    KEEP(*(.cmpss2_regs))
    KEEP(*(.cmpss2_regs.*))
  } > MEM_CMPSS2_REGS
  
  .cmpss3_regs (COPY):
  {
    KEEP(*(.cmpss3_regs))
    KEEP(*(.cmpss3_regs.*))
  } > MEM_CMPSS3_REGS
  
  .cmpss4_regs (COPY):
  {
    KEEP(*(.cmpss4_regs))
    KEEP(*(.cmpss4_regs.*))
  } > MEM_CMPSS4_REGS
  
  .cmpss5_regs (COPY):
  {
    KEEP(*(.cmpss5_regs))
    KEEP(*(.cmpss5_regs.*))
  } > MEM_CMPSS5_REGS
  
  .cmpss6_regs (COPY):
  {
    KEEP(*(.cmpss6_regs))
    KEEP(*(.cmpss6_regs.*))
  } > MEM_CMPSS6_REGS
  
  .cmpss7_regs (COPY):
  {
    KEEP(*(.cmpss7_regs))
    KEEP(*(.cmpss7_regs.*))
  } > MEM_CMPSS7_REGS
  
  .cmpss8_regs (COPY):
  {
    KEEP(*(.cmpss8_regs))
    KEEP(*(.cmpss8_regs.*))
  } > MEM_CMPSS8_REGS
  
  .cmpss9_regs (COPY):
  {
    KEEP(*(.cmpss9_regs))
    KEEP(*(.cmpss9_regs.*))
  } > MEM_CMPSS9_REGS
  
  .cmpss10_regs (COPY):
  {
    KEEP(*(.cmpss10_regs))
    KEEP(*(.cmpss10_regs.*))
  } > MEM_CMPSS10_REGS

  .cmpss11_regs (COPY):
  {
    KEEP(*(.cmpss11_regs))
    KEEP(*(.cmpss11_regs.*))
  } > MEM_CMPSS11_REGS
  
  .cmpss12_regs (COPY):
  {
    KEEP(*(.cmpss12_regs))
    KEEP(*(.cmpss12_regs.*))
  } > MEM_CMPSS12_REGS


  /***************** ECAP registers sections ***************/
  .ecap1_regs (COPY):
  {
    KEEP(*(.ecap1_regs))
    KEEP(*(.ecap1_regs.*))
  } > MEM_ECAP1_REGS

  .ecap2_regs (COPY):
  {
    KEEP(*(.ecap2_regs))
    KEEP(*(.ecap2_regs.*))
  } > MEM_ECAP2_REGS

  .ecap3_regs (COPY):
  {
    KEEP(*(.ecap3_regs))
    KEEP(*(.ecap3_regs.*))
  } > MEM_ECAP3_REGS

  .ecap4_regs (COPY):
  {
    KEEP(*(.ecap4_regs))
    KEEP(*(.ecap4_regs.*))
  } > MEM_ECAP4_REGS

  .ecap5_regs (COPY):
  {
    KEEP(*(.ecap5_regs))
    KEEP(*(.ecap5_regs.*))
  } > MEM_ECAP5_REGS

  .ecap6_regs (COPY):
  {
    KEEP(*(.ecap6_regs))
    KEEP(*(.ecap6_regs.*))
  } > MEM_ECAP6_REGS

  .ecap7_regs (COPY):
  {
    KEEP(*(.ecap7_regs))
    KEEP(*(.ecap7_regs.*))
  } > MEM_ECAP7_REGS


   /***************** EQEP registers sections ***************/
  .eqep1_regs (COPY):
  {
    KEEP(*(.eqep1_regs))
    KEEP(*(.eqep1_regs.*))
  } > MEM_EQEP1_REGS
  
  .eqep2_regs (COPY):
  {
    KEEP(*(.eqep2_regs))
    KEEP(*(.eqep2_regs.*))
  } > MEM_EQEP2_REGS
  
  .eqep3_regs (COPY):
  {
    KEEP(*(.eqep3_regs))
    KEEP(*(.eqep3_regs.*))
  } > MEM_EQEP3_REGS
  
  .eqep4_regs (COPY):
  {
    KEEP(*(.eqep4_regs))
    KEEP(*(.eqep4_regs.*))
  } > MEM_EQEP4_REGS
  
  .eqep5_regs (COPY):
  {
    KEEP(*(.eqep5_regs))
    KEEP(*(.eqep5_regs.*))
  } > MEM_EQEP5_REGS
  
  .eqep6_regs (COPY):
  {
    KEEP(*(.eqep6_regs))
    KEEP(*(.eqep6_regs.*))
  } > MEM_EQEP6_REGS

/***************** DAC registers sections ***************/
  .daca_regs (COPY):
  {
    KEEP(*(.daca_regs))
    KEEP(*(.daca_regs.*))
  } > MEM_DACA_REGS

  .dacb_regs (COPY):
  {
    KEEP(*(.dacb_regs))
    KEEP(*(.dacb_regs.*))
  } > MEM_DACB_REGS

  .dacc_regs (COPY):
  {
    KEEP(*(.dacc_regs))
    KEEP(*(.dacc_regs.*))
  } > MEM_DACC_REGS
/***************** SDFM registers sections ***************/
  .sdfm1_regs (COPY):
  {
    KEEP(*(.sdfm1_regs))
    KEEP(*(.sdfm1_regs.*))
  } > MEM_SDFM1_REGS
  .sdfm2_regs (COPY):
  {
    KEEP(*(.sdfm2_regs))
    KEEP(*(.sdfm2_regs.*))
  } > MEM_SDFM2_REGS
    .sdfm3_regs (COPY):
  {
    KEEP(*(.sdfm3_regs))
    KEEP(*(.sdfm3_regs.*))
  } > MEM_SDFM3_REGS
  .sdfm4_regs (COPY):
  {
    KEEP(*(.sdfm4_regs))
    KEEP(*(.sdfm4_regs.*))
  } > MEM_SDFM4_REGS
/***************** CPUTIMER registers sections ***************/
  .cputimer0_regs (COPY):
  {
    KEEP(*(.cputimer0_regs))
    KEEP(*(.cputimer0_regs.*))
  } > MEM_CPUTIME0_REGS

  .cputimer1_regs (COPY):
  {
    KEEP(*(.cputimer1_regs))
    KEEP(*(.cputimer1_regs.*))
  } > MEM_CPUTIME1_REGS

  .cputimer2_regs (COPY):
  {
    KEEP(*(.cputimer2_regs))
    KEEP(*(.cputimer2_regs.*))
  } > MEM_CPUTIME2_REGS

  .cputimer3_regs (COPY):
  {
    KEEP(*(.cputimer3_regs))
    KEEP(*(.cputimer3_regs.*))
  } > MEM_CPUTIME3_REGS

  .cputimer4_regs (COPY):
  {
    KEEP(*(.cputimer4_regs))
    KEEP(*(.cputimer4_regs.*))
  } > MEM_CPUTIME4_REGS

  .cputimer5_regs (COPY):
  {
    KEEP(*(.cputimer5_regs))
    KEEP(*(.cputimer5_regs.*))
  } > MEM_CPUTIME5_REGS

/***************** XBAR registers sections ***************/
  .inputxbar_regs (COPY):
  {
    KEEP(*(.inputxbar_regs))
    KEEP(*(.inputxbar_regs.*))
  } > MEM_INPUTXBAR_REGS

  .xbar_regs (COPY):
  {
    KEEP(*(.xbar_regs))
    KEEP(*(.xbar_regs.*))
  } > MEM_XBAR_REGS

  .clbinputxbar_regs (COPY):
  {
    KEEP(*(.clbinputxbar_regs))
    KEEP(*(.clbinputxbar_regs.*))
  } > MEM_CLBINPUTXBAR_REGS

  .epwmxbar_regs (COPY):
  {
    KEEP(*(.epwmxbar_regs))
    KEEP(*(.epwmxbar_regs.*))
  } > MEM_EPWMXBAR_REGS

  .clbxbar_regs (COPY):
  {
    KEEP(*(.clbxbar_regs))
    KEEP(*(.clbxbar_regs.*))
  } > MEM_CLBXBAR_REGS

  .outputxbar_regs (COPY):
  {
    KEEP(*(.outputxbar_regs))
    KEEP(*(.outputxbar_regs.*))
  } > MEM_OUTPUTXBAR_REGS

  .clboutputxbar_regs (COPY):
  {
    KEEP(*(.clboutputxbar_regs))
    KEEP(*(.clboutputxbar_regs.*))
  } > MEM_CLBOUTPUTXBAR_REGS

/***************** GPIO registers sections ***************/
  .gpio_porta_regs (COPY):
  {
    KEEP(*(.gpio_porta_regs))
    KEEP(*(.gpio_porta_regs.*))
  } > MEM_GPIOA_REGS

  .gpio_portb_regs (COPY):
  {
    KEEP(*(.gpio_portb_regs))
    KEEP(*(.gpio_portb_regs.*))
  } > MEM_GPIOB_REGS

  .gpio_portc_regs (COPY):
  {
    KEEP(*(.gpio_portc_regs))
    KEEP(*(.gpio_portc_regs.*))
  } > MEM_GPIOC_REGS

  .gpio_portd_regs (COPY):
  {
    KEEP(*(.gpio_portd_regs))
    KEEP(*(.gpio_portd_regs.*))
  } > MEM_GPIOD_REGS

  .gpio_porte_regs (COPY):
  {
    KEEP(*(.gpio_porte_regs))
    KEEP(*(.gpio_porte_regs.*))
  } > MEM_GPIOE_REGS

  .gpio_portf_regs (COPY):
  {
    KEEP(*(.gpio_portf_regs))
    KEEP(*(.gpio_portf_regs.*))
  } > MEM_GPIOF_REGS

  .gpio_portg_regs (COPY):
  {
    KEEP(*(.gpio_portg_regs))
    KEEP(*(.gpio_portg_regs.*))
  } > MEM_GPIOG_REGS

  .gpio_porth_regs (COPY):
  {
    KEEP(*(.gpio_porth_regs))
    KEEP(*(.gpio_porth_regs.*))
  } > MEM_GPIOH_REGS

  .gpio_porti_regs (COPY):
  {
    KEEP(*(.gpio_porti_regs))
    KEEP(*(.gpio_porti_regs.*))
  } > MEM_GPIOI_REGS

  .gpio_portj_regs (COPY):
  {
    KEEP(*(.gpio_portj_regs))
    KEEP(*(.gpio_portj_regs.*))
  } > MEM_GPIOJ_REGS

  .gpio_portk_regs (COPY):
  {
    KEEP(*(.gpio_portk_regs))
    KEEP(*(.gpio_portk_regs.*))
  } > MEM_GPIOK_REGS

  .gpio_portl_regs (COPY):
  {
    KEEP(*(.gpio_portl_regs))
    KEEP(*(.gpio_portl_regs.*))
  } > MEM_GPIOL_REGS

  .gpio_portm_regs (COPY):
  {
    KEEP(*(.gpio_portm_regs))
    KEEP(*(.gpio_portm_regs.*))
  } > MEM_GPIOM_REGS

  .gpio_portn_regs (COPY):
  {
    KEEP(*(.gpio_portn_regs))
    KEEP(*(.gpio_portn_regs.*))
  } > MEM_GPION_REGS

/***************** Watchdog 0 registers sections ***************/
  .wd0_regs (COPY):
  {
    KEEP(*(.wd0_regs))
    KEEP(*(.wd0_regs.*))
  } > MEM_WD0_REGS

/***************** Watchdog 1 registers sections ***************/
  .wd1_regs (COPY):
  {
    KEEP(*(.wd1_regs))
    KEEP(*(.wd1_regs.*))
  } > MEM_WD1_REGS

 /***************** SysCtl registers sections ***************/
  .io_cfg_regs (COPY):
  {
    KEEP(*(.io_cfg_regs))
    KEEP(*(.io_cfg_regs.*))
  } > MEM_IO_CFG_REGS

 .anacfg_regs (COPY):
  {
    KEEP(*(.anacfg_regs))
    KEEP(*(.anacfg_regs.*))
  } > MEM_ANACFG_REGS

  .crgcfg_regs (COPY):
  {
    KEEP(*(.crgcfg_regs))
    KEEP(*(.crgcfg_regs.*))
  } > MEM_CRGCFG_REGS

  .sysctl_regs (COPY):
  {
    KEEP(*(.sysctl_regs))
    KEEP(*(.sysctl_regs.*))
  } > MEM_SYSCTL_REGS

/***************** DMA channels registers sections ***************/
  .dma_regs (COPY):
  {
    KEEP(*(.dma_regs))
    KEEP(*(.dma_regs.*))
  } > MEM_DMA_REGS

  .dma_ch0_regs (COPY):
  {
    KEEP(*(.dma_ch0_regs))
    KEEP(*(.dma_ch0_regs.*))
  } > MEM_DMA_CH0_REGS

  .dma_ch1_regs (COPY):
  {
    KEEP(*(.dma_ch1_regs))
    KEEP(*(.dma_ch1_regs.*))
  } > MEM_DMA_CH1_REGS

  .dma_ch2_regs (COPY):
  {
    KEEP(*(.dma_ch2_regs))
    KEEP(*(.dma_ch2_regs.*))
  } > MEM_DMA_CH2_REGS

  .dma_ch3_regs (COPY):
  {
    KEEP(*(.dma_ch3_regs))
    KEEP(*(.dma_ch3_regs.*))
  } > MEM_DMA_CH3_REGS

  .dma_ch4_regs (COPY):
  {
    KEEP(*(.dma_ch4_regs))
    KEEP(*(.dma_ch4_regs.*))
  } > MEM_DMA_CH4_REGS

  .dma_ch5_regs (COPY):
  {
    KEEP(*(.dma_ch5_regs))
    KEEP(*(.dma_ch5_regs.*))
  } > MEM_DMA_CH5_REGS

  .dma_ch6_regs (COPY):
  {
    KEEP(*(.dma_ch6_regs))
    KEEP(*(.dma_ch6_regs.*))
  } > MEM_DMA_CH6_REGS

  .dma_ch7_regs (COPY):
  {
    KEEP(*(.dma_ch7_regs))
    KEEP(*(.dma_ch7_regs.*))
  } > MEM_DMA_CH7_REGS

/***************** DMA multiplexer registers sections ***************/
  .dma_mux_regs (COPY):
  {
    KEEP(*(.dma_mux_regs))
    KEEP(*(.dma_mux_regs.*))
  } > MEM_DMA_MUX_REGS

/***************** DMA1 channels registers sections ***************/
  .dma1_regs (COPY):
  {
    KEEP(*(.dma1_regs))
    KEEP(*(.dma1_regs.*))
  } > MEM_DMA1_REGS

  .dma1_ch0_regs (COPY):
  {
    KEEP(*(.dma1_ch0_regs))
    KEEP(*(.dma1_ch0_regs.*))
  } > MEM_DMA1_CH0_REGS

  .dma1_ch1_regs (COPY):
  {
    KEEP(*(.dma1_ch1_regs))
    KEEP(*(.dma1_ch1_regs.*))
  } > MEM_DMA1_CH1_REGS

  .dma1_ch2_regs (COPY):
  {
    KEEP(*(.dma1_ch2_regs))
    KEEP(*(.dma1_ch2_regs.*))
  } > MEM_DMA1_CH2_REGS

  .dma1_ch3_regs (COPY):
  {
    KEEP(*(.dma1_ch3_regs))
    KEEP(*(.dma1_ch3_regs.*))
  } > MEM_DMA1_CH3_REGS

  .dma1_ch4_regs (COPY):
  {
    KEEP(*(.dma1_ch4_regs))
    KEEP(*(.dma1_ch4_regs.*))
  } > MEM_DMA1_CH4_REGS

  .dma1_ch5_regs (COPY):
  {
    KEEP(*(.dma1_ch5_regs))
    KEEP(*(.dma1_ch5_regs.*))
  } > MEM_DMA1_CH5_REGS

  .dma1_ch6_regs (COPY):
  {
    KEEP(*(.dma1_ch6_regs))
    KEEP(*(.dma1_ch6_regs.*))
  } > MEM_DMA1_CH6_REGS

  .dma1_ch7_regs (COPY):
  {
    KEEP(*(.dma1_ch7_regs))
    KEEP(*(.dma1_ch7_regs.*))
  } > MEM_DMA1_CH7_REGS

/***************** DMA1 multiplexer registers sections ***************/
  .dma1_mux_regs (COPY):
  {
    KEEP(*(.dma1_mux_regs))
    KEEP(*(.dma1_mux_regs.*))
  } > MEM_DMA1_MUX_REGS

/***************** FLASH interface registers sections ***************/
  .flash0_interface_regs (COPY):
  {
    KEEP(*(.flash0_interface_regs))
    KEEP(*(.flash0_interface_regs.*))
  } > MEM_FLASH0_INTERFACE_REGS

  .flash1_interface_regs (COPY):
  {
    KEEP(*(.flash1_interface_regs))
    KEEP(*(.flash1_interface_regs.*))
  } > MEM_FLASH1_INTERFACE_REGS


  /***************** CRC registers sections ***************/
  .crc_regs (COPY):
  {
    KEEP(*(.crc_regs))
    KEEP(*(.crc_regs.*))
  } > MEM_CRC_REGS
  
/***************** APB_COMM_PARA registers sections ***************/
  .apbcommpara_regs (COPY):
  {
	KEEP(*(.apbcommpara_regs))
    KEEP(*(.apbcommpara_regs.*))
  } > MEM_APBCOMMPARA_REGS

/***************** SCI registers sections ***************/
  .scia_regs (COPY):
  {
    KEEP(*(.scia_regs))
    KEEP(*(.scia_regs.*))
  } > MEM_SCIA_REGS

  .scib_regs (COPY):
  {
    KEEP(*(.scib_regs))
    KEEP(*(.scib_regs.*))
  } > MEM_SCIB_REGS

  .scic_regs (COPY):
  {
    KEEP(*(.scic_regs))
    KEEP(*(.scic_regs.*))
  } > MEM_SCIC_REGS

/***************** SPI registers sections ***************/
  .spia_regs (COPY):
  {
    KEEP(*(.spia_regs))
    KEEP(*(.spia_regs.*))
  } > MEM_SPIA_REGS

  .spib_regs (COPY):
  {
    KEEP(*(.spib_regs))
    KEEP(*(.spib_regs.*))
  } > MEM_SPIB_REGS

  .spic_regs (COPY):
  {
    KEEP(*(.spic_regs))
    KEEP(*(.spic_regs.*))
  } > MEM_SPIC_REGS

  .spid_regs (COPY):
  {
    KEEP(*(.spid_regs))
    KEEP(*(.spid_regs.*))
  } > MEM_SPID_REGS

/***************** I2C registers sections ***************/
  .i2ca_regs (COPY):
  {
    KEEP(*(.i2ca_regs))
    KEEP(*(.i2ca_regs.*))
  } > MEM_I2CA_REGS

  .i2cb_regs (COPY):
  {
    KEEP(*(.i2cb_regs))
    KEEP(*(.i2cb_regs.*))
  } > MEM_I2CB_REGS

  .i2cc_regs (COPY):
  {
    KEEP(*(.i2cc_regs))
    KEEP(*(.i2cc_regs.*))
  } > MEM_I2CC_REGS

/***************** CAN registers sections ***************/
  .cana_regs (COPY):
  {
    KEEP(*(.cana_regs))
    KEEP(*(.cana_regs.*))
  } > MEM_CANA_REGS

  .canb_regs (COPY):
  {
    KEEP(*(.canb_regs))
    KEEP(*(.canb_regs.*))
  } > MEM_CANB_REGS

  .canc_regs (COPY):
  {
    KEEP(*(.canc_regs))
    KEEP(*(.canc_regs.*))
  } > MEM_CANC_REGS

  .cand_regs (COPY):
  {
    KEEP(*(.cand_regs))
    KEEP(*(.cand_regs.*))
  } > MEM_CAND_REGS

  /***************** LIN registers sections ***************/
  .lina_regs (COPY):
  {
    KEEP(*(.lina_regs))
    KEEP(*(.lina_regs.*))
  } > MEM_LINA_REGS

  .linb_regs (COPY):
  {
    KEEP(*(.linb_regs))
    KEEP(*(.linb_regs.*))
  } > MEM_LINB_REGS

}
