/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * @example: canfd_loopback
 * @Language:English
 * @encode:
 * @brief:
 * This example demonstrates the CANFD loopback transmission test.
 * Polling for message transmission has an ID of 0xb0 and the data segment ranges from 0 to 63.
 * Reading the message is done in the interrupt service function and is performed by checking and reading.
 * The CANFD protocol is used. The baud rate is set to 1M for the arbitration segment and 4M for the data segment. The sampling point is 80%.
 */

/*
 * @example: canfd_loopback
 * @Language:Chinese
 * @encode:GBK
 * @brief:
 *	ʾCANFDշԡ
 *	ѯͱidΪ0xb0 ݶ063
 *	ȡ жϷм鲢ȡ
 *	ʹCANFDЭ Ϊ ٲö1M ݶ4M 80%
 */

#include "device.h"
#include "canfd_loopback.h"

CAN_TxMessage_t TxMsgBuf0 = {0};
#define Delay_value  10000000

int main(void)
{
	uint32_t i;
	uint32_t Delay = Delay_value;

	Device_init();

	__disable_irq();

	UartPrint_init(LOG_SCI_BASE, 115200);

	GPIO_setPinConfig(CAN_RX_PIN);
	GPIO_setPinConfig(CAN_TX_PIN);

	can_ctrl_init();

	__enable_irq();

	TxMsgBuf0.dlc = CAN_DATA_LENGTH_64;
	TxMsgBuf0.id = 0xc0;
	TxMsgBuf0.fdf = 1;
	TxMsgBuf0.brs = 1;

	for (i = 0; i < CAN_getMessageLength(TxMsgBuf0.dlc); i++) {
		TxMsgBuf0.data[i] = i;
	}

	while (1) {
		CAN_transmitHighPriorityMsg(CAN_BASE, &TxMsgBuf0);
		while (Delay--);
		Delay = Delay_value;
	}
}
