/*
/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#include"pto_pulsegen.h"
//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************

//
// OUTPUTXBAR3 -> myOUTPUTXBAR3 Pinmux
//
//
// OUTPUTXBAR3 - GPIO Settings
//
#define GPIO_PIN_OUTPUTXBAR3 26
#define myOUTPUTXBAR3_OUTPUTXBAR_GPIO 26
#define myOUTPUTXBAR3_OUTPUTXBAR_PIN_CONFIG GPIO_26_OUTPUTXBAR3

//
// OUTPUTXBAR4 -> myOUTPUTXBAR4 Pinmux
//
//
// OUTPUTXBAR4 - GPIO Settings
//
#define GPIO_PIN_OUTPUTXBAR4 15
#define myOUTPUTXBAR4_OUTPUTXBAR_GPIO 15
#define myOUTPUTXBAR4_OUTPUTXBAR_PIN_CONFIG GPIO_15_OUTPUTXBAR4

//*****************************************************************************
//
// CLB Configurations
//
//*****************************************************************************
#define myCLB0_BASE CLB1_BASE
void myCLB0_init();

//*****************************************************************************
//
// OUTPUTXBAR Configurations
//
//*****************************************************************************
void myOUTPUTXBAR3_init();
#define myOUTPUTXBAR3 XBAR_OUTPUT3
void myOUTPUTXBAR4_init();
#define myOUTPUTXBAR4 XBAR_OUTPUT4

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
//void	Board_init();
void	PinMux_init();
//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	EALLOW;

	PinMux_init();
	pto_initPulsegen();
	EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{

	GPIO_setPinConfig(GPIO_32_CLB_OUTPUTXBAR1);
	GPIO_setPadConfig(32, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(32, GPIO_QUAL_SYNC);


	GPIO_setPinConfig(GPIO_33_CLB_OUTPUTXBAR2);
	GPIO_setPadConfig(33, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(33, GPIO_QUAL_SYNC);
}





//*****************************************************************************
//
// OUTPUTXBAR Configurations
//
//*****************************************************************************





