/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    cmpss_ex1_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */


#include "printf.h"
#include "cmpss_ex1_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define PWM1_TIMER_MIN     500U
#define PWM1_TIMER_MAX     8000U
#define EPWM_TIMER_UP      1U
#define EPWM_TIMER_DOWN    0U

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */



/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/**
 * \brief   "Error function" 
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void error()
{

}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
//	ASysCtl_setAnaTopSpare(0, 0x0020);
//	ASysCtl_setCmpSpare(0x20000000);

	//SysCtl_setAgpio21Sel(0x9);  //select CMP4_HP5 for pin AGPIO21
	//ASysCtl_setA8Sel(0x03);
	//ASysCtl_setC14Sel(0x02);    //select CMP4_HP

	//ASysCtl_setC3Sel(0x03);       //select CMP4_HN1 for pin C3

	//ASysCtl_setA2Sel(0x03);       //select A2_CMP1_HP0

	// PinMux for modules assigned to CPU1

	// ANALOG -> myANALOGPinMux0 Pinmux
	// Analog PinMux for A0/B15/C15/DACA_OUT
	GPIO_setPinConfig(GPIO_231_GPIO231);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(231, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A1/B7/DACB_OUT
	GPIO_setPinConfig(GPIO_232_GPIO232);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(232, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A10/B1/C10
	GPIO_setPinConfig(GPIO_230_GPIO230);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(230, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A11/B10/C0
	GPIO_setPinConfig(GPIO_237_GPIO237);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(237, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A12, C5
	GPIO_setPinConfig(GPIO_238_GPIO238);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(238, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A14/B14/C4
	GPIO_setPinConfig(GPIO_239_GPIO239);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(239, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A2/B6/C9
	GPIO_setPinConfig(GPIO_224_GPIO224);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(224, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A3, C7/B9
	GPIO_setPinConfig(GPIO_229_GPIO229);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(229, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A4/B8
	GPIO_setPinConfig(GPIO_225_GPIO225);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(225, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A5
//	GPIO_setPinConfig(GPIO_249_GPIOO249);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(249, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A6
	GPIO_setPinConfig(GPIO_228_GPIO228);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(228, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A8
	GPIO_setPinConfig(GPIO_240_GPIO240);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(240, GPIO_ANALOG_ENABLED);
	// Analog PinMux for A9
	GPIO_setPinConfig(GPIO_227_GPIO227);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(227, GPIO_ANALOG_ENABLED);
	// Analog PinMux for B0/C11
//	GPIO_setPinConfig(GPIO_253_GPIOO253);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(253, GPIO_ANALOG_ENABLED);
	// Analog PinMux for B11
//	GPIO_setPinConfig(GPIO_251_GPIOO251);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(251, GPIO_ANALOG_ENABLED);
	// Analog PinMux for B11, GPIO21
	GPIO_setPinConfig(GPIO_21_GPIO21);
	// AGPIO -> Analog mode selected
	// On 100PZ package for F28003x, if both "B5, GPIO20" and "B5" are selected as analog,
	// "B5, GPIO20" will drive the ADC instead of "B5"
	// On 100PZ package for F28003x, if both "B11, GPIO21" and "B11" are selected as analog,
	// "B11, GPIO21" will drive the ADC instead of "B11"
	GPIO_setAnalogMode(21, GPIO_ANALOG_ENABLED);
	// Analog PinMux for B2/C6
	GPIO_setPinConfig(GPIO_226_GPIO226);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(226, GPIO_ANALOG_ENABLED);
	// Analog PinMux for B3/VDAC
	GPIO_setPinConfig(GPIO_242_GPIO242);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(242, GPIO_ANALOG_ENABLED);
	// Analog PinMux for B4/C8
	GPIO_setPinConfig(GPIO_236_GPIO236);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(236, GPIO_ANALOG_ENABLED);
	// Analog PinMux for B5
//	GPIO_setPinConfig(GPIO_252_GPIOO252);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(252, GPIO_ANALOG_ENABLED);
	// Analog PinMux for B5, GPIO20
	GPIO_setPinConfig(GPIO_20_GPIO20);
	// AGPIO -> Analog mode selected
	// On 100PZ package for F28003x, if both "B5, GPIO20" and "B5" are selected as analog,
	// "B5, GPIO20" will drive the ADC instead of "B5"
	// On 100PZ package for F28003x, if both "B11, GPIO21" and "B11" are selected as analog,
	// "B11, GPIO21" will drive the ADC instead of "B11"
	GPIO_setAnalogMode(20, GPIO_ANALOG_ENABLED);
	// Analog PinMux for C1
//	GPIO_setPinConfig(GPIO_248_GPIOO248);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(248, GPIO_ANALOG_ENABLED);
	// Analog PinMux for C14
//	GPIO_setPinConfig(GPIO_247_GPIOO247);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(247, GPIO_ANALOG_ENABLED);
	// Analog PinMux for C2/B12
//	GPIO_setPinConfig(GPIO_244_GPIOO244);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(244, GPIO_ANALOG_ENABLED);
	// Analog PinMux for C3/A7
//	GPIO_setPinConfig(GPIO_245_GPIOO245);
	// AIO -> Analog mode selected
	GPIO_setAnalogMode(245, GPIO_ANALOG_ENABLED);

	// OUTPUTXBAR3 -> myOUTPUTXBAR0 Pinmux
	GPIO_setPinConfig(myOUTPUTXBAR0_OUTPUTXBAR_PIN_CONFIG);

    // Configure GPIO13 to output CTRIPH (routed through ePWM TRIP4 and ePWM7B)/EPWM1A Normal Output
    GPIO_setPinConfig(GPIO_0_EPWM1_A);
    GPIO_setPinConfig(GPIO_1_EPWM1_B);
}

//*****************************************************************************
//
// CMPSS Configurations
//
//*****************************************************************************
void CMPSS_init(){
	myCMPSS0_init();
}

void myCMPSS0_init(){


	// Enable CMP1_HP
	ASysCtl_setCMP_MuxEn(ASYSCTL_CMP_SELECT_1, 1, 0, 0, 0);

    // Select the value for CMP1HPMXSEL.
    ASysCtl_selectCMPHPMux(ASYSCTL_CMPHPMUX_SELECT_1,0U);

    // Select the value for CMP1LPMXSEL.
    ASysCtl_selectCMPLPMux(ASYSCTL_CMPLPMUX_SELECT_1,0U);

    // Sets internal DAC as the high comparator negative input
    CMPSS_configHighComparator(myCMPSS0_BASE,(CMPSS_INSRC_DAC));

    // Sets external input as the high comparator positive input
    CMPSS_setCmpHpSrc(myCMPSS0_BASE, CMPSS_INSRC_PIN_HIGH_POS);

    // Sets internal DAC as the low comparator negative input
    CMPSS_configLowComparator(myCMPSS0_BASE,(CMPSS_INSRC_DAC));

    // Sets external input as the low comparator positive input
    CMPSS_setCmpLpSrc(myCMPSS0_BASE, CMPSS_INSRC_PIN_LOW_NEG);

    // Sets the configuration for the internal comparator DACs.
    CMPSS_configDAC(myCMPSS0_BASE,(CMPSS_DACVAL_SYSCLK | CMPSS_DACREF_VDDA | CMPSS_DACSRC_SHDW));

    // Sets the value of the internal DAC of the high comparator.
    CMPSS_setDACValueHigh(myCMPSS0_BASE,3500U);

    // Sets the value of the internal DAC of the low comparator.
    CMPSS_setDACValueLow(myCMPSS0_BASE,0U);

    //  Configures the digital filter of the high comparator.
    CMPSS_configFilterHigh(myCMPSS0_BASE, 0U, 1U, 1U);

    // Configures the digital filter of the low comparator.
    CMPSS_configFilterLow(myCMPSS0_BASE, 0U, 1U, 1U);

    // Sets the output signal configuration for the high comparator---Asynchronous output
    CMPSS_configOutputsHigh(myCMPSS0_BASE,(CMPSS_TRIPOUT_ASYNC_COMP | CMPSS_TRIP_ASYNC_COMP));
    // Sets the output signal configuration for the high comparator---Synchronous output
//  CMPSS_configOutputsHigh(myCMPSS0_BASE,(CMPSS_TRIPOUT_SYNC_COMP | CMPSS_TRIP_SYNC_COMP));

    // Sets the output signal configuration for the low comparator---Asynchronous output
    CMPSS_configOutputsLow(myCMPSS0_BASE,(CMPSS_TRIPOUT_ASYNC_COMP | CMPSS_TRIP_ASYNC_COMP));
    // Sets the output signal configuration for the low comparator---Synchronous output
//    CMPSS_configOutputsHigh(myCMPSS0_BASE,(CMPSS_TRIPOUT_SYNC_COMP | CMPSS_TRIP_SYNC_COMP));

    // Sets the comparator hysteresis settings.
    CMPSS_setHysteresis(myCMPSS0_BASE,0U);

    // Configures the comparator subsystem's ramp generator.
    CMPSS_configRamp(myCMPSS0_BASE,0U,0U,0U,1U,true);

    // Disables reset of HIGH comparator digital filter output latch on PWMSYNC
    CMPSS_disableLatchResetOnPWMSYNCHigh(myCMPSS0_BASE);

    // Disables reset of LOW comparator digital filter output latch on PWMSYNC
    CMPSS_disableLatchResetOnPWMSYNCLow(myCMPSS0_BASE);

    // Sets the ePWM module blanking signal that holds trip in reset.
    CMPSS_configBlanking(myCMPSS0_BASE,1U);

    // Disables an ePWM blanking signal from holding trip in reset.
    CMPSS_disableBlanking(myCMPSS0_BASE);

    // Configures whether or not the digital filter latches are reset by PWMSYNC
    CMPSS_configLatchOnPWMSYNC(myCMPSS0_BASE,false,false);

    // Enables the CMPSS module.
    CMPSS_enableModule(myCMPSS0_BASE);

    // Delay for CMPSS DAC to power up.
    DEVICE_DELAY_US(500);
}



//*****************************************************************************
//
// OUTPUTXBAR Configurations
//
//*****************************************************************************
void OUTPUTXBAR_init(){
	myOUTPUTXBAR0_init();
}

void myOUTPUTXBAR0_init(){
	XBAR_setOutputLatchMode(OUTPUTXBAR_BASE, myOUTPUTXBAR0, false);
	XBAR_invertOutputSignal(OUTPUTXBAR_BASE, myOUTPUTXBAR0, false);

	//Mux configuration
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, myOUTPUTXBAR0, XBAR_OUT_MUX00_CMPSS1_CTRIPOUTH);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE, myOUTPUTXBAR0, XBAR_MUX00);
}

// initEPWM - Function to configure ePWM1 and the ePWM X-BAR to take CTRIPH as
//            the DC trip input
// Set up ePWM7 to take CTRIPH as TRIP4 for its DC trip input
void initEPWM(void)
{
    // Sync the ePWM time base clock
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    // Configure TRIP4 to be CTRIP1H using the ePWM X-BAR
    XBAR_setEPWMMuxConfig(XBAR_TRIP4, XBAR_EPWM_MUX00_CMPSS1_CTRIPH);
    XBAR_enableEPWMMux(XBAR_TRIP4, XBAR_MUX00);

	// Set the time base clock prescalers to /1
	EPWM_setClockPrescaler(EPWM1_BASE, EPWM_CLOCK_DIVIDER_1,
						   EPWM_HSCLOCK_DIVIDER_1);

	// Initializing dummy values for ePWM counter and period
	EPWM_setTimeBaseCounter(EPWM1_BASE, 0);
	EPWM_setTimeBasePeriod(EPWM1_BASE, 0x9000);

	// Set-up compare
	EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, 0x8000);
	EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
	EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_B, 0x7FFF);
	EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);

	// Set actions
	EPWM_setActionQualifierAction(EPWM1_BASE,
								  EPWM_AQ_OUTPUT_B,
								  EPWM_AQ_OUTPUT_HIGH,
								  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
	EPWM_setActionQualifierAction(EPWM1_BASE,
								  EPWM_AQ_OUTPUT_B,
								  EPWM_AQ_OUTPUT_LOW,
								  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	EPWM_setActionQualifierAction(EPWM1_BASE,
								  EPWM_AQ_OUTPUT_A,
								  EPWM_AQ_OUTPUT_HIGH,
								  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	EPWM_setActionQualifierAction(EPWM1_BASE,
								  EPWM_AQ_OUTPUT_A,
								  EPWM_AQ_OUTPUT_LOW,
								  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);

	// Put the time base counter into up-count mode
	EPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP);

    // Configure ePWM1B to output high on TZB TRIP
    EPWM_setTripZoneAction(EPWM1_BASE, EPWM_TZ_ACTION_EVENT_TZB,
                           EPWM_TZ_ACTION_HIGH);

    // Trigger event when DCBH is high
    EPWM_setTripZoneDigitalCompareEventCondition(EPWM1_BASE,
                                                 EPWM_TZ_DC_OUTPUT_B1,
                                                 EPWM_TZ_EVENT_DCXH_HIGH);

    // Configure DCBH to use TRIP4 as an input
    EPWM_enableDigitalCompareTripCombinationInput(EPWM1_BASE,
                                                  EPWM_DC_COMBINATIONAL_TRIPIN4,
                                                  EPWM_DC_TYPE_DCBH);

    // Enable DCB as OST
    EPWM_enableTripZoneSignals(EPWM1_BASE, EPWM_TZ_SIGNAL_DCBEVT1);

    // Configure the DCB path to be unfiltered and asynchronous
    EPWM_setDigitalCompareEventSource(EPWM1_BASE,
                                      EPWM_DC_MODULE_B,
                                      EPWM_DC_EVENT_1,
                                      EPWM_DC_EVENT_SOURCE_ORIG_SIGNAL);

    // Clear trip flags
    EPWM_clearTripZoneFlag(EPWM1_BASE, EPWM_TZ_INTERRUPT |
                           EPWM_TZ_FLAG_OST);

    // High-precision module configuration
    EPWM_setHrpwmDllCfg0(myPREEPWM,HRPWM_0CFG_VALUE);
}

//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	PinMux_init();
	CMPSS_init();
	OUTPUTXBAR_init();
    initEPWM();
}


#ifdef __cplusplus
}
#endif
