/**
*   @file    main.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "printf.h"
#include "device.h"
#include "cmpss_ex1_board.h"

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/**
  * \brief  Main program
  * \param  None
  * \retval None
  */
int main(void)
{
	Device_init();
//	MPU_Config();
	//UartPrint_init(LOG_SCI_BASE, 115200);
//  uart_init(115200);
	//printf("SCI print OK.\r\n");

    //
    // Board initialization
    // - Configure GPIO14 to output CTRIPOUT1H (routed through XBAROUTPUT3)
    // - Setup the Output X-BAR to output CTRIPOUTH on OUTPUTXBAR3
    // - Configure the high comparator of CMPSS1
    // - Enable CMPSS and configure the negative input signal to come from
    //   the DAC
    // - Use VDDA as the reference for the DAC and set DAC value to midpoint for
    //   arbitrary reference.
    // - Configure digital filter. For this example, the maxiumum values will be
    //   used for the clock prescale, sample window size, and threshold.
    // - Initialize the filter logic and start filtering
    // - Configure the output signals. Both CTRIPH and CTRIPOUTH will be fed by
    //   the filter output.
    //
    Board_init();

    // Loop indefinitely
    while(1)
    {

        // Trip flag is set when CTRIP signal is asserted
        if((EPWM_getTripZoneFlagStatus(EPWM1_BASE) &
            EPWM_TZ_FLAG_OST) != 0U)
        {
            // Wait for comparator CTRIP to de-assert
            while((CMPSS_getStatus(CMPSS1_BASE) & CMPSS_STS_HI_FILTOUT) != 0U)
            {
                ;
            }

            // Clear trip flags
            EPWM_clearTripZoneFlag(EPWM1_BASE, EPWM_TZ_INTERRUPT |
                                   EPWM_TZ_FLAG_OST);
        }
    }
  /* We should never get here as control is now taken by the scheduler */
  for(;;);
}

#ifdef __cplusplus
}
#endif

/*****END OF FILE****/

