/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    main.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "printf.h"
#include "device.h"
#include "cmpss_ex4_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

//int32_t uart_init(uint32_t baudrate)
//{
//    SCIA->SCI_MCR = 0;
//    SCIA->SCI_LCR = 0x80;
//    SCIA->SCI_DLL_THR = 1 + 20000000 / (baudrate*16);
//    SCIA->SCI_LCR = 0;
//    SCIA->SCI_LCR = 0x3;
//    return 0;
//}
//
//#define PUTCHAR_PROTOTYPE int fputc(int ch, FILE *f)
//PUTCHAR_PROTOTYPE
//{
//	SCIA->SCI_DLL_THR = ch;
//	while (!(SCIA->SCI_LSR & BIT(5)));
//	return ch;
//}
//
//int __io_putchar(int ch){
//	SCIA->SCI_DLL_THR = ch;
//	while (!(SCIA->SCI_LSR & BIT(5)));
//	return ch;
//}


/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/**
  * \brief  Main program
  * \param  None
  * \retval None
  */
int main(void)
{  
	Device_init();
//	MPU_Config();
	//UartPrint_init(LOG_SCI_BASE, 115200);
//  uart_init(115200);
	//printf("SCI print OK.\r\n");

    //
    // Board initialization
    // - Configure GPIO14 to output CTRIPOUT1H (routed through XBAROUTPUT3)
    // - Setup the Output X-BAR to output CTRIPOUTH on OUTPUTXBAR3
    // - Configure the high comparator of CMPSS1
    // - Enable CMPSS and configure the negative input signal to come from
    //   the DAC
    // - Use VDDA as the reference for the DAC and set DAC value to midpoint for
    //   arbitrary reference.
    // - Configure digital filter. For this example, the maxiumum values will be
    //   used for the clock prescale, sample window size, and threshold.
    // - Initialize the filter logic and start filtering
    // - Configure the output signals. Both CTRIPH and CTRIPOUTH will be fed by
    //   the filter output.
    //
    Board_init();
  /* We should never get here as control is now taken by the scheduler */
  for(;;);
}

#ifdef __cplusplus
}
#endif

/*****END OF FILE****/
