/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    board_cfg.h
*   @brief   board level configurations
*
*/

#ifndef __BOARD_CFG_H__
#define __BOARD_CFG_H__

#ifdef __cplusplus
extern "C"{
#endif


/**
  * @brief Configuration of the CRG
  */
/* ʹⲿپ */
#define __HSE_ENABLE                1 

/* ⲿ: 0 Դ, 1 Դ */
#define __HSE_CLOCK_TYPE            0

/* 趨PLLʱԴƵ: 10MHz IRC10MHz/20MHzⲿ */
#if __HSE_ENABLE == 0
#define DEVICE_OSCSRC_FREQ          (10*1000*1000)
#else
#define DEVICE_OSCSRC_FREQ          (20*1000*1000)
#endif

/* ϵͳʱ <= 300MHz */
#define DEVICE_SYSCLK_FREQ          (300*1000*1000U)

/* ϵͳʱӷƵ 1,2,4,8 */
#define DEVICE_SYSCLK_DIV           (2)

/* PLLʱ 120MHz ~ 800MHz */
#define DEVICE_PLLCLK_FREQ          (DEVICE_SYSCLK_FREQ * DEVICE_SYSCLK_DIV)

/* AHBʱӷƵ 1,2,4 */
#define DEVICE_AHBCLK_DIV           (4)

/* AHBʱƵ MHz */
#define DEVICE_AHBCLK_FREQ          (DEVICE_SYSCLK_FREQ/DEVICE_AHBCLK_DIV)      // <= 100MHz

/* APBʱӷƵ 1,2,4,8 */
#define DEVICE_APBCLK_DIV           (4)

/* APBʱƵ MHz */
#define DEVICE_APBCLK_FREQ          (DEVICE_SYSCLK_FREQ/DEVICE_APBCLK_DIV)      // <= 100MHz

/* ʱʱƵʵAPBʱƵ */
#define SOC_TIMER_FREQ              (DEVICE_APBCLK_FREQ)

/* Board Pin Configuration */
#define SCIA_TX_PIN                 GPIO_42_SCITXDA
#define SCIA_RX_PIN                 GPIO_43_SCIRXDA
#define SCIB_TX_PIN                 GPIO_14_SCITXDB
#define SCIB_RX_PIN                 GPIO_15_SCIRXDB

#define LOG_SCI_BASE                SCIB_BASE

#define GPIO_PIN_LED1               86
#define GPIO_PIN_LED2               87
#define GPIO_CFG_LED1               GPIO_86_GPIO86
#define GPIO_CFG_LED2               GPIO_87_GPIO87

#ifdef __cplusplus
}
#endif

#endif  /* __BOARD_CFG_H__ */
