

/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    Test_CpuCRC.c
*   @brief
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */


#include "device.h"
#include "printf.h"

#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "load_img.h"
#include "log.h"            //smp thread safe
#include "board_cfg.h"
#include "interrupt.h"
#include <CRC_ex03_dma.h>

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define CPU1_LED_PIN             LED1_PIN

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

uint8_t srcData8bit[8] = {0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88};
uint16_t srcData16bit[4] = {0x1122, 0x3344, 0x5566, 0x7788};
uint32_t srcData32bit[2] = {0x11223344, 0x55667788};


uint32_t CRC_result32[4];

uint32_t CRC_result16[4];

uint32_t CRC_result8[4];
volatile uint32_t cpu1Ticks = 0;

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

 /**
 * \brief   Test dmaCRC
 * \param   none
 * \retval  None
 */

void Test_dmaCRC(void)
{
	uint32_t in_rev_cfg;
	uint32_t out_rev_cfg;
	uint32_t seed_value;
	uint32_t poly_size;
	uint32_t poly_value;
	uint32_t data_len;
	uint32_t rslt_xor_out;
	uint32_t i;

   /* Config DMA to trans CRC result to memory */
   XDMA_ConfigParams dmaCfg = {0};

   //
   // Enable DMA channel 0 interrupt.
   //

   XDMA_initController(DMA1_BASE);


   /* Stop DMA channel first - why the DMA channel is still pending after reset? */
   XDMA_stopChannel(DMA1_CH1_BASE);

   /* XDMA Config */
   dmaCfg.enableInterrupt = 0;
   dmaCfg.srcAddr = (uint32_t)srcData32bit;
   dmaCfg.destAddr =CRC_DR;
   dmaCfg.blockTS = sizeof(srcData32bit)/4;
   dmaCfg.ttfc    = XDMA_TT_FC_0_M2M_DMAC;
   dmaCfg.srcBtl  = XDMA_BTL_4;
   dmaCfg.destBtl = XDMA_BTL_4;
   dmaCfg.srcAddrDirect = XDMA_ADDR_INCRE;
   dmaCfg.destAddrDirect = XDMA_ADDR_NO_CHANGE;
   dmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_4;
   dmaCfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_4;
   XDMA_configChannel(DMA1_CH1_BASE, &dmaCfg);
   delay_us(1000);

   /***********************************************************************************
    * Start of CRC32 examples
    ***********************************************************************************/
   /*
   CRC_Name	 		Expected Rslt	Poly		Init		RefIn	RefOut	XorOut
   CRC-32/AIXM 		0x59556055		0x814141AB	0x00000000	false	false	0x00000000
   /* Set CRC32bit to calculate */

	poly_size = CRC_POLYSIZE_32BIT;
	poly_value = 0x814141AB;
	seed_value = 0x00000000;
	in_rev_cfg = CRC_REVIN_NOTREV;
	out_rev_cfg = CRC_REVOUT_OFF;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData32bit)/4;
	CRC_startCalculation(CRC_BASE);
    XDMA_startChannel(DMA1_CH1_BASE);
	rslt_xor_out = 0x00000000;
	CRC_result32[0] = CRC_calcResult32(CRC_BASE, srcData32bit, data_len)^ rslt_xor_out;


/*******************************************************************/
	/* XDMA Config */
   dmaCfg.enableInterrupt = 0;
   dmaCfg.srcAddr = (uint16_t)srcData16bit;
   dmaCfg.destAddr = CRC_DR;
   dmaCfg.blockTS = sizeof(srcData16bit)/2;
   dmaCfg.ttfc    = XDMA_TT_FC_0_M2M_DMAC;
   dmaCfg.srcBtl  = XDMA_BTL_4;
   dmaCfg.destBtl = XDMA_BTL_4;
   dmaCfg.srcAddrDirect = XDMA_ADDR_INCRE;
   dmaCfg.destAddrDirect = XDMA_ADDR_NO_CHANGE;
   dmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_4;
   dmaCfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_4;
   XDMA_configChannel(DMA1_CH1_BASE, &dmaCfg);

   delay_us(1000);

   /***********************************************************************************
    * Start of CRC16 examples
    ***********************************************************************************/
   /*
   CRC_Name		Expected Rslt	Poly	Init	RefIn	RefOut	XorOut
   CRC-16/ARC		0x4BE1			0x8005	0x0000	true	true	0x0000
   /* Set CRC16bit to calculate */
	poly_size = CRC_POLYSIZE_16BIT;
	poly_value = 0x8005;
	seed_value = 0x0000;
	in_rev_cfg = CRC_REVIN_BYTEREV;
	out_rev_cfg = CRC_REVOUT_ON;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData16bit)/2;
    CRC_startCalculation(CRC_BASE);
    XDMA_startChannel(DMA1_CH1_BASE);
	rslt_xor_out = 0x0000;
	CRC_result16[0] = CRC_calcResult16(CRC_BASE, srcData16bit, data_len) ^ rslt_xor_out;


/*******************************************************************/
	/* XDMA Config */
   dmaCfg.enableInterrupt = 0;
   dmaCfg.srcAddr = (uint8_t)srcData8bit;
   dmaCfg.destAddr = CRC_DR;
   dmaCfg.blockTS = sizeof(srcData8bit);
   dmaCfg.ttfc    = XDMA_TT_FC_0_M2M_DMAC;
   dmaCfg.srcBtl  = XDMA_BTL_4;
   dmaCfg.destBtl = XDMA_BTL_4;
   dmaCfg.srcAddrDirect = XDMA_ADDR_INCRE;
   dmaCfg.destAddrDirect = XDMA_ADDR_NO_CHANGE;
   dmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_4;
   dmaCfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_4;
   XDMA_configChannel(DMA1_CH1_BASE, &dmaCfg);

   /***********************************************************************************
   * Start of CRC8 examples
    ***********************************************************************************/
   /*
   CRC_Name		Expected Rslt	Poly	Init	RefIn	RefOut	XorOut
   CRC-8/CDMA2000	0x2E			0x9B	0xFF	false	false	0x00
   /* Set CRC8bit to calculate */
   poly_size = CRC_POLYSIZE_8BIT;
   poly_value = 0x9B;
   seed_value = 0xFF;
   in_rev_cfg = CRC_REVIN_NOTREV;
   out_rev_cfg = CRC_REVOUT_OFF;
   CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
   data_len = sizeof(srcData8bit);
   CRC_startCalculation(CRC_BASE);
   XDMA_startChannel(DMA1_CH1_BASE);
   rslt_xor_out = 0x00;
   CRC_result8[0] = CRC_calcResult8(CRC_BASE, srcData8bit, data_len) ^ rslt_xor_out;


}

void delay_us(uint32_t delay_us)
{
  volatile unsigned int num;
  volatile unsigned int t;


  for (num = 0; num < delay_us; num++)
  {
    t = 11;
    while (t != 0)
    {
      t--;
    }
  }
}

void Timer0Init(void)
{
    CPUTimer_init(CPUTIMER0_BASE, DEVICE_APBCLK_FREQ/100);  //10ms
}


/**
  * \brief  Main program
  * \param  None
  * \retval None
  */

int main(void)
{
	  uint32_t oldTicks;

	    __disable_irq();
	    Device_init();

	    GPIO_enableWritePin(CPU1_LED_PIN);
	    GPIO_enableWritePin(22);


	    UartPrint_init(LOG_SCI_BASE, 115200);

	    log_info("Hello DSP200 CPU1 Template Project!\r\n");
	    log_info("CPU1 running @ %d MHz\r\n", DEVICE_SYSCLK_FREQ/1000/1000);
	    log_info("Code @ 0x%08X, Data @ 0x%08X\r\n", (uint32_t)main, (uint32_t)&oldTicks);
	    log_info("%d Cores, %d IRQn\r\n", CIDU_GetCoreNum(), CIDU_GetIntNum());

	    Timer0Init();
	    Test_dmaCRC();

	    oldTicks = cpu1Ticks;

	    while (1) {
	        if (cpu1Ticks != oldTicks) {
	            oldTicks = cpu1Ticks;

	            if ((oldTicks % 100) == 0) {
	                log_debug("ticks: %d\r\n", cpu1Ticks);
	                GPIO_togglePin(CPU1_LED_PIN);      //not thread safe
	            }
	        }
	    }

	    for(;;);

	    return 0;
}

#ifdef __cplusplus
}
#endif

