/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    CRC_ex04_1KB_8KB_calc.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include "float.h"
#include "stdio.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

//ѡ񿪹
#define CRC_1Kbyte_cals_time 0  /*1Kbyte CRC8 CRC16 CRC32ʱ䡣 0Ϊرգ1Ϊ*/
#define CRC_8Kbyte_cals_time 0  /*8Kbyte CRC8 CRC16 CRC32ʱ䡣 0Ϊرգ1Ϊ*/
#define CRC_Soft_lookup_table 1  /* CRC16 ʱ䡣 0Ϊرգ1Ϊ*/

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

//uint8_t srcData8bit[1024] = {
//    0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20,
//    0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x40,
//    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, 0x60,
//	0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x80,
//    0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F, 0xA0,
//    0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF, 0xC0,
//    0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF, 0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF, 0xE0,
//    0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF, 0x00,
//    0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20,
//    0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x40,
//    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, 0x60,
//	0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x80,
//    0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F, 0xA0,
//    0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF, 0xC0,
//    0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF, 0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF, 0xE0,
//    0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF, 0x00,
//    0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20,
//    0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x40,
//    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, 0x60,
//	0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x80,
//    0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F, 0xA0,
//    0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF, 0xC0,
//    0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF, 0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF, 0xE0,
//    0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF, 0x00,
//    0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20,
//    0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27, 0x28, 0x29, 0x2A, 0x2B, 0x2C, 0x2D, 0x2E, 0x2F, 0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F, 0x40,
//    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F, 0x60,
//	0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77, 0x78, 0x79, 0x7A, 0x7B, 0x7C, 0x7D, 0x7E, 0x7F, 0x80,
//    0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F, 0xA0,
//    0xA1, 0xA2, 0xA3, 0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF, 0xC0,
//    0xC1, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF, 0xD0, 0xD1, 0xD2, 0xD3, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF, 0xE0,
//    0xE1, 0xE2, 0xE3, 0xE4, 0xE5, 0xE6, 0xE7, 0xE8, 0xE9, 0xEA, 0xEB, 0xEC, 0xED, 0xEE, 0xEF, 0xF0, 0xF1, 0xF2, 0xF3, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xF9, 0xFA, 0xFB, 0xFC, 0xFD, 0xFE, 0xFF, 0x00};//1024ͬ8λʮ飨СΪ1Kbyteÿ0x01ʼÿε0x01.
//
//uint16_t srcData16bit[512] = {
//    0x0011, 0x0012, 0x0013, 0x0014, 0x0015, 0x0016, 0x0017, 0x0018, 0x0019, 0x001A, 0x001B, 0x001C, 0x001D, 0x001E, 0x001F, 0x0020,
//    0x0021, 0x0022, 0x0023, 0x0024, 0x0025, 0x0026, 0x0027, 0x0028, 0x0029, 0x002A, 0x002B, 0x002C, 0x002D, 0x002E, 0x002F, 0x0030,
//    0x0031, 0x0032, 0x0033, 0x0034, 0x0035, 0x0036, 0x0037, 0x0038, 0x0039, 0x003A, 0x003B, 0x003C, 0x003D, 0x003E, 0x003F, 0x0040,
//    0x0041, 0x0042, 0x0043, 0x0044, 0x0045, 0x0046, 0x0047, 0x0048, 0x0049, 0x004A, 0x004B, 0x004C, 0x004D, 0x004E, 0x004F, 0x0050,
//    0x0051, 0x0052, 0x0053, 0x0054, 0x0055, 0x0056, 0x0057, 0x0058, 0x0059, 0x005A, 0x005B, 0x005C, 0x005D, 0x005E, 0x005F, 0x0060,
//    0x0061, 0x0062, 0x0063, 0x0064, 0x0065, 0x0066, 0x0067, 0x0068, 0x0069, 0x006A, 0x006B, 0x006C, 0x006D, 0x006E, 0x006F, 0x0070,
//    0x0071, 0x0072, 0x0073, 0x0074, 0x0075, 0x0076, 0x0077, 0x0078, 0x0079, 0x007A, 0x007B, 0x007C, 0x007D, 0x007E, 0x007F, 0x0080,
//    0x0081, 0x0082, 0x0083, 0x0084, 0x0085, 0x0086, 0x0087, 0x0088, 0x0089, 0x008A, 0x008B, 0x008C, 0x008D, 0x008E, 0x008F, 0x0090,
//    0x0091, 0x0092, 0x0093, 0x0094, 0x0095, 0x0096, 0x0097, 0x0098, 0x0099, 0x009A, 0x009B, 0x009C, 0x009D, 0x009E, 0x009F, 0x00A0,
//    0x00A1, 0x00A2, 0x00A3, 0x00A4, 0x00A5, 0x00A6, 0x00A7, 0x00A8, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00AF, 0x00B0,
//    0x00B1, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6, 0x00B7, 0x00B8, 0x00B9, 0x00BA, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00BF, 0x00C0,
//    0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7, 0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF, 0x00D0,
//    0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x00D7, 0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF, 0x00E0,
//    0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF, 0x00F0,
//    0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x00F7, 0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x00FF, 0x0100,
//    0x0101, 0x0102, 0x0103, 0x0104, 0x0105, 0x0106, 0x0107, 0x0108, 0x0109, 0x010A, 0x010B, 0x010C, 0x010D, 0x010E, 0x010F, 0x0110,
//    0x0111, 0x0112, 0x0113, 0x0114, 0x0115, 0x0116, 0x0117, 0x0118, 0x0119, 0x011A, 0x011B, 0x011C, 0x011D, 0x011E, 0x011F, 0x0120,
//    0x0121, 0x0122, 0x0123, 0x0124, 0x0125, 0x0126, 0x0127, 0x0128, 0x0129, 0x012A, 0x012B, 0x012C, 0x012D, 0x012E, 0x012F, 0x0130,
//    0x0131, 0x0132, 0x0133, 0x0134, 0x0135, 0x0136, 0x0137, 0x0138, 0x0139, 0x013A, 0x013B, 0x013C, 0x013D, 0x013E, 0x013F, 0x0140,
//    0x0141, 0x0142, 0x0143, 0x0144, 0x0145, 0x0146, 0x0147, 0x0148, 0x0149, 0x014A, 0x014B, 0x014C, 0x014D, 0x014E, 0x014F, 0x0150,
//	0x0151, 0x0152, 0x0153, 0x0154, 0x0155, 0x0156, 0x0157, 0x0158, 0x0159, 0x015A, 0x015B, 0x015C, 0x015D, 0x015E, 0x015F, 0x0160,
//	0x0161, 0x0162, 0x0163, 0x0164, 0x0165, 0x0166, 0x0167, 0x0168, 0x0169, 0x016A, 0x016B, 0x016C, 0x016D, 0x016E, 0x016F, 0x0170,
//	0x0171, 0x0172, 0x0173, 0x0174, 0x0175, 0x0176, 0x0177, 0x0178, 0x0179, 0x017A, 0x017B, 0x017C, 0x017D, 0x017E, 0x017F, 0x0180,
//	0x0181, 0x0182, 0x0183, 0x0184, 0x0185, 0x0186, 0x0187, 0x0188, 0x0189, 0x018A, 0x018B, 0x018C, 0x018D, 0x018E, 0x018F, 0x0190,
//	0x0191, 0x0192, 0x0193, 0x0194, 0x0195, 0x0196, 0x0197, 0x0198, 0x0199, 0x019A, 0x019B, 0x019C, 0x019D, 0x019E, 0x019F, 0x01A0,
//	0x01A1, 0x01A2, 0x01A3, 0x01A4, 0x01A5, 0x01A6, 0x01A7, 0x01A8, 0x01A9, 0x01AA, 0x01AB, 0x01AC, 0x01AD, 0x01AE, 0x01AF, 0x01B0,
//	0x01B1, 0x01B2, 0x01B3, 0x01B4, 0x01B5, 0x01B6, 0x01B7, 0x01B8, 0x01B9, 0x01BA, 0x01BB, 0x01BC, 0x01BD, 0x01BE, 0x01BF, 0x01C0,
//	0x01C1, 0x01C2, 0x01C3, 0x01C4, 0x01C5, 0x01C6, 0x01C7, 0x01C8, 0x01C9, 0x01CA, 0x01CB, 0x01CC, 0x01CD, 0x01CE, 0x01CF, 0x01D0,
//	0x01D1, 0x01D2, 0x01D3, 0x01D4, 0x01D5, 0x01D6, 0x01D7, 0x01D8, 0x01D9, 0x01DA, 0x01DB, 0x01DC, 0x01DD, 0x01DE, 0x01DF, 0x01E0,
//	0x01E1, 0x01E2, 0x01E3, 0x01E4, 0x01E5, 0x01E6, 0x01E7, 0x01E8, 0x01E9, 0x01EA, 0x01EB, 0x01EC, 0x01ED, 0x01EE, 0x01EF, 0x01F0,
//	0x01F1, 0x01F2, 0x01F3, 0x01F4, 0x01F5, 0x01F6, 0x01F7, 0x01F8, 0x01F9, 0x01FA, 0x01FB, 0x01FC, 0x01FD, 0x01FE, 0x01FF, 0x0200,
//	0x0201, 0x0202, 0x0203, 0x0204, 0x0205, 0x0206, 0x0207, 0x0208, 0x0209, 0x020A, 0x020B, 0x020C, 0x020D, 0x020E, 0x020F, 0x0210};//512ͬ16λʮ(СΪ1Kbyte)ÿ0x0011ʼÿε0x0001
//
//uint32_t srcData32bit[256] = {
//    0x00000001, 0x00000002, 0x00000003, 0x00000004, 0x00000005, 0x00000006, 0x00000007, 0x00000008,
//    0x00000009, 0x0000000A, 0x0000000B, 0x0000000C, 0x0000000D, 0x0000000E, 0x0000000F, 0x00000010,
//    0x00000011, 0x00000012, 0x00000013, 0x00000014, 0x00000015, 0x00000016, 0x00000017, 0x00000018,
//    0x00000019, 0x0000001A, 0x0000001B, 0x0000001C, 0x0000001D, 0x0000001E, 0x0000001F, 0x00000020,
//    0x00000021, 0x00000022, 0x00000023, 0x00000024, 0x00000025, 0x00000026, 0x00000027, 0x00000028,
//    0x00000029, 0x0000002A, 0x0000002B, 0x0000002C, 0x0000002D, 0x0000002E, 0x0000002F, 0x00000030,
//    0x00000031, 0x00000032, 0x00000033, 0x00000034, 0x00000035, 0x00000036, 0x00000037, 0x00000038,
//    0x00000039, 0x0000003A, 0x0000003B, 0x0000003C, 0x0000003D, 0x0000003E, 0x0000003F, 0x00000040,
//    0x00000041, 0x00000042, 0x00000043, 0x00000044, 0x00000045, 0x00000046, 0x00000047, 0x00000048,
//    0x00000049, 0x0000004A, 0x0000004B, 0x0000004C, 0x0000004D, 0x0000004E, 0x0000004F, 0x00000050,
//    0x00000051, 0x00000052, 0x00000053, 0x00000054, 0x00000055, 0x00000056, 0x00000057, 0x00000058,
//    0x00000059, 0x0000005A, 0x0000005B, 0x0000005C, 0x0000005D, 0x0000005E, 0x0000005F, 0x00000060,
//    0x00000061, 0x00000062, 0x00000063, 0x00000064, 0x00000065, 0x00000066, 0x00000067, 0x00000068,
//    0x00000069, 0x0000006A, 0x0000006B, 0x0000006C, 0x0000006D, 0x0000006E, 0x0000006F, 0x00000070,
//    0x00000071, 0x00000072, 0x00000073, 0x00000074, 0x00000075, 0x00000076, 0x00000077, 0x00000078,
//    0x00000079, 0x0000007A, 0x0000007B, 0x0000007C, 0x0000007D, 0x0000007E, 0x0000007F, 0x00000080,
//    0x00000081, 0x00000082, 0x00000083, 0x00000084, 0x00000085, 0x00000086, 0x00000087, 0x00000088,
//    0x00000089, 0x0000008A, 0x0000008B, 0x0000008C, 0x0000008D, 0x0000008E, 0x0000008F, 0x00000090,
//    0x00000091, 0x00000092, 0x00000093, 0x00000094, 0x00000095, 0x00000096, 0x00000097, 0x00000098,
//    0x00000099, 0x0000009A, 0x0000009B, 0x0000009C, 0x0000009D, 0x0000009E, 0x0000009F, 0x000000A0,
//    0x000000A1, 0x000000A2, 0x000000A3, 0x000000A4, 0x000000A5, 0x000000A6, 0x000000A7, 0x000000A8,
//    0x000000A9, 0x000000AA, 0x000000AB, 0x000000AC, 0x000000AD, 0x000000AE, 0x000000AF, 0x000000B0,
//    0x000000B1, 0x000000B2, 0x000000B3, 0x000000B4, 0x000000B5, 0x000000B6, 0x000000B7, 0x000000B8,
//    0x000000B9, 0x000000BA, 0x000000BB, 0x000000BC, 0x000000BD, 0x000000BE, 0x000000BF, 0x000000C0,
//    0x000000C1, 0x000000C2, 0x000000C3, 0x000000C4, 0x000000C5, 0x000000C6, 0x000000C7, 0x000000C8,
//    0x000000C9, 0x000000CA, 0x000000CB, 0x000000CC, 0x000000CD, 0x000000CE, 0x000000CF, 0x000000D0,
//    0x000000D1, 0x000000D2, 0x000000D3, 0x000000D4, 0x000000D5, 0x000000D6, 0x000000D7, 0x000000D8,
//    0x000000D9, 0x000000DA, 0x000000DB, 0x000000DC, 0x000000DD, 0x000000DE, 0x000000DF, 0x000000E0,
//    0x000000E1, 0x000000E2, 0x000000E3, 0x000000E4, 0x000000E5, 0x000000E6, 0x000000E7, 0x000000E8,
//    0x000000E9, 0x000000EA, 0x000000EB, 0x000000EC, 0x000000ED, 0x000000EE, 0x000000EF, 0x000000F0,
//    0x000000F1, 0x000000F2, 0x000000F3, 0x000000F4, 0x000000F5, 0x000000F6, 0x000000F7, 0x000000F8,
//    0x000000F9, 0x000000FA, 0x000000FB, 0x000000FC, 0x000000FD, 0x000000FE, 0x000000FF, 0x00000100};//256ͬ32λʮ(СΪ1Kbyte)ÿ0x00000001ʼÿε0x00000001


/*
 * CRC input data.
 */
uint8_t crc_input[1024];


/*
 * CRC16 lookup table for CRC-16/MODBUS:
 * poly=0x8005, init=0xFFFF, RevIn=ture, RevOut=ture, XorOut=0;
 */
// CRC-16/MODBUSұ
const uint16_t crc_table[256] = {
    0x0000, 0xC0C1, 0xC181, 0x0140, 0xC301, 0x03C0, 0x0280, 0xC241,
    0xC601, 0x06C0, 0x0780, 0xC741, 0x0500, 0xC5C1, 0xC481, 0x0440,
    0xCC01, 0x0CC0, 0x0D80, 0xCD41, 0x0F00, 0xCFC1, 0xCE81, 0x0E40,
    0x0A00, 0xCAC1, 0xCB81, 0x0B40, 0xC901, 0x09C0, 0x0880, 0xC841,
    0xD801, 0x18C0, 0x1980, 0xD941, 0x1B00, 0xDBC1, 0xDA81, 0x1A40,
    0x1E00, 0xDEC1, 0xDF81, 0x1F40, 0xDD01, 0x1DC0, 0x1C80, 0xDC41,
    0x1400, 0xD4C1, 0xD581, 0x1540, 0xD701, 0x17C0, 0x1680, 0xD641,
    0xD201, 0x12C0, 0x1380, 0xD341, 0x1100, 0xD1C1, 0xD081, 0x1040,
    0xF001, 0x30C0, 0x3180, 0xF141, 0x3300, 0xF3C1, 0xF281, 0x3240,
    0x3600, 0xF6C1, 0xF781, 0x3740, 0xF501, 0x35C0, 0x3480, 0xF441,
    0x3C00, 0xFCC1, 0xFD81, 0x3D40, 0xFF01, 0x3FC0, 0x3E80, 0xFE41,
    0xFA01, 0x3AC0, 0x3B80, 0xFB41, 0x3900, 0xF9C1, 0xF881, 0x3840,
    0x2800, 0xE8C1, 0xE981, 0x2940, 0xEB01, 0x2BC0, 0x2A80, 0xEA41,
    0xEE01, 0x2EC0, 0x2F80, 0xEF41, 0x2D00, 0xEDC1, 0xEC81, 0x2C40,
    0xE401, 0x24C0, 0x2580, 0xE541, 0x2700, 0xE7C1, 0xE681, 0x2640,
    0x2200, 0xE2C1, 0xE381, 0x2340, 0xE101, 0x21C0, 0x2080, 0xE041,
    0xA001, 0x60C0, 0x6180, 0xA141, 0x6300, 0xA3C1, 0xA281, 0x6240,
    0x6600, 0xA6C1, 0xA781, 0x6740, 0xA501, 0x65C0, 0x6480, 0xA441,
    0x6C00, 0xACC1, 0xAD81, 0x6D40, 0xAF01, 0x6FC0, 0x6E80, 0xAE41,
    0xAA01, 0x6AC0, 0x6B80, 0xAB41, 0x6900, 0xA9C1, 0xA881, 0x6840,
    0x7800, 0xB8C1, 0xB981, 0x7940, 0xBB01, 0x7BC0, 0x7A80, 0xBA41,
    0xBE01, 0x7EC0, 0x7F80, 0xBF41, 0x7D00, 0xBDC1, 0xBC81, 0x7C40,
    0xB401, 0x74C0, 0x7580, 0xB541, 0x7700, 0xB7C1, 0xB681, 0x7640,
    0x7200, 0xB2C1, 0xB381, 0x7340, 0xB101, 0x71C0, 0x7080, 0xB041,
    0x5000, 0x90C1, 0x9181, 0x5140, 0x9301, 0x53C0, 0x5280, 0x9241,
    0x9601, 0x56C0, 0x5780, 0x9741, 0x5500, 0x95C1, 0x9481, 0x5440,
    0x9C01, 0x5CC0, 0x5D80, 0x9D41, 0x5F00, 0x9FC1, 0x9E81, 0x5E40,
    0x5A00, 0x9AC1, 0x9B81, 0x5B40, 0x9901, 0x59C0, 0x5880, 0x9841,
    0x8801, 0x48C0, 0x4980, 0x8941, 0x4B00, 0x8BC1, 0x8A81, 0x4A40,
    0x4E00, 0x8EC1, 0x8F81, 0x4F40, 0x8D01, 0x4DC0, 0x4C80, 0x8C41,
    0x4400, 0x84C1, 0x8581, 0x4540, 0x8701, 0x47C0, 0x4680, 0x8641,
    0x8201, 0x42C0, 0x4380, 0x8341, 0x4100, 0x81C1, 0x8081, 0x4040
};

uint32_t CRC_result32[4];

uint32_t CRC_result16[4];
uint32_t CRC_ts[4];

uint32_t CRC_result8[4];


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


/*
 * @brief      Perform CRC16 on input data array with software lookup table
 * @param[in]  input_array, pointer to input data array
 * @param[in]  input_length, length of input data array
 * @return     CRC16 result of the input data array
 *
 * @details    There are 9 instructions in one loop
 *             1Kbyte data needs 1024 loops = 9236 instructions
 */
uint16_t calculate_crc16(uint8_t *input_array, uint16_t input_length)
{
	uint16_t crctmp = 0xFFFF;
	uint8_t crc_index;
    for (uint16_t i = 0; i < input_length; i++)
    {
        crc_index = (crctmp ^ input_array[i]) & 0xff;
        crctmp = (crc_table[crc_index] ^ (crctmp >> 8)) & 0xFFFF;
    }
    return crctmp;
}

/*
 * \brief    Perform CRC16 on input data array with CRC hardware.
 * \param[in]  pBufIn, pointer to input data array
 * \param[in]  len, length of input data array
 * \return     CRC16 result of the input data array
 */
uint16_t CRC_calcCrc16Test(uint8_t *pBufIn, uint32_t len)
{
	uint32_t in_rev_cfg;
	uint32_t out_rev_cfg;
	uint32_t seed_value;
	uint32_t poly_size;
	uint32_t poly_value;
	uint32_t data_len;
	uint32_t rslt_xor_out;

	uint16_t *pDataIn;

	uint16_t ret;

	/* CRC hardware initialization */
	poly_size = CRC_POLYSIZE_16BIT;
	poly_value = 0x8005;
	seed_value = 0xFFFF;
	in_rev_cfg = CRC_REVIN_BYTEREV;
	out_rev_cfg = CRC_REVOUT_ON;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = len/2;
	rslt_xor_out = 0x0000;

	/* swap input data byte order, so as to process the data in 16bit width. */
	pDataIn = (uint16_t*)(pBufIn);
	for(uint32_t i=0; i<data_len; i++)
	{
		*pDataIn = __gs_bswap16(*pDataIn);
		pDataIn++;
	}

	/* CRC calculation by CRC HW. */
	CRC_ts[2] = CPU_getCycleCnt();
	CRC_ts[3] = CPU_getInstrCnt();
	ret = CRC_calcResult16(CRC_BASE, (uint16_t*)(pBufIn), data_len) ^ rslt_xor_out;
	CRC_ts[2] = CPU_getCycleCnt()-CRC_ts[2];
	CRC_ts[3] = CPU_getInstrCnt()-CRC_ts[3];

	return ret;
}
/*
 * @brief
 * @param  None
 * @retval None
 */
//ROMFUNC_T
int main(void)
{
	uint32_t in_rev_cfg;
	uint32_t out_rev_cfg;
	uint32_t seed_value;
	uint32_t poly_size;
	uint32_t poly_value;
	uint32_t data_len;
	uint32_t rslt_xor_out;
	uint32_t ts1=0;
	uint32_t ts2=0;
	uint32_t ts3=0;
	uint32_t ts4=0;
	uint32_t ts5=0;
	uint32_t ts6=0;
	uint32_t ts7=0;
	uint32_t ts8=0;
	Device_init();

	UartPrint_init(SCIA_BASE, 115200);

#if CRC_1Kbyte_cals_time
	/***********************************************************************************
	 * Start of CRC32 1KB examples
	 ***********************************************************************************/
	/*
	 					Expected Rslt	Poly		Init		RefIn	RefOut	XorOut
	CRC-32/AIXM 		0x2B22BD20		0x814141AB	0x00000000	false	false	0x00000000
	*/
	/*256ԪأСΪ1KBÿԪһ32λ޷ÿԪ32λʮеÿ 0x00000001 ʼÿε 0x0001*/
	uint32_t srcData32bit1KB[256];
	for (uint16_t i = 0; i < 256; i++) {
		srcData32bit1KB[i] = 0x00000001 + i;
	}
	poly_size = CRC_POLYSIZE_32BIT;
	poly_value = 0x814141AB;
	seed_value = 0x00000000;
	in_rev_cfg = CRC_REVIN_NOTREV;
	out_rev_cfg = CRC_REVOUT_OFF;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData32bit1KB)/4;
	rslt_xor_out = 0x00000000;
	//ʼʱ
	ts1 = CPU_getCycleCnt();
	//ִCRC
	CRC_result32[0] = CRC_calcResult32(CRC_BASE, srcData32bit1KB, data_len)^ rslt_xor_out;
	//ʱ
	ts2 = CPU_getCycleCnt();
	//CRCʱ
	printf("CRC 32 1KB run time ts2=%d,ts1=%d,Lasting Time:t =%d \r\n",ts2,ts1,(ts2-ts1));

	/***********************************************************************************
	 * end of CRC32 1KB examples
	 ***********************************************************************************/


	/***********************************************************************************
	 * Start of CRC16 1KB examples
	 ***********************************************************************************/
	/*
	CRC_Name		Expected Rslt	Poly	Init	RefIn	RefOut	XorOut
	CRC-16/ARC		0x49CC			0x8005	0x0000	true	true	0x0000
	*/
	//512ԪأСΪ1KBÿԪһ16λ޷Щ 0x0011 ʼÿε 0x0001
	uint16_t srcData16bit1KB[512];
	for (uint16_t i = 0; i < 512; i++) {
	    srcData16bit1KB[i] = 0x0011 + i;
	}
	poly_size = CRC_POLYSIZE_16BIT;
	poly_value = 0x8005;
	seed_value = 0x0000;
	in_rev_cfg = CRC_REVIN_BYTEREV;
	out_rev_cfg = CRC_REVOUT_ON;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData16bit1KB)/2;
	rslt_xor_out = 0x0000;
	//ʼʱ
	ts3 = CPU_getCycleCnt();
	ts4 = CPU_getInstrCnt();
	//ִCRC
	CRC_result16[0] = CRC_calcResult16(CRC_BASE, srcData16bit1KB, data_len) ^ rslt_xor_out;
	//ʱ
	ts5 = CPU_getCycleCnt();
	ts6 = CPU_getInstrCnt();
	//CRCʱ
//	printf("CRC 16 1KB run time ts4=%d,ts3=%d,Lasting Time:t =%d \r\n",ts4,ts3,(ts4-ts3));
	printf("CRC16 1KB, CPU Cycles cnt: t =%d; CPU inst cnt: t =%d \r\n",(ts5-ts3),(ts6-ts4));

	/***********************************************************************************
	 * end of CRC16 1KB examples
	 ***********************************************************************************/


	/***********************************************************************************
	 * Start of CRC8 1KB examples
	 ***********************************************************************************/
	/*
	CRC_Name		Expected Rslt	Poly	Init	RefIn	RefOut	XorOut
	CRC-8/BLUETOOTH	0xBD			0xA7	0x00	true	true	0x00
	*/
	//1024ԪأСΪ1KBÿԪһ8λ޷8λ޷ѭص0Щ 0x01 ʼÿε 0x01
	uint8_t srcData8bit1KB[1024];
	for (uint16_t i = 0; i < 1024; i++) {
		srcData8bit1KB[i] = (uint8_t)(0x01 + i);
	}
	poly_size = CRC_POLYSIZE_8BIT;
	poly_value = 0xA7;
	seed_value = 0x00;
	in_rev_cfg = CRC_REVIN_BYTEREV;
	out_rev_cfg = CRC_REVOUT_ON;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData8bit1KB);
	rslt_xor_out = 0x00;
	//ʼʱ
	ts7 = CPU_getCycleCnt();
	//ִCRC
	CRC_result8[0] = CRC_calcResult8(CRC_BASE, srcData8bit1KB, data_len) ^ rslt_xor_out;
	//ʱ
	ts8 = CPU_getCycleCnt();
	//CRCʱ
	printf("CRC 8 1KB run time ts6=%d,ts5=%d,Lasting Time:t =%d \r\n",ts8,ts7,(ts8-ts7));
	/***********************************************************************************
	 * end of CRC8 1KB examples
	 ***********************************************************************************/
#endif

#if CRC_Soft_lookup_table
	/* CRC input data initialization */
	for(uint32_t i=0; i<sizeof(crc_input); i++)
		crc_input[i] = (uint8_t)i;

	 /* CRC16 calculation by software looup table. */
	 CRC_ts[0] = CPU_getCycleCnt();
	 CRC_ts[1] = CPU_getInstrCnt();
	 CRC_result16[0] = calculate_crc16(crc_input, sizeof(crc_input));//CRC16 result by software --> 0xecfe
	 CRC_ts[0] = CPU_getCycleCnt()-CRC_ts[0];
	 CRC_ts[1] = CPU_getInstrCnt()-CRC_ts[1];
	 /* CRC16 calculation by hardware. */
	 CRC_result16[1] = CRC_calcCrc16Test(crc_input, sizeof(crc_input));//CRC16 result by hardware --> 0xecfe

#endif

#if CRC_8Kbyte_cals_time

	/***********************************************************************************
	 * Start of CRC32 8KB examples
	 ***********************************************************************************/
	/*
	 					Expected Rslt	Poly		Init		RefIn	RefOut	XorOut
	CRC-32/AIXM 		0x8980516A		0x814141AB	0x00000000	false	false	0x00000000
	*/
	//2048ԪأСΪ8KBÿԪһ32λ޷ÿԪ16λʮǿԽǿ uint16_t ͣʵǴ洢32λСеÿ 0x00000001 ʼÿε 0x0001
	uint32_t srcData32bit8KB[2048];
	for (uint16_t i = 0; i < 2048; i++) {
		srcData32bit8KB[i] = 0x00000001 + i;
	}

	poly_size = CRC_POLYSIZE_32BIT;
	poly_value = 0x814141AB;
	seed_value = 0x00000000;
	in_rev_cfg = CRC_REVIN_NOTREV;
	out_rev_cfg = CRC_REVOUT_OFF;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData32bit8KB)/4;
	rslt_xor_out = 0x00000000;
	//ʼʱ
	ts1 = CPU_getCycleCnt();
	//ִCRC
	CRC_result32[1] = CRC_calcResult32(CRC_BASE, srcData32bit8KB, data_len)^ rslt_xor_out;
	//ʱ
	ts2 = CPU_getCycleCnt();
	//CRCʱ
	printf("CRC 32 8KB run time ts2=%d,ts1=%d,Lasting Time:t =%d \r\n",ts2,ts1,(ts2-ts1));

	/***********************************************************************************
	 * end of CRC32 8KB examples
	 ***********************************************************************************/


	/***********************************************************************************
	 * Start of CRC16 8KB examples
	 ***********************************************************************************/
	/*
	CRC_Name		Expected Rslt	Poly	Init	RefIn	RefOut	XorOut
	CRC-16/ARC		0x65D9			0x8005	0x0000	true	true	0x0000
	*/
	//4096ԪأСΪ8KBÿԪһ16λ޷Щ 0x0001 ʼÿε 0x0001
	uint16_t srcData16bit8KB[4096];
	for (uint16_t i = 0; i < 4096; i++) {
		srcData16bit8KB[i] = 0x0001 + i;
	}

	poly_size = CRC_POLYSIZE_16BIT;
	poly_value = 0x8005;
	seed_value = 0x0000;
	in_rev_cfg = CRC_REVIN_BYTEREV;
	out_rev_cfg = CRC_REVOUT_ON;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData16bit8KB)/2;
	rslt_xor_out = 0x0000;
	//ʼʱ
	ts3 = CPU_getCycleCnt();
	//ִCRC
	CRC_result16[1] = CRC_calcResult16(CRC_BASE, srcData16bit8KB, data_len) ^ rslt_xor_out;
	//ʱ
	ts4 = CPU_getCycleCnt();
	//CRCʱ
	printf("CRC 16 8KB run time ts4=%d,ts3=%d,Lasting Time:t =%d \r\n",ts4,ts3,(ts4-ts3));

	/***********************************************************************************
	 * end of CRC16 8KB examples
	 ***********************************************************************************/


	/***********************************************************************************
	 * Start of CRC8 8KB examples
	 ***********************************************************************************/
	/*
	CRC_Name		Expected Rslt	Poly	Init	RefIn	RefOut	XorOut
	CRC-8/BLUETOOTH	0xEB			0xA7	0x00	true	true	0x00
	*/

	//8192ԪأСΪ8KBÿԪһ8λ޷8λ޷ѭص0Щ 0x01 ʼÿε 0x01
	uint8_t srcData8bit8KB[8192];
	for (uint16_t i = 0; i < 8192; i++) {
	    srcData8bit8KB[i] = (uint8_t)(0x01 + i);
	}
	poly_size = CRC_POLYSIZE_8BIT;
	poly_value = 0xA7;
	seed_value = 0x00;
	in_rev_cfg = CRC_REVIN_BYTEREV;
	out_rev_cfg = CRC_REVOUT_ON;
	CRC_setConfig(CRC_BASE, poly_size, poly_value, in_rev_cfg, out_rev_cfg, seed_value);
	data_len = sizeof(srcData8bit8KB);
	rslt_xor_out = 0x00;
	//ʼʱ
	ts5 = CPU_getCycleCnt();
	//ִCRC
	CRC_result8[1] = CRC_calcResult8(CRC_BASE, srcData8bit8KB, data_len) ^ rslt_xor_out;
	//ʱ
	ts6 = CPU_getCycleCnt();
	//CRCʱ
	printf("CRC 8 8KB run time ts6=%d,ts5=%d,Lasting Time:t =%d \r\n",ts6,ts5,(ts6-ts5));
	/***********************************************************************************
	 * end of CRC8 8KB examples
	 ***********************************************************************************/
#endif

	for(;;);
	return 0;
}


#ifdef __cplusplus
}
#endif

