/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    xdma_dsp_ex01_ecap_pwm_board.h
*   @brief   
*
*/

#ifndef XDMA_DSP_EX01_ECAP_PWM_BOARD_H_
#define XDMA_DSP_EX01_ECAP_PWM_BOARD_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "driverlib.h"
#include "device.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define ReqID_ECAP  (DMAMUX_ReqId_Trig_ecap1)
#define myECAP_BASE    ECAP1_BASE
#define myECAP_SYNC_IN_OFFSET     SYSCTL_SYNCSEL_ECAP1_SYNCIN
#define INT_myECAP INT_ECAP1
//
//  ECAP XBAR INPUT0 from GPIO5
//
#define myINPUTXBARINPUT_SOURCE 0
#define myINPUTXBARINPUT_INPUT XBAR_INPUT3

//
// EPWM1_A - GPIO Settings
//
#define myEPWM_BASE    EPWM2_BASE
#define myEPWM_EPWMA_GPIO 0
#define myEPWM_EPWMA_PIN_CONFIG GPIO_0_EPWM1A

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/**
 * \brief   "Board Configurations
 *          Initializes the rest of the modules. 
 *          Call this function in your application if you wish to do all module initialization. 
 *          If you wish to not use some of the initializations, instead of the
 *          Board_init use the individual Module_inits" 
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void Board_init(void);

/**
 * \brief   "ECAP Configurations for ECAP1"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void myECAP0_init(void);

/**
 * \brief   "ECAP Configurations"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void ECAP_init(void);

/**
 * \brief   "GPIO Configurations for ECAP1"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void myGPIO0_init(void);

/**
 * \brief   "GPIO Configurations"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void GPIO_init(void);

/**
 * \brief   "INPUTXBAR Configurations for ECAP1"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void myINPUTXBARINPUT0_init(void);

/**
 * \brief   "INPUTXBAR Configurations"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void INPUTXBAR_init(void);

/**
 * \brief   "PinMux Configurations" 
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void PinMux_init(void);

/**
 * \brief   "add brief description of this function" 
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */


#ifdef __cplusplus
}
#endif


#endif /* XDMA_DSP_EX01_ECAP_PWM_BOARD_H_ */
