/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    xdma_dsp_ex04_CPUTime_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "xdma_dsp_ex04_CPUTime_board.h"
#include "stdio.h"
#include "device.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* CPU freq is 20MHz, the CPU timer0 period is 100mS */
#define CPUTIMER0_PERIOD 2000000

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/**
 * \brief   浠ユ寚瀹氬懆鏈熷垵濮嬪寲CpuTimer瀹氭椂鍣?
 * \param   base   瀹氭椂鍣ㄦā鍧楀熀鍦板?
 * \param   period   瀹氭椂鍣ㄥ懆鏈�
 * \retval  None
 */
void Test_CpuTimer_Init(uint32_t base, uint32_t period)
{
    if(period > 0xFFFF)
    {
        CPUTimer_setTimerSize(base, CPUTIMER_TIMERSIZE_32BIT);
    }
    else 
    {
        CPUTimer_setTimerSize(base, CPUTIMER_TIMERSIZE_16BIT);
    }
    CPUTimer_setTimerMode(base, CPUTIMER_TIMERMODE_PERIODIC);
    /* 璁剧疆瀹氭椂鍣ㄥ懆鏈� */
    CPUTimer_setPeriod(base, period);
    /* 浣胯兘瀹氭椂鍣ㄤ腑鏂� */
    CPUTimer_enableInterrupt(base);
    /* 鍚姩瀹氭椂鍣? */
    CPUTimer_startTimer(base);
    return;
}

void Test_CpuTimer_Dma_Transfer(void)
{   
    uint32_t status = 0;
    uint32_t i;
    XDMA_ConfigParams dmaCfg = {0};

    /* DMA global enable */
    XDMA_initController(DMA1_BASE);
    
    /* Stop DMA channel first - why the DMA channel is still pending after reset? */
    XDMA_stopChannel(DMA1_CH1_BASE);
    dmaCfg.enableInterrupt = 1;
    dmaCfg.dmaDstReqId = DMAMUX_ReqId_Trig_ap_timer0;
    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_Trig_ap_timer1;
    dmaCfg.srcAddr = (CPUTIMER1_BASE + CPUTIMER_O_TIMERXBGLOAD);
    dmaCfg.destAddr = (CPUTIMER0_BASE + CPUTIMER_O_TIMERXBGLOAD);
    dmaCfg.blockTS = 1;
    dmaCfg.ttfc    = XDMA_TT_FC_3_P2P_DMAC;
    dmaCfg.srcBtl  = XDMA_BTL_1;
    dmaCfg.destBtl = XDMA_BTL_1;
    dmaCfg.srcAddrDirect = XDMA_ADDR_NO_CHANGE;
    dmaCfg.destAddrDirect = XDMA_ADDR_NO_CHANGE;
    dmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_4;
    dmaCfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_4;
    XDMA_configChannel(DMA1_CH1_BASE, &dmaCfg);
    XDMA_clearInterrupt(DMA1_CH1_BASE, XDMA_INT_TFR | XDMA_INT_ERR);
    XDMA_unMaskInterrupt(DMA1_CH1_BASE, XDMA_INT_TFR | XDMA_INT_ERR);

    /* XDMA channel enable */
    XDMA_startChannel(DMA1_CH1_BASE);

    while(status == 0)
    {
        status = XDMA_getInterruptStatus(DMA1_CH1_BASE);
    }
    if (status & XDMA_INT_ERR)
    {
        printf("cputimer DMA transfer test Fail.\r\n");
        return;
    }

    if (HWREG(CPUTIMER0_BASE + CPUTIMER_O_TIMERXBGLOAD) == HWREG(CPUTIMER1_BASE + CPUTIMER_O_TIMERXBGLOAD))
        printf("cputimer DMA transfer test OK.\r\n");
    else
        printf("cputimer DMA transfer test Fail.\r\n");
    return;
}

 /**
 * \brief   娴嬭瘯CpuTimer鐨勫畾鏃朵腑鏂姛鑳?
 * \param   none
 * \retval  None
 */
void Test_CpuTimer_ex04(void)
{
    /* 鍒濆鍖朇puTimer0鍜孋puTimer1 */
    Test_CpuTimer_Init(CPUTIMER0_BASE, CPUTIMER0_PERIOD+10);
    Test_CpuTimer_Init(CPUTIMER1_BASE, CPUTIMER0_PERIOD+100);

    Test_CpuTimer_Dma_Transfer();

    CPUTimer_stopTimer(CPUTIMER0_BASE);
    CPUTimer_stopTimer(CPUTIMER1_BASE);

    printf("test_CpuTimer_ex03 end \r\n");
}

#ifdef __cplusplus
}
#endif

