/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    xdma_dsp_ex06_spi_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "xdma_dsp_ex06_spi_board.h"
#include "cpu.h"
#include "epwm.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */



/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */



/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/*******************************************************************************

 *******************************************************************************/




void board_init()
{

	PinMux_init();
	Spi_init();
    /* DMA global enable */
    XDMA_initController(DMA1_BASE);
	dma_spi_tx();
	dma_spi_rx();

}


void PinMux_init()
{
	// SPIA Pin Mux
	//SPIA_STE_GP19
	GPIO_setPinConfig(mySPI0_SPISTE_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPISTE_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPISTE_GPIO, GPIO_QUAL_ASYNC);

	//SPIA_CLK_GP18
	GPIO_setPinConfig(mySPI0_SPICLK_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPICLK_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPICLK_GPIO, GPIO_QUAL_ASYNC);

	//SPIA_SIMO_GP16
	GPIO_setPinConfig(mySPI0_SPISIMO_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPISIMO_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPISIMO_GPIO, GPIO_QUAL_ASYNC);

	//SPIA_SOMI_GP17
	GPIO_setPinConfig(mySPI0_SPISOMI_PIN_CONFIG);
	GPIO_setPadConfig(mySPI0_SPISOMI_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(mySPI0_SPISOMI_GPIO, GPIO_QUAL_ASYNC);

}




void Spi_init()
{
    // ʼǰʧSPIģ飬ʹSPIA
	SPI_disableModule(mySPI_BASE);

	// ʼSPIAģ飬SPI߲ʣ120Mhz/4ʱӼʱλMode 0. Polarity 0, phase 0. Rising edge with delay.
	//ѡģʽSPIģʽ SPIʣ1000000  ֡С16bit
	SPI_setConfig(mySPI_BASE,DEVICE_APBCLK_FREQ,SPI_PROT_POL0PHA0,\
			SPI_MODE_CONTROLLER,mySPI_BITRATE,mySPI_DATAWIDTH);

    // жˮ
    SPI_setFIFOInterruptLevel(mySPI_BASE, SPI_FIFO_TX1, SPI_FIFO_RX1);

	// ʧж
	SPI_disableAllInterrupt(mySPI_BASE);

	//ж
	SPI_clearInterruptStatus(mySPI_BASE, SPI_INT_RXFF_OVERFLOW | SPI_INT_RXFF_UNDERFLOW | SPI_INT_TXFF_OF);

	// ʹж
	SPI_enableInterrupt(mySPI_BASE, SPI_INT_RXFF_OVERFLOW | SPI_INT_RXFF_UNDERFLOW | SPI_INT_TXFF_OF);

	// 򿪻
	SPI_enableLoopback(mySPI_BASE);

	//  TX FIFOˮ߿DMA
	SPI_setDmaTxDataLevel(mySPI_BASE,SPI_FIFO_TX4);

	//  RX FIFOˮ߿DMA
	SPI_setDmaRxDataLevel(mySPI_BASE,SPI_FIFO_RX4);

	//ʹDMAtran
	SPI_enableTransmitDMA(mySPI_BASE);

	//ʹDMArecv
	SPI_enableReceiveDMA(mySPI_BASE);

    // ʹSPIģ
    SPI_enableModule(mySPI_BASE);

    // ʹCS!!
    SPI_enableCS(mySPI_BASE);

}


void dma_spi_tx(void)
{
    XDMA_ConfigParams dmaCfg1 = {0};
    XDMA_stopChannel(DMA1_CH1_BASE);

    dmaCfg1.enableInterrupt = 1;
    dmaCfg1.srcAddr = (uint32_t)(&SPI_TXBUF[0]);
    dmaCfg1.destAddr = (mySPI_BASE + SPI_O_DATAREG);
    dmaCfg1.blockTS = 32;
    dmaCfg1.ttfc    = XDMA_TT_FC_1_M2P_DMAC;
    dmaCfg1.srcBtl  = XDMA_BTL_4;
    dmaCfg1.destBtl = XDMA_BTL_4;
    dmaCfg1.srcAddrDirect = XDMA_ADDR_INCRE;
    dmaCfg1.destAddrDirect = XDMA_ADDR_NO_CHANGE;
    dmaCfg1.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_2;
    dmaCfg1.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_2;

    dmaCfg1.dmaDstReqId = DMAMUX_ReqId_spi1_tx;

    /* Clear INT flag set in previous operation */
    /* Enable the IRQ so that we can poll the Status_Tfr flag */

    XDMA_unMaskInterrupt(DMA1_CH1_BASE, XDMA_INT_TFR);
    XDMA_clearInterrupt(DMA1_CH1_BASE, XDMA_INT_TFR);

    XDMA_configChannel(DMA1_CH1_BASE, &dmaCfg1);

}

void dma_spi_rx(void)
{
    XDMA_ConfigParams dmaCfg2 = {0};
    XDMA_stopChannel(DMA1_CH2_BASE);

    dmaCfg2.enableInterrupt = 1;
    dmaCfg2.srcAddr = (mySPI_BASE + SPI_O_DATAREG);
    dmaCfg2.destAddr = (uint32_t)(&SPI_RXBUF[0]);
    dmaCfg2.blockTS = 32;
    dmaCfg2.ttfc    = XDMA_TT_FC_2_P2M_DMAC;
    dmaCfg2.srcBtl  = XDMA_BTL_4;
    dmaCfg2.destBtl = XDMA_BTL_4;
    dmaCfg2.srcAddrDirect = XDMA_ADDR_NO_CHANGE;
    dmaCfg2.destAddrDirect = XDMA_ADDR_INCRE;
    dmaCfg2.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_2;
    dmaCfg2.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_2;

    dmaCfg2.dmaSrcReqId = DMAMUX_ReqId_spi1_rx;

    /* Clear INT flag set in previous operation */
    /* Enable the IRQ so that we can poll the Status_Tfr flag */

    XDMA_unMaskInterrupt(DMA1_CH2_BASE, XDMA_INT_TFR);
    XDMA_clearInterrupt(DMA1_CH2_BASE, XDMA_INT_TFR);

    XDMA_configChannel(DMA1_CH2_BASE, &dmaCfg2);

}

void INTERRUPT_init(){

	 //Interrupt Setings for INT_mySPI0_RX_DMA
	Interrupt_register(INT_DMA1_CH2, &INT_mySPI0_RX_DMA_ISR);
	Interrupt_enable(INT_DMA1_CH2);

	// Interrupt Setings for INT_mySPI0_TX_DMA
	Interrupt_register(INT_DMA1_CH1, &INT_mySPI0_TX_DMA_ISR);
	Interrupt_enable(INT_DMA1_CH1);

	Interrupt_register(INT_SPIB, &spiRxFIFOISR);
	Interrupt_enable(INT_SPIB);
}





#ifdef __cplusplus
}
#endif

