/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    xdma_dsp_ex06_spi_board.h
*   @brief   
*
*/

#ifndef XDMA_DSP_EX06_SPI_BOARD_H_
#define XDMA_DSP_EX06_SPI_BOARD_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include "xbar.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define DMA_BUF_SIZE 32

extern uint16_t SPI_TXBUF[DMA_BUF_SIZE];
extern uint16_t SPI_RXBUF[DMA_BUF_SIZE];


// SPI_STE - GPIO Settings
#define GPIO_PIN_SPIA_STE 23//19
#define mySPI0_SPISTE_GPIO 23//19
#define mySPI0_SPISTE_PIN_CONFIG GPIO_23_SPISTEB //GPIO_19_SPIA_PTE

// SPI_CLK - GPIO Settings
#define GPIO_PIN_SPIA_CLK 22//18
#define mySPI0_SPICLK_GPIO 22//18
#define mySPI0_SPICLK_PIN_CONFIG GPIO_22_SPICLKB//GPIO_18_SPIA_CLK

// SPI_SIMO - GPIO Settings
#define GPIO_PIN_SPIA_SIMO 24//16
#define mySPI0_SPISIMO_GPIO 24//16
#define mySPI0_SPISIMO_PIN_CONFIG GPIO_24_SPISIMOB//GPIO_16_SPISIMOA

// SPI_SOMI - GPIO Settings
#define GPIO_PIN_SPIA_SOMI 25//17
#define mySPI0_SPISOMI_GPIO 25//17
#define mySPI0_SPISOMI_PIN_CONFIG GPIO_25_SPISOMIB//GPIO_17_SPISOMIA

//SPIA
#define mySPI_BASE SPIB_BASE//SPIA_BASE

#define mySPI_BITRATE 1000000
#define mySPI_DATAWIDTH 16



/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

void board_init();
void PinMux_init();
void Spi_init();
void dma_spi_tx();
void dma_spi_rx();
void INTERRUPT_init();
void spiRxFIFOISR();
void INT_mySPI0_TX_DMA_ISR();
void INT_mySPI0_RX_DMA_ISR();


#ifdef __cplusplus
}
#endif


#endif /* XDMA_DSP_EX03_EPWM_PUTY_CHANGE_BOARD_H_ */
