/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    ecap_ex01_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "ecap_ex01_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

// Board Configurations
void Board_init(void)
{
    PinMux_init();

	OUTPUTXBAR_init();

	ECAP_init();
}

// PinMux Configurations
void PinMux_init(void)
{
    // PinMux for modules assigned to CPU
	GPIO_setPinConfig(GPIO_5_OUTPUTXBAR3);
}

// ECAP Configurations
void ECAP_init(){
    myECAP0_init();
}

// ECAP Configurations for ECAP1
void myECAP0_init(){
    // Stops Time stamp counter.
	
	ECAP_stopCounter(myECAP0_BASE);
    
	// Sets eCAP in APWM mode.
	
	ECAP_enableAPWMMode(myECAP0_BASE);
	
	// Set eCAP APWM period.
	//ECAP_setAPWMPeriod(myECAP0_BASE,4000000U);
	ECAP_setAPWMPeriod(myECAP0_BASE,4000000U);
	
	// Set eCAP APWM on or off time count.
	//ECAP_setAPWMCompare(myECAP0_BASE,1000000U);
	ECAP_setAPWMCompare(myECAP0_BASE,0000000U);
	
	// Set eCAP APWM polarity.
	
	ECAP_setAPWMPolarity(myECAP0_BASE,ECAP_APWM_ACTIVE_HIGH);
	
	// Sets a phase shift value count.
	
	ECAP_setPhaseShiftCount(myECAP0_BASE,0U);
	
	// Disable counter loading with phase shift value.
	
	ECAP_disableLoadCounter(myECAP0_BASE);
	
	// Configures Sync out signal mode.
	
	ECAP_setSyncOutMode(myECAP0_BASE,ECAP_SYNC_OUT_SYNCI);
	
	// Configures emulation mode.
	
	ECAP_setEmulationMode(myECAP0_BASE,ECAP_EMULATION_STOP);
	
	// Set up the source for sync-in pulse..
	
//	SysCtl_setECAPSyncInPulseSource(myECAP0_SYNC_IN_OFFSET,ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT1);
	
	// Starts Time stamp counter for myECAP0.
	
	ECAP_startCounter(myECAP0_BASE);
}

// OUTPUTXBAR Configurations
void OUTPUTXBAR_init(){
    myOUTPUTXBAR0_init();
}

// OUTPUTXBAR Configurations for ECAP1
void myOUTPUTXBAR0_init(){
	//
	//Mux configuration
	//
	XBAR_enableOutputMux(myOUTPUTXBAR0_BASE,myOUTPUTXBAR0, XBAR_MUX00);
	XBAR_setOutputMuxConfig(myOUTPUTXBAR0_BASE,myOUTPUTXBAR0, XBAR_OUT_MUX00_ECAP1_OUT);
	XBAR_invertOutputSignal(myOUTPUTXBAR0_BASE,myOUTPUTXBAR0, false);
	XBAR_setOutputLatchMode(myOUTPUTXBAR0_BASE,myOUTPUTXBAR0, false);

}

/**
 * \brief   "add brief description of this function" 
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif
