/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    ecap_ex08_board.h
*   @brief   
*
*/

#ifndef ECAP_EX08_BOARD_H_
#define ECAP_EX08_BOARD_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "driverlib.h"
#include "device.h"
#include "regs/regs_ecap.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define myECAP1_BASE    ECAP1_BASE
#define myECAP2_BASE    ECAP2_BASE
#define myECAP3_BASE    ECAP3_BASE
#define myECAP4_BASE    ECAP4_BASE
#define myECAP5_BASE    ECAP5_BASE
#define myECAP6_BASE    ECAP6_BASE

#define myEPWM1_BASE    EPWM1_BASE
#define myEPWM2_BASE    EPWM2_BASE
#define myEPWM3_BASE    EPWM3_BASE

#define myINPUTXBAR1_GPIO_SOURCE 0
#define myINPUTXBAR2_GPIO_SOURCE 1
#define myINPUTXBAR3_GPIO_SOURCE 2
#define myINPUTXBAR4_GPIO_SOURCE 3
#define myINPUTXBAR5_GPIO_SOURCE 4
#define myINPUTXBAR6_GPIO_SOURCE 5

#define myINPUTXBAR_INPUT1 XBAR_INPUT1
#define myINPUTXBAR_INPUT2 XBAR_INPUT2
#define myINPUTXBAR_INPUT3 XBAR_INPUT3
#define myINPUTXBAR_INPUT4 XBAR_INPUT4
#define myINPUTXBAR_INPUT5 XBAR_INPUT5
#define myINPUTXBAR_INPUT6 XBAR_INPUT6

#define myGPIO_EPWM1_A  GPIO_0_EPWM1_A
#define myGPIO_EPWM1_B  GPIO_1_EPWM1_B
#define myGPIO_EPWM2_A  GPIO_2_EPWM2_A
#define myGPIO_EPWM2_B  GPIO_3_EPWM2_B
#define myGPIO_EPWM3_A  GPIO_4_EPWM3_A
#define myGPIO_EPWM3_B  GPIO_5_EPWM3_B


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/**
 * \brief   "Board Configurations
 *          Initializes the rest of the modules. 
 *          Call this function in your application if you wish to do all module initialization. 
 *          If you wish to not use some of the initializations, instead of the
 *          Board_init use the individual Module_inits" 
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void Board_init(void);

/**
 * \brief   "ECAP Configurations for ECAP1~6"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void myECAP0_init(void);

/**
 * \brief   "ECAP Configurations"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void ECAP_init(void);

/**
 * \brief   "GPIO Configurations for ECAP1"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void myGPIO0_init(void);

/**
 * \brief   "GPIO Configurations"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void GPIO_init(void);

/**
 * \brief   "INPUTXBAR Configurations for ECAP1"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void myINPUTXBARINPUT0_init(void);

/**
 * \brief   "INPUTXBAR Configurations"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void INPUTXBAR_init(void);

/**
 * \brief   "INTERRUPT Configurations"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
void INTERRUPT_init(void);

/**
 * \brief   "add brief description of this function" 
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

/**
 * \brief   "Interrupt handling function for epwm"
 *
 * \param   void   no parameters
 *
 * \retval  None
 */
extern void Ecap_ex08_IrqHandler1(void);
extern void Ecap_ex08_IrqHandler2(void);
extern void Ecap_ex08_IrqHandler3(void);

#ifdef __cplusplus
}
#endif


#endif /* ECAP_EX08_BOARD_H_ */
