/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file     share.c
*   @brief
*
*/

#include <string.h>

#include "device.h"
#include "log.h"

/*init value below is invalid, because it is in shared data section and will be init by cpu1. init it in cpu1 project. */
__SHARED__ volatile uint32_t sharedData = 0xAA55;

/*init value below is invalid, because it is in shared bss section and will be cleaned by cpu1 */
__SHARED_BSS__ volatile uint32_t sharedBss = 0xAAAA;

/*init value below is invalid, because it is in cpu1tocpu2 data section and will be init by cpu1. init it in cpu1 project. */
__CPU1TOCPU2__ volatile uint32_t cpu1tocpu2Data1 = 21;
__CPU1TOCPU2__ volatile uint32_t cpu1tocpu2Data2 = 21;

/*init value below is invalid, because it is in cpu1tocpu2 bss section and will be cleaned by cpu1 */
__CPU1TOCPU2_BSS__ volatile uint32_t cpu1tocpu2Bss = 21;

/*init value below is valid*/
__CPU2TOCPU1__ volatile uint32_t cpu2tocpu1Data1 = 21;
__CPU2TOCPU1__ volatile uint32_t cpu2tocpu1Data2;       /* 0 */

/*init value below is invalid, because it is in cpu2tocpu1 bss section and will be cleaned by cpu2 */
__CPU2TOCPU1_BSS__ volatile uint32_t cpu2tocpu1Bss = 21;


extern char __shared_cpu2tocpu1_bss_start__[];
extern char __shared_cpu2tocpu1_bss_end__[];

void Shared_bss_clean(void)
{
    int len = (uint32_t)&__shared_cpu2tocpu1_bss_end__ - (uint32_t)&__shared_cpu2tocpu1_bss_start__;

    if (len > 0) {
        memset(&__shared_cpu2tocpu1_bss_start__, 0, len);
    }
}

void Shared_show(void)
{
    log_info("sharedData: %X, sharedBss: %d, cpu1Data1: %d, cpu1Data2: %d, cpu1Bss: %d, cpu2Data1: %d, cpu2Data2: %d, cpu2Bss: %d\r\n",
                                sharedData, sharedBss, cpu1tocpu2Data1, cpu1tocpu2Data2, cpu1tocpu2Bss, cpu2tocpu1Data1, cpu2tocpu1Data2, cpu2tocpu1Bss);
}
