/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "device.h"
#include "eeprom_state.h"

uint8_t sdata[PAGE_MAX_NUM*PAGE_SIZE] = {0x10,0x20,0x30,0x40};
uint8_t rdata[PAGE_MAX_NUM*PAGE_SIZE] = {0x00};

int main(void)
{
    Device_init();
    int ret = 0,i;

    for(i=0;i<PAGE_MAX_NUM*PAGE_SIZE;i++){
    	sdata[i] = i;
    	rdata[i] = 0;
    }

	EINT;
	ERTM;

	i2c_init();

	do{
		ret = eeprom_write(0x30,sdata,9);
	}while(ret == 1);

	if(ret == -1)
		while(1);
	else if(ret == 2)
		while(1);

	do{
		ret = eeprom_write(0x00,sdata,20);
	}while(ret == 1);

	if(ret == -1)
		while(1);
	else if(ret == 2)
		while(1);

	do{
		ret = eeprom_read(0x00,rdata,40);
	}while(ret == 1);

	if(ret == -1)
		while(1);
	else if(ret == 2)
		while(1);

	do{
		ret = eeprom_read(0x40,rdata,20);
	}while(ret == 1);

	if(ret == -1)
		while(1);
	else if(ret == 2)
		while(1);

    while (1){

    }

    return 0;
}

