/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "aci_const.h"
#include "math.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/*
 * @brief		Calculate the ACI motor output constants
 */
void ACI_Const_calc(ACI_Const *v) {
    float sigma, gamma, alpha, beta;

    sigma = 1 - (v->Lm * v->Lm) / (v->Ls * v->Lr);
    gamma = (v->Lm * v->Lm * v->Rr + v->Lr * v->Lr * v->Rs) / (sigma * v->Ls * v->Lr * v->Lr);
    alpha = v->Rr / v->Lr;
    beta = v->Lm / (sigma * v->Ls * v->Lr);

    v->K1 = v->Ts * alpha;
    v->K2 = v->Ts * v->Wb;
    v->K3 = v->Ts * alpha * v->Lm * (v->Ib / v->Lb);
    v->K4 = v->Ts * alpha * beta * (v->Lb / v->Ib);
    v->K5 = v->Ts * beta * (v->Lb * v->Wb / v->Ib);
    v->K6 = v->Ts * gamma;
    v->K7 = v->Ts * (1 / (sigma * v->Ls)) * (v->Vb / v->Ib);
    v->K8 = 1.5f * (v->p / 2) * (v->Lm / v->Lr) * (v->Lb * v->Ib / v->Tb);
    v->K9 = v->Ts * (v->B / v->J);
    v->K10 = v->Ts * (v->p / 2) * (1 / v->J) * (v->Tb / v->Wb);
}

#ifdef __cplusplus
}
#endif
