/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 *   @file     aci_main.h
 *   @brief
 *
 */

#ifndef _ACI_MAIN_H
#define _ACI_MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "aci.h"          // Include header for the ACI object
#include "aci_const.h"    // Include header for the ACI_CONST object
#include "aci_fe.h"       // Include header for the ACIFE object
#include "aci_fe_const.h" // Include header for the ACIFE_Const object
#include "aci_se.h"       // Include header for the ACISE object
#include "aci_se_const.h" // Include header for the ACISE_Const object
#include "clarke.h"       // Include header for the CLARKE object
#include "iclarke.h"      // Include header for the ICLARKE object
#include "ipark.h"        // Include header for the IPARK object
#include "park.h"         // Include header for the PARK object
#include "pid_reg3.h"     // Include header for the PIDREG3 object
#include "svgen.h"        // Include header for the SVGEN object
#include "db_comp.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
//
// DSP can only access ILM.
// Reducing the number of log samples saved to be able to fit application
// in dsp accessible memory.
//
#define DLOG_NUMBER_SAMPLES (1 << 9)
#define DLOG_NUMBER_MASK (DLOG_NUMBER_SAMPLES - 1)

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

#ifdef __cplusplus
}
#endif

#endif /* _ACI_MAIN_H */
