/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 *   @file     aci_se_const.h
 *   @brief
 *
 */

#ifndef _ACI_SE_CONT_H
#define _ACI_SE_CONST_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "parameter.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
/*
 * @brief		 Default initializer for the ACISE_CONST object
 *				 These ACI parameters are based on WEG 1-hp induction motor
 */
#define ACISE_CONST_DEFAULTS           \
    { RR_VALUE, LR_VALUE,              \
      BASE_FREQ, 200, SAMPLING_PERIOD, \
      0, 0, 0, 0, }

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
/*
 * @brief		  Data structure for maintaining Speed estimator parameters
 */
typedef struct {
    float Rr; // Input: Rotor resistance (ohm)
    float Lr; // Input: Rotor inductance (H)
    float fb; // Input: Base electrical frequency (Hz)
    float fc; // Input: Cut-off frequency of lowpass filter (Hz)
    float Ts; // Input: Sampling period in sec
    float K1; // Output: constant using in rotor flux calculation
    float K2; // Output: constant using in rotor flux calculation
    float K3; // Output: constant using in rotor flux calculation
    float K4; // Output: constant using in stator current calculation
} ACISE_Const;

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */
/*
 * @brief		  Function prototypes
 */
void ACISE_Const_calc(ACISE_Const *);

#ifdef __cplusplus
}
#endif

#endif /* _ACI_SE_CONT_H */
