/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "driverlib.h"
#include "profile.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
/*
 * @brief		Timer 0 registers used for benchmarking application
 */
#define CPU_TIMER0_TIM_REG (CPUTIMER0_BASE + CPUTIMER_O_TIMERXVALUE)
// #define CPU_TIMER0_PRD_REG (CPUTIMER0_BASE + CPUTIMER_O_PRD)
// #define CPU_TIMER0_TCR_REG (CPUTIMER0_BASE + CPUTIMER_O_TCR)
// #define CPU_TIMER0_TPR_REG (CPUTIMER0_BASE + CPUTIMER_O_TPR)
// #define CPU_TIMER0_TPRH_REG (CPUTIMER0_BASE + CPUTIMER_O_TPRH)

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
//
// For consistent results, force the application benchmark
// functions to never be inlined
//

/*
 * @brief		Calibrate application benchmark to determine offset
 */
#pragma GCC optimize("no-inline")
void Bmrk_calibrate(void) {
    Bmrk_start();
    Bmrk_end();
    Bmrk_Adjust = (Bmrk_End - Bmrk_Start);
}

/*
 * @brief		 Save application benchmark start count
 */
#pragma GCC optimize("no-inline")
void Bmrk_start(void) {
	Bmrk_Start = CPU_getCycleCnt();
}

/*
 * @brief		Save application benchmark end count
 */
#pragma GCC optimize("no-inline")
void Bmrk_end(void) {
	Bmrk_End = CPU_getCycleCnt();
}

/*
 * @brief		Save benchmark count for marking the end
 */
void IOBmrk_end(void) {
    // Read PWM Counter
    //uint16_t *counter = (uint16_t *)(uintptr_t)(EPWM1_BASE + EPWM_O_TBCTR);
    IOBmrk_End = EPWM_getTimeBaseCounterValue(EPWM1_BASE);
}

#ifdef __cplusplus
}
#endif
