/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "driverlib.h"
#include "profile.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
//
// Timer 0 registers used for benchmarking application
//
// #define CPU_TIMER0_TIM_REG (CPUTIMER0_BASE + CPUTIMER_O_TIM)
// #define CPU_TIMER0_PRD_REG (CPUTIMER0_BASE + CPUTIMER_O_PRD)
// #define CPU_TIMER0_TCR_REG (CPUTIMER0_BASE + CPUTIMER_O_TCR)
// #define CPU_TIMER0_TPR_REG (CPUTIMER0_BASE + CPUTIMER_O_TPR)
// #define CPU_TIMER0_TPRH_REG (CPUTIMER0_BASE + CPUTIMER_O_TPRH)

// #define CPU_TIMER0_TIM_REG (CPUTIMER0_BASE + CPUTIMER_O_TIMERXVALUE)
// #define CPU_TIMER0_PRD_REG (CPUTIMER0_BASE + CPUTIMER_O_TIMERXLOAD)
// #define CPU_TIMER0_TCR_REG (CPUTIMER0_BASE + CPUTIMER_O_TIMERXCONTROL)
// #define CPU_TIMER0_TPR_REG (CPUTIMER0_BASE + CPUTIMER_O_TPR)
// #define CPU_TIMER0_TPRH_REG (CPUTIMER0_BASE + CPUTIMER_O_TPRH)

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/*
 * @brief		  Initialize the resources for application benchmarking
 */
void Bmrk_init(void) {
	/* CPU internal mcycle counter is used for benchmark calculation */
#if 0
    //
    // CPU Timer 0
    //
    //    unsigned long *period = (unsigned long *)CPU_TIMER0_PRD_REG;
    //    unsigned long *tpr = (unsigned long *)CPU_TIMER0_TPR_REG;
    //    unsigned long *tprh = (unsigned long *)CPU_TIMER0_TPRH_REG;
    //    unsigned long *tcr = (unsigned long *)CPU_TIMER0_TCR_REG;
    CPUTimer_stopTimer(CPUTIMER0_BASE);
    CPUTimer_setTimerSize(CPUTIMER0_BASE, CPUTIMER_TIMERSIZE_32BIT);
    //
    // Initialize timer period to maximum
    //
    //    *period = 0xFFFFFFFF;
    CPUTimer_setPeriod(CPUTIMER0_BASE, 0xFFFFFFFF);
    //
    // Initialize pre-scale counter to divide by 1 (SYSCLKOUT)
    //
    //    *tpr = 0;
    //    *tprh = 0;
    //    CPUTimer_setPreScaler(CPUTIMER0_BASE, 0);
    //
    // Make sure timer is stopped (TSS bit 4 = 1)
    //
    //    *tcr |= 0x0010;
    CPUTimer_stopTimer(CPUTIMER0_BASE);

    //
    // set emulation mode
    //
    CPUTimer_setEmulationMode(CPUTIMER0_BASE, CPUTIMER_EMULATIONMODE_STOPAFTERNEXTDECREMENT);
    //
    // Reload all counter register with period value (TRB bit 5 = 1)
    //
    //    *tcr |= 0x0020;
    CPUTimer_reloadTimerCounter(CPUTIMER0_BASE);

    //
    // Start timer (TSS bit 4 = 0)
    //
    //    *tcr &= 0xFFEF;
    CPUTimer_resumeTimer(CPUTIMER0_BASE);
#endif

    // Initialize the data structures
    unsigned int i = 0;
    for (i = 0; i < BMRK_INSTANCES; i++) {
        Bmrk_Sum[i] = 0;
        Bmrk_Max[i] = 0;
        Bmrk_Min[i] = 0xFFFFFFFF;
        Bmrk_Count[i] = 0;
    }
}

/*
 * @brief		  Initialize resources for IO response benchmarking
 */
void IOBmrk_init(void) {

    // Initialize the data structures
    IOBmrk_End = 0;
    IOBmrk_Cyc = 0;
    IOBmrk_Sum = 0;
    IOBmrk_Max = 0;
    IOBmrk_Min = 0xFFFFFFFF;
    IOBmrk_Count = 0;
}

#ifdef __cplusplus
}
#endif
