/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 *   @file     profile_print.h
 *   @brief
 *
 */

#ifndef _PROFILE_PRINT_H
#define _PROFILE_PRINT_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "profile.h"
#include "stdint.h"
#include "string.h"
#include "log.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define PRINT_HEADER   "                                      %8s %8s %8s\r\n"
#define PRINT_ST_0     "INT Response (trigger to ISR entry) : %8lu %8lu %8lu\r\n"
#define PRINT_ST_1     "Read 2 ADC, convert float           : %8lu %8lu %8lu\r\n"
#define PRINT_ST_2     "Clarke Transform                    : %8lu %8lu %8lu\r\n"
#define PRINT_ST_3     "3 PID Controller Transforms         : %8lu %8lu %8lu\r\n"
#define PRINT_ST_4     "Inverse Park Transform              : %8lu %8lu %8lu\r\n"
#define PRINT_ST_5     "ACI Motor Modeling                  : %8lu %8lu %8lu\r\n"
#define PRINT_ST_6     "Flux Estimator                      : %8lu %8lu %8lu\r\n"
#define PRINT_ST_7     "Speed Estimator                     : %8lu %8lu %8lu\r\n"
#define PRINT_ST_8     "Park Transform                      : %8lu %8lu %8lu\r\n"
#define PRINT_ST_9     "SVGen Transform                     : %8lu %8lu %8lu\r\n"
#define PRINT_ST_10    "Dead Band Compensation              : %8lu %8lu %8lu\r\n"
#define PRINT_ST_11    "Write 3 PWM                         : %8lu %8lu %8lu\r\n"
#define PRINT_ST_TOTAL "Total                               : %8lu %8lu %8lu\r\n"
#define PRINT_ST_LINE  "----------------------------------------------------------------\r\n"

#define PRINT_US_0     "\r\n INT Response (trigger to ISR entry) : %6.1f %6.1f %6.1f"
#define PRINT_US_1     "\r\n Read 2 ADC, convert float           : %6.1f %6.1f %6.1f"
#define PRINT_US_2     "\r\n Clarke Transform                    : %6.1f %6.1f %6.1f"
#define PRINT_US_3     "\r\n 3 PID Controller Transforms         : %6.1f %6.1f %6.1f"
#define PRINT_US_4     "\r\n Inverse Park Transform              : %6.1f %6.1f %6.1f"
#define PRINT_US_5     "\r\n ACI Motor Modeling                  : %6.1f %6.1f %6.1f"
#define PRINT_US_6     "\r\n Flux Estimator                      : %6.1f %6.1f %6.1f"
#define PRINT_US_7     "\r\n Speed Estimator                     : %6.1f %6.1f %6.1f"
#define PRINT_US_8     "\r\n Park Transform                      : %6.1f %6.1f %6.1f"
#define PRINT_US_9     "\r\n SVGen Transform                     : %6.1f %6.1f %6.1f"
#define PRINT_US_10    "\r\n Dead Band Compensation              : %6.1f %6.1f %6.1f"
#define PRINT_US_11    "\r\n Write 3 PWM                         : %6.1f %6.1f %6.1f"
#define PRINT_US_TOTAL "\r\n Total                               : %6.1f %6.1f %6.1f"

#define IOBmrk_print() log_debug(PRINT_ST_0, (int)((((float)IOBmrk_Sum) / ((float)IOBmrk_Count))), (int)IOBmrk_Max, (int)IOBmrk_Min);
#define Bmrk_print(n) log_debug(PRINT_ST_##n, (int)(((float)Bmrk_Sum[n - 1]) / ((float)Bmrk_Count[n - 1])), (int)Bmrk_Max[n - 1], (int)Bmrk_Min[n - 1]);

#define IOBmrk_print_us() printf(PRINT_US_0, ((((float)IOBmrk_Sum) / ((float)IOBmrk_Count))) / 20.0f, (float)IOBmrk_Max / 20.0f, (float)IOBmrk_Min / 20.0f);
#define Bmrk_print_us(n) printf(PRINT_US_##n, (((float)Bmrk_Sum[n - 1]) / ((float)Bmrk_Count[n - 1])) / 20.0f, (float)Bmrk_Max[n - 1] / 20.0f, (float)Bmrk_Min[n - 1] / 20.0f);

#define Bmrk_print_total()                                                   \
    do {                                                                     \
        log_debug(PRINT_ST_LINE);                                               \
        log_debug(PRINT_ST_TOTAL, Bmrk_TotalAvg, Bmrk_TotalMax, Bmrk_TotalMin); \
        log_debug(PRINT_ST_LINE);                                               \
    } while (0)

#define Bmrk_print_total_us()                                                                                          \
    do {                                                                                                               \
        printf(PRINT_ST_LINE);                                                                                         \
        printf(PRINT_US_TOTAL, (float)Bmrk_TotalAvg / 20.0, (float)Bmrk_TotalMax / 20.0, (float)Bmrk_TotalMin / 20.0); \
        printf(PRINT_ST_LINE);                                                                                         \
    } while (0)

#define Bmrk_add_IO()                                                    \
    do {                                                                 \
        Bmrk_TotalAvg += (int)((float)IOBmrk_Sum / (float)IOBmrk_Count); \
        Bmrk_TotalMax += IOBmrk_Max;                                     \
        Bmrk_TotalMin += IOBmrk_Min;                                     \
    } while (0)

#define Bmrk_add(n)                                                                \
    do {                                                                           \
        Bmrk_TotalAvg += (int)((float)Bmrk_Sum[n - 1] / (float)Bmrk_Count[n - 1]); \
        Bmrk_TotalMax += Bmrk_Max[n - 1];                                          \
        Bmrk_TotalMin += Bmrk_Min[n - 1];                                          \
    } while (0)

#define Bmrk_printHeader()                         \
    do {                                           \
        log_debug(PRINT_ST_LINE);                     \
        log_debug(PRINT_HEADER, "AVG", "MAX", "MIN"); \
    } while (0)

#define Bmrk_printHeader_us()                               \
    do {                                                    \
        printf(PRINT_ST_LINE);                              \
        printf(PRINT_HEADER, "AVG us", "MAX us", "MIN us"); \
    } while (0)

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

#ifdef __cplusplus
}
#endif

#endif /* ABC_DQ0_POS_F_H_ */
