#
#@brief FDP command tyeps.
#
#
#The host sends image update request frame to device.
FDP_CMD_START			= 0xDA
#The host sends vender ID verification frame to device.
FDP_CMD_VENDER_CHECK	= 0xDB
#The host sends a request to obtain
#the maximum frame length of the device to the device.
FDP_CMD_FRAME_SIZE		= 0xDC
#The host sends Image size to device.
FDP_CMD_FILE_SIZE		= 0xDD
#The host sends the address of the image to be written to the device.
FDP_CMD_GET_ADDRESS		= 0xD5
#The host sends the initialization memory command to the device.
FDP_CMD_INIT_MEM		= 0xD7
#The host sends transmission data request
#frame to device.
FDP_CMD_TRANSFER_REQ	= 0xDE
#The host sends an image transmission completion
#request frame to the device.
FDP_CMD_TRANSFER_END	= 0xDF
#The host sends an image verification frame to device.
FDP_CMD_TRANSFER_CHECK	= 0xBE
# Check if the image is correct.
FDP_CMD_CHECK_IMAGE		= 0xBF
# Check if nessary to release core.
FDP_CMD_RELEASE_CORE	= 0xC0

#If the host and device communication is successfully,
#the host or device will sends a successful ACK.
FDP_CMD_ACK_SUCCESS		= 0xEA
#If communication between the host and device fails,
#the host or device will send a failed ACK
FDP_CMD_ACK_ERROR		= 0xEB

#
#@brief FDP frame direction.
#
#
# Message initiated by the host.
FDP_HOST				= 0x5A
# Message initiated by the device.
FDP_DEVICE				= 0xB5

# Wait for update image. */
FDP_BOOT_FLOW_WAIT_FOR_UPTATE		= 0
# Start update image. */
FDP_BOOT_FLOW_UPDATE				= 1
# Check if the vender is correct. */
FDP_BOOT_FLOW_CHECK_VENDER			= 2
# The host requests the maximum frame length to be sent from the device. */
FDP_BOOT_FLOW_SEND_MAX_FRAME_SIZE	= 3
# The host sends the size of the image to be written to the device. */
FDP_BOOT_FLOW_GET_IMAGE_SIZE		= 4
# The host sends the address of the image to be written to the device. */
FDP_BOOT_FLOW_GET_STORAGE_ADDR		= 5
# The host sends the initialization memory command to the device. */
FDP_BOOT_FLOW_INIT_MEM				= 6
# The host sends transmission data request frame to device. */
FDP_BOOT_FLOW_GET_IMAGE_DATA		= 7
# The host sends an image transmission completion request frame to the device. */
FDP_BOOT_FLOW_CHECK_TRANSFER		= 8
# The image received. */
FDP_BOOT_FLOW_DOWNLOAD_END			= 9
# The host sends an end of image transfer frame to device. */
FDP_BOOT_FLOW_UPDATE_END			= 10
# Check if the image is correct. */
FDP_BOOT_FLOW_CHECK_IMAGE			= 11
# Check if release core
FDP_BOOT_FLOW_RELEASE_CORE			= 12

#
#@brief The length of commands frame.
#
FDP_CMD_START_LENGTH				= 4
FDP_CMD_VENDER_CHECK_LENGTH			= 8
FDP_CMD_FRAME_SIZE_LENGTH			= 8
FDP_CMD_FILE_SIZE_LENGTH			= 8
FDP_CMD_STORAGE_ADDR_LENGTH			= 8
FDP_CMD_INIT_MEMORY_LENGTH			= 8
FDP_CMD_TRANSFER_REQ_LENGTH			= 8
FDP_CMD_TRANSFER_END_LENGTH			= 4
FDP_CMD_TRANSFER_CHECK_LENGTH		= 8
FDP_CMD_CHECK_IMAGE_LENGTH			= 8
FDP_CMD_MAX_OF_LENGTH				= 8
FDP_CMD_RELEASE_CORE_LENGTH			= 8
FDP_CMD_ACK_LENGTH					= 4
FDP_CMD_MAX_LENGTH					= 8

FDP_ACK_SUCCESS_FRAME				= [FDP_CMD_ACK_SUCCESS, FDP_DEVICE, 0x67, 0x8F]
FDP_ACK_FAIL_FRAME					= [FDP_CMD_ACK_ERROR, FDP_DEVICE, 0xF7, 0x8E]
