/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    board_cfg.h
*   @brief   board level configurations
*
*/

#ifndef __BOARD_CFG_H__
#define __BOARD_CFG_H__

#ifdef __cplusplus
extern "C"{
#endif


/**
  * @brief Configuration of the CRG
  */
/* ʹⲿپ */
#define __HSE_ENABLE                0      /*!< hse_enable                           */

/* ⲿ: 0 Դ, 1 Դ, 2 Զ(ⲿѭ, ʺϳڲ) */
#define __HSE_CLOCK_TYPE            0

/* 趨PLLʱԴƵ: 10MHz IRC10MHz/20MHzⲿ */
#if __HSE_ENABLE == 0
#define DEVICE_OSCSRC_FREQ          (10*1000*1000)
#else
#define DEVICE_OSCSRC_FREQ          (20*1000*1000)
#endif

/* ϵͳʱ 200MHz300MHz400MHz */
#define DEVICE_SYSCLK_FREQ          (120*1000*1000U)
/* ϵͳʱӷƵ 1,2,4,8 */
#define DEVICE_SYSCLK_DIV           (2)
/* PLLʱ 120MHz ~ 800MHz */
#define DEVICE_PLLCLK_FREQ          (DEVICE_SYSCLK_FREQ * DEVICE_SYSCLK_DIV)
/* AHBʱӷƵ 1,2,4 */
#define DEVICE_AHBCLK_DIV           (2)
/* AHBʱƵ MHz */
#define DEVICE_AHBCLK_FREQ          (DEVICE_SYSCLK_FREQ/DEVICE_AHBCLK_DIV)      // <= 100MHz
/* APBʱӷƵ 1,2,4,8 */
#define DEVICE_APBCLK_DIV           (2)
/* APBʱƵ MHz */
#define DEVICE_APBCLK_FREQ          (DEVICE_SYSCLK_FREQ/DEVICE_APBCLK_DIV)      // <= 100MHz
/* ʱʱƵʵAPBʱƵ */
#define SOC_TIMER_FREQ              (DEVICE_APBCLK_FREQ)

/* Board Pin Configuration */
#define SCIA_TX_PIN                 GPIO_29_SCIA_TX
#define SCIA_RX_PIN                 GPIO_28_SCIA_RX

#if (GS32_PART_NUM==0x0025 || GS32_PART_NUM==0x0039A)
#define SCIB_TX_PIN                     GPIO_40_SCIB_TX
#define SCIB_RX_PIN                     GPIO_15_SCIB_RX
#elif (GS32_PART_NUM==0x0049A)
#define SCIB_TX_PIN                     GPIO_10_SCIB_TX		//GPIO_14_SCIB_TX 0039̬gpio14ռ
#define SCIB_RX_PIN                     GPIO_11_SCIB_RX
#endif
#define LOG_SCI_BASE                SCIB_BASE

#if (GS32_PART_NUM==0x0025 || GS32_PART_NUM==0x0039A)
#define LOG_TX_PIN_NUM					(40U)
#define LOG_RX_PIN_NUM					(15U)
#elif (GS32_PART_NUM==0x0049A)
#define LOG_TX_PIN_NUM					(10U)
#define LOG_RX_PIN_NUM					(11U)
#endif
#define GPIO_CFG_LED1               GPIO_31_GPIO31
#define GPIO_CFG_LED2               GPIO_34_GPIO34

#ifdef __cplusplus
}
#endif

#endif  /* __BOARD_CFG_H__ */
