/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "boot_hw_type.h"
#include "boot_app_info.h"
#include "boot_hw_type.h"
#include "boot_low_level_init.h"
#include "boot_delay.h"
#include "boot_clock.h"
#include "boot_jump.h"
#include "board_cfg.h"

BOOT_TEXT int __boot_main(void)
{
	boot_app_info_t *boot_app0_info = (boot_app_info_t *)0x8004000;
	boot_app_info_t *boot_app1_info = (boot_app_info_t *)0x8044000;;
	uint32_t address = 0;

	boot_low_level_init(DEVICE_AHBCLK_FREQ);

	boot_sysctl_clock_init(DEVICE_PLLCLK_FREQ, DEVICE_OSCSRC_FREQ,
						DEVICE_SYSCLK_DIV, DEVICE_AHBCLK_DIV, DEVICE_APBCLK_DIV,
						__HSE_ENABLE, __HSE_CLOCK_TYPE);

	boot_delay_init(DEVICE_SYSCLK_FREQ);

	if (boot_app0_info->eigenvalue == BOOT_APP_INFO_EIGENVALUE &&
		boot_app1_info->eigenvalue == BOOT_APP_INFO_EIGENVALUE) {

		if (boot_app0_info->version != 0xffffffff && boot_app1_info->version != 0xffffffff) {
			if (boot_app0_info->version >= boot_app1_info->version)
				address = boot_app0_info->start_addr;
			else
				address = boot_app1_info->start_addr;
		} else if (boot_app0_info->version != 0xffffffff && boot_app1_info->version == 0xffffffff) {
			address = boot_app0_info->start_addr;
		} else if (boot_app0_info->version == 0xffffffff && boot_app1_info->version != 0xffffffff) {
			address = boot_app1_info->start_addr;
		}
	} else if (boot_app0_info->eigenvalue == BOOT_APP_INFO_EIGENVALUE &&
			boot_app1_info->eigenvalue != BOOT_APP_INFO_EIGENVALUE) {

		if (boot_app0_info->version != 0xffffffff)
			address = boot_app0_info->start_addr;
	} else if (boot_app0_info->eigenvalue != BOOT_APP_INFO_EIGENVALUE &&
			boot_app1_info->eigenvalue == BOOT_APP_INFO_EIGENVALUE) {

		if (boot_app1_info->version != 0xffffffff)
			address = boot_app1_info->start_addr;
	}

	if (address != 0)
		boot_jump_address(address);

	while (1);

	return 0;
}

