/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "device.h"
#include "board_cfg.h"
#include "fdp_rt/fdp_rt.h"
#include "fdp_rt/fdp_rt_uart_v3_0.h"

#define FDP_RT_BUF_SIZE			128

BOOT_BSS fdp_rt_ops_t fdp_rt_ops;
BOOT_BSS fdp_rt_clk_priv_t fdp_rt_clk_priv;
BOOT_BSS fdp_rt_uart_dev_priv_t fdp_rt_uart_priv;
BOOT_BSS uint8_t fdp_rt_rxbuf[FDP_RT_BUF_SIZE];
BOOT_BSS uint8_t fdp_rt_cache_buf[FDP_RT_BUF_SIZE];
BOOT_BSS uint8_t fdp_rt_txbuf[FDP_RT_BUF_SIZE];

BOOT_TEXT void boot_uart_irq_handler(void)
{
	uint32_t status;

	status = boot_uart_get_interrupt_status(
		((fdp_rt_uart_dev_priv_t *)fdp_rt_ops.dev_private_data)->base);

	if (status & BOOT_UART_INT_RXFF) {
		fdp_rt_read(&fdp_rt_ops);
		boot_uart_clear_interrupt_status(
				((fdp_rt_uart_dev_priv_t *)fdp_rt_ops.dev_private_data)->base,
				BOOT_UART_INT_RXFF);
	}
}

int main(void)
{
	fdp_rt_uart_priv.base = SCIA_BASE;
	fdp_rt_uart_priv.bitrate = 115200;
	fdp_rt_uart_priv.irq_number = INT_SCIA_RX;
	fdp_rt_uart_priv.rx_pinmux = GPIO_28_SCIA_RX;
	fdp_rt_uart_priv.tx_pinmux = GPIO_29_SCIA_TX;
	fdp_rt_uart_priv.rx_pin_number = 28;
	fdp_rt_uart_priv.tx_pin_number = 29;
	fdp_rt_uart_priv.irq_handler = boot_uart_irq_handler;

	fdp_rt_clk_priv.ahb_freq = DEVICE_AHBCLK_FREQ;
	fdp_rt_clk_priv.apb_freq = DEVICE_APBCLK_FREQ;
	fdp_rt_clk_priv.pll_freq = DEVICE_PLLCLK_FREQ;
	fdp_rt_clk_priv.sys_freq = DEVICE_SYSCLK_FREQ;

	fdp_rt_ops.rxbuf = fdp_rt_rxbuf;
	fdp_rt_ops.txbuf = fdp_rt_txbuf;
	fdp_rt_ops.cache_rxbuf = fdp_rt_cache_buf;
	fdp_rt_ops.txbuf_size = FDP_RT_BUF_SIZE;
	fdp_rt_ops.rxbuf_size = FDP_RT_BUF_SIZE;
	fdp_rt_ops.dev_id = FDP_RT_DEV_UART_V3;
	fdp_rt_ops.clk_private_data = (void *)&fdp_rt_clk_priv;
	fdp_rt_ops.dev_private_data = (void *)&fdp_rt_uart_priv;

	Device_init();

	while (fdp_rt_init(&fdp_rt_ops) != FDP_RT_SUCCESS);

	__enable_irq();

	while (1) {
		fdp_rt_schedule(&fdp_rt_ops);
	}

	return 0;
}

