#include <stdint.h>
#include <string.h>

#include "device.h"

#include "spi_dev.h"

#include "msg_memory.h"

#define SPI_BASE	SPIB_BASE

#define GPIO_SPI_CS 23
#define CS_HIGH		    GPIO_writePin(GPIO_SPI_CS,1);
#define CS_LOW		    GPIO_writePin(GPIO_SPI_CS,0);

#define GPIO_SPI_FLAG 7

void PinMux_init(void)
{

	/* SPIB_STE */
//	GPIO_setPinConfig(GPIO_23_SPIB_STE);
//	GPIO_setPadConfig(23, GPIO_PIN_TYPE_STD | GPIO_PIN_TYPE_PULLUP);
//	GPIO_setQualificationMode(23, GPIO_QUAL_ASYNC);

	/* SPIB_CLK */
	GPIO_setPinConfig(GPIO_22_SPIB_CLK);
	GPIO_setPadConfig(22, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(22, GPIO_QUAL_ASYNC);

	/* SPIB_SIMO */
	GPIO_setPinConfig(GPIO_40_SPIB_SIMO);
	GPIO_setPadConfig(40, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(40, GPIO_QUAL_ASYNC);

	/* SPIB_SOMI */
	GPIO_setPinConfig(GPIO_41_SPIB_SOMI);
	GPIO_setPadConfig(41, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(41, GPIO_QUAL_ASYNC);

	/* SPIB_FLAG */
	GPIO_setPinConfig(GPIO_7_GPIO7);
	GPIO_setPadConfig(7, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(7, GPIO_QUAL_ASYNC);

}

void spi_interrupt_irq_handler(void)
{
	uint8_t buf[100];
	uint16_t i      = 0;

	uint16_t irq_status = SPI_getInterruptStatus(SPI_BASE);

	if (irq_status & SPI_RISR_RXFIR){
		while(SPI_getRxFIFOStatus(SPI_BASE)) {
			buf[i] = (uint8_t)SPI_readDataNonBlocking(SPI_BASE);
			i += 1;
		}

		for (uint8_t write_len = 0; write_len < i; write_len++)
			mem_write_buf(MEM_BUF_SPI, buf[write_len]);
	}

	SPI_clearInterruptStatus(SPI_BASE, SPI_RISR_RXFIR);

}

void spi_init(void)
{

	GPIO_enableWritePin(23);

	GPIO_setDirectionMode(7,GPIO_DIR_MODE_IN);

	GPIO_writePin(7,0);

	PinMux_init();

	CS_HIGH;

	SPI_enableLoopback(SPI_BASE);

	while(SPI_getRxFIFOStatus(SPI_BASE)){
		SPI_readDataNonBlocking(SPI_BASE);
	}

	SPI_disableModule(SPI_BASE);

	SPI_setConfig(SPI_BASE, DEVICE_SYSCLK_FREQ/4, SPI_PROT_POL1PHA1, SPI_MODE_CONTROLLER, 500 * 1000, 8);

	SPI_setFIFOInterruptLevel(SPI_BASE, SPI_FIFO_TX1, SPI_FIFO_RX1);

	SPI_disableAllInterrupt(SPI_BASE);

	SPI_clearInterruptStatus(SPI_BASE, SPI_INT_RXFF);

	SPI_enableInterrupt(SPI_BASE,  SPI_INT_RXFF);

    SPI_enableModule(SPI_BASE);

	Interrupt_register(INT_SPIB, &spi_interrupt_irq_handler);

	SPI_resetTxFIFO(SPI_BASE);
	SPI_resetRxFIFO(SPI_BASE);

	SPI_disableLoopback(SPI_BASE);

}

void spi_transmit_uart_msg(void)
{
	uint8_t data;
	uint8_t i = 0;
	uint8_t j = 0;
	uint64_t cpu_counter_start, cpu_counter;
	static uint8_t flag = 1;

	uint8_t spi_data[4096];

	if(!(GPIO_readPin(GPIO_SPI_FLAG))){
		SPI_resetRxFIFO(SPI_BASE);
		Interrupt_enable(INT_SPIB);
		for(; j<1 ; j++){
			mem_write_buf(MEM_BUF_UART, 0x55);
		}
	} else{
		Interrupt_disable(INT_SPIB);
	}

	if(!mem_read_buf(MEM_BUF_UART, &data)){
		CS_LOW;
		cpu_counter_start = __get_rv_cycle();
		spi_data[i] = data;
		SPI_writeDataNonBlocking(SPI_BASE, spi_data[i]);
		i++;
		while (1) {
			if (!mem_read_buf(MEM_BUF_UART, &data)) {
				spi_data[i] = data;
				SPI_writeDataNonBlocking(SPI_BASE, spi_data[i]);
				i++;
			} else {
				cpu_counter = __get_rv_cycle();
				/* Wait ms to check if there is still data. */
				if (cpu_counter - cpu_counter_start >= (DEVICE_SYSCLK_FREQ / 1000000) ){
					while((SPI_getStatus(SPI_BASE)&SPI_SR_TFE) == 0);
					while(SPI_isBusy(SPI_BASE));
					CS_HIGH;
					break;
				}
			}
		}
	}

}
