/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __BOOT_SYSCTL_SUBCRG_CLOCK_V2_2_H__
#define __BOOT_SYSCTL_SUBCRG_CLOCK_V2_2_H__

#ifdef __cplusplus
extern "C"{
#endif

#if ((GS32F3xx == 0x2200) ||(GS32F3xx == 0x2203))

#include "inc/hw_sysctl_crg_v22.h"
#include "inc/hw_memmap.h"
#include "boot_hw_type.h"

#define BOOT_SUBCRG_CLOCK_FUNC_SECTION		BOOT_TEXT

/**
 * @brief CAN_CLK_SRC_SEL CAN Clock Source Selection Configuration Register Offset 0x000C
 *
 * Register Field		Field Range
 * reserved				31 : 2
 * can_clk_src_sel		1 : 0
 */
typedef enum BootCanClkSrc {
	BOOT_CAN_CLK_TYPE_HSE		= 0,
	BOOT_CAN_CLK_TYPE_AUXCLK_IN	= 1,
	BOOT_CAN_CLK_TYPE_PLL		= 2,
} BootCanClkSrc_t;

BOOT_SUBCRG_CLOCK_FUNC_SECTION void boot_sysctl_set_can_clk_src_sel(BootCanClkSrc_t type);

/**
 * @brief CAN Clock Division Configuration Register Offset 0x0028
 *
 * Register Field		Field Range
 * crg_len				31 : 27
 * crg_patten			26 : 0
 * default				0x47FFFE01  divider by 9
 */
BOOT_SUBCRG_CLOCK_FUNC_SECTION void boot_sysctl_set_can_clk_div(uint32_t div);

#endif

#ifdef __cplusplus
}
#endif

#endif
