/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#if (GS32F00xx == 0x3000)

#include "boot_asysctl_v3_0.h"

BOOT_TEXT void boot_sysctl_set_osc1_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF4230U);

	reg_val = HWREG(0x400D6314U);

	/* 0~14 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~0x7fffU)) | (0x575U << 0);
	else
		reg_val = (reg_val & (~0x7fffU)) | (trim_val & 0x7fffU);

	HWREG(0x400D6314U) = reg_val;
}

BOOT_TEXT void boot_sysctl_set_osc2_freq_range(Boot_OSC2_Freq_Sel_t val)
{
	HWREG(ANALOGSUBSYS_BASE + ANA_CFG_O_ANA_OSC2_SPARE) = (HWREG(ANALOGSUBSYS_BASE + ANA_CFG_O_ANA_OSC2_SPARE) & (~(3<<9))) | ((val &0x03) << 9);
}

BOOT_TEXT void boot_sysctl_set_osc2_coarse_internal_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF4238U);

	reg_val = HWREG(0x400D6328U);

	/* 9~10 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~0x600U)) | (2U << 9);
	else
		reg_val = (reg_val & (~0x600U)) | (trim_val & 0x600U);

	HWREG(0x400D6328U) = reg_val;
}

BOOT_TEXT void boot_sysctl_set_osc2_fine_internal_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF4230U);

	reg_val = HWREG(0x400D6314U);

	/* 16~30 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~0x7FFF0000U)) | (0x7C0U << 16);
	else
		reg_val = (reg_val & (~0x7FFF0000U)) | (trim_val & 0x7FFF0000U);

	HWREG(0x400D6314U) = reg_val;
}

BOOT_TEXT void boot_sysctl_set_top_ldo_1v2_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF4200U);

	reg_val = HWREG(0x400D6308U);

	/* 0~4 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~0x1fU)) | (22U << 0);
	else
		reg_val = (reg_val & (~0x1fU)) | (trim_val & 0x1fU);

	HWREG(0x400D6308U) = reg_val;
}

BOOT_TEXT void boot_sysctl_set_ana_ldo_trim(void)
{
	uint32_t reg_val;
	uint32_t trim_val;

	trim_val = HWREG(0x1FFF4210U);

	reg_val = HWREG(0x400D6534U);

	/* 0~2 bits */
	if (trim_val == 0xffffffffU)
		reg_val = (reg_val & (~0x3U)) | (0U << 0);
	else
		reg_val = (reg_val & (~0x3U)) | (trim_val & 0x3U);

	HWREG(0x400D6534U) = reg_val;
}

#endif
