/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#if (GS32F00xx == 0x1200)

#include "inc/hw_memmap.h"
#include "core_feature_cache.h"
#include "core_feature_base.h"

#include "boot_interrupt.h"
#include "boot_riscv_cache.h"
#include "boot_low_level_init_v1_2.h"
#include "boot_flash.h"
#include "boot_sysctl.h"
#include "boot_asysctl.h"

BOOT_TEXT void boot_low_level_init(uint32_t ahb_clk_freq)
{
	uint32_t flash_read_cycle;

	/* Enable I Cache */
	/* Check whether dcache real present or not */
	if (boot_ICache_present())
		boot_enable_ICache();

	/* Enable D Cache */
	/* Check whether dcache real present or not */
	if (boot_DCache_present())
		boot_enable_DCache();

	/**
	 * Do fence and fence.i to make sure previous
	 * ilm/dlm/icache/dcache control done
	 */
	__RWMB();
	__FENCE_I();

	/* Initialize interrupt. */
	boot_interrupt_init();

	/* set trim value */
	boot_sysctl_set_ldo_test_mode(2);
	boot_sysctl_set_ldo_chop_enable(1);
	boot_sysctl_set_ldo_1v2_trim();
	boot_sysctl_set_ana_ldo_trim();
	boot_sysctl_set_osc1_trim();
	boot_sysctl_set_osc2_trim();
	boot_sysctl_set_top_bor_trim();

	/* Set Flash bank wait read cycle. */
	if (ahb_clk_freq < 40000000U)
		flash_read_cycle = 1U;
	else if (ahb_clk_freq >= 40000000U && ahb_clk_freq < 80000000U)
		flash_read_cycle = 2U;
	else if (ahb_clk_freq >= 80000000U && ahb_clk_freq < 120000000U)
		flash_read_cycle = 3U;
	else if (ahb_clk_freq >= 120000000U && ahb_clk_freq < 160000000U)
		flash_read_cycle = 4U;
	else if (ahb_clk_freq >= 160000000U && ahb_clk_freq < 200000000U)
		flash_read_cycle = 5U;
	else if (ahb_clk_freq >= 200000000U && ahb_clk_freq < 240000000U)
		flash_read_cycle = 6U;
	else if (ahb_clk_freq >= 240000000U && ahb_clk_freq < 290000000U)
		flash_read_cycle = 7U;
	else if (ahb_clk_freq >= 290000000U && ahb_clk_freq < 320000000U)
		flash_read_cycle = 8U;
	else if (ahb_clk_freq >= 320000000U && ahb_clk_freq < 360000000U)
		flash_read_cycle = 9U;
	else if (ahb_clk_freq >= 360000000U && ahb_clk_freq < 400000000U)
		flash_read_cycle = 10U;
	else
		flash_read_cycle = 12U;

	boot_flash_unlock_register(BOOT_FLASH_INTERFACE_EFC_BASE);
	boot_flash_wakeup_from_lpm(BOOT_FLASH_INTERFACE_EFC_BASE);
	boot_flash_set_read_wait_cycle(BOOT_FLASH_INTERFACE_EFC_BASE, flash_read_cycle);
	boot_flash_lock_register(BOOT_FLASH_INTERFACE_EFC_BASE);

	boot_flash_unlock_register(BOOT_FLASH_INTERFACE_EFC2_BASE);
	boot_flash_wakeup_from_lpm(BOOT_FLASH_INTERFACE_EFC2_BASE);
	boot_flash_set_read_wait_cycle(BOOT_FLASH_INTERFACE_EFC2_BASE, flash_read_cycle);
	boot_flash_lock_register(BOOT_FLASH_INTERFACE_EFC2_BASE);
}

#endif	/* GS32F00xx */
