/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "boot_riscv_cache.h"

BOOT_TEXT int32_t boot_ICache_present(void)
{
	if (__RV_CSR_READ(CSR_MCFG_INFO) & MCFG_INFO_ICACHE)
		return 1;

	return 0;
}

BOOT_TEXT int32_t boot_DCache_present(void)
{
	if (__RV_CSR_READ(CSR_MCFG_INFO) & MCFG_INFO_DCACHE)
		return 1;

	return 0;
}

BOOT_TEXT void boot_enable_ICache(void)
{
	__RV_CSR_SET(CSR_MCACHE_CTL, MCACHE_CTL_IC_EN);
}

BOOT_TEXT void boot_disable_ICache(void)
{
	__RV_CSR_CLEAR(CSR_MCACHE_CTL, MCACHE_CTL_IC_EN);
}

BOOT_TEXT void boot_enable_DCache(void)
{
	__RV_CSR_SET(CSR_MCACHE_CTL, MCACHE_CTL_DC_EN);
}

BOOT_TEXT void boot_disable_DCache(void)
{
	__RV_CSR_CLEAR(CSR_MCACHE_CTL, MCACHE_CTL_DC_EN);
}

BOOT_TEXT void boot_machine_mode_flush_DCache_line(unsigned long addr)
{
	if (__RV_CSR_READ(CSR_MCACHE_CTL) & MCACHE_CTL_DC_EN)
	{
		__RV_CSR_WRITE(CSR_CCM_MBEGINADDR, addr);
		__RV_CSR_WRITE(CSR_CCM_MCOMMAND, BOOT_CCM_DC_WB);
	}
}

BOOT_TEXT void boot_machine_mode_flush_DCache_lines(unsigned long addr, unsigned long cnt)
{
	if (__RV_CSR_READ(CSR_MCACHE_CTL) & MCACHE_CTL_DC_EN) {
		if (cnt > 0) {
			unsigned long i;
			__RV_CSR_WRITE(CSR_CCM_MBEGINADDR, addr);
			for (i = 0; i < cnt; i++) {
				__RV_CSR_WRITE(CSR_CCM_MCOMMAND, BOOT_CCM_DC_WB);
			}
		}
	}
}

BOOT_TEXT void boot_machine_mode_invalid_DCache_line(unsigned long addr)
{
	if (__RV_CSR_READ(CSR_MCACHE_CTL) & MCACHE_CTL_DC_EN) {
		__RV_CSR_WRITE(CSR_CCM_MBEGINADDR, addr);
		__RV_CSR_WRITE(CSR_CCM_MCOMMAND, BOOT_CCM_DC_INVAL);
	}
}

BOOT_TEXT void boot_machine_mode_invalid_DCache_lines(unsigned long addr, unsigned long cnt)
{
	if (__RV_CSR_READ(CSR_MCACHE_CTL) & MCACHE_CTL_DC_EN) {
		if (cnt > 0) {
			unsigned long i;
			__RV_CSR_WRITE(CSR_CCM_MBEGINADDR, addr);
			for (i = 0; i < cnt; i++) {
				__RV_CSR_WRITE(CSR_CCM_MCOMMAND, BOOT_CCM_DC_INVAL);
			}
		}
	}
}

BOOT_TEXT void boot_machine_mode_invalid_ICache_line(unsigned long addr)
{
	__RV_CSR_WRITE(CSR_CCM_MBEGINADDR, addr);
	__RV_CSR_WRITE(CSR_CCM_MCOMMAND, BOOT_CCM_IC_INVAL);
}

BOOT_TEXT void boot_machine_mode_invalid_ICache_lines(unsigned long addr, unsigned long cnt)
{
	if (cnt > 0) {
		unsigned long i;
		__RV_CSR_WRITE(CSR_CCM_MBEGINADDR, addr);
		for (i = 0; i < cnt; i++)
			__RV_CSR_WRITE(CSR_CCM_MCOMMAND, BOOT_CCM_IC_INVAL);
	}
}
