/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <string.h>

#include "device.h"
#include "hal_spi_transfer.h"

uint32_t spi_rx_index = 0;
uint8_t app_spi_buf[8];
extern uint32_t jump_cmd_ready;

void PinMux_init(void)
{

	/* SPIA_STE */
	GPIO_setPinConfig(GPIO_0_SPIA_STE);
	GPIO_setPadConfig(0, GPIO_PIN_TYPE_STD|GPIO_PIN_TYPE_PULLUP);
	GPIO_setQualificationMode(0, GPIO_QUAL_ASYNC);

	/* SPIA_CLK */
	GPIO_setPinConfig(GPIO_3_SPIA_CLK);
	GPIO_setPadConfig(3, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(3, GPIO_QUAL_ASYNC);

	/* SPIA_SIMO */
	GPIO_setPinConfig(GPIO_2_SPIA_SIMO);
	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(2, GPIO_QUAL_ASYNC);

	/* SPIA_SOMI */
	GPIO_setPinConfig(GPIO_1_SPIA_SOMI);
	GPIO_setPadConfig(1, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(1, GPIO_QUAL_ASYNC);

}

__INTERRUPT void spi_interrupt_irq_handler(void)
{
	uint16_t irq_status = SPI_getInterruptStatus(SPI_BASE);

	if (irq_status & SPI_RISR_RXFIR){
		while(SPI_getRxFIFOStatus(SPI_BASE)) {
			app_spi_buf[spi_rx_index++] = (uint8_t)SPI_readDataNonBlocking(SPI_BASE);
			if (spi_rx_index >= 4) {
				if (memcmp(app_spi_buf, "JUMP", 4) == 0)
					jump_cmd_ready = 1;
				else
					spi_rx_index = 0;
			}
		}
	}

	SPI_clearInterruptStatus(SPI_BASE, SPI_RISR_RXFIR);
	__DSB();
}

void spi_init(void)
{
	PinMux_init();

	SPI_disableModule(SPI_BASE);

	SPI_setConfig(SPI_BASE, DEVICE_APBCLK_FREQ, SPI_PROT_POL1PHA1, SPI_MODE_PERIPHERAL, 500 * 1000, 8);

	SPI_setFIFOInterruptLevel(SPI_BASE, SPI_FIFO_TX8, SPI_FIFO_RX4);

	SPI_disableAllInterrupt(SPI_BASE);

	SPI_clearInterruptStatus(SPI_BASE, SPI_INT_RXFF);

	SPI_enableInterrupt(SPI_BASE, SPI_INT_RXFF);

	SPI_disableLoopback(SPI_BASE);

    SPI_enableModule(SPI_BASE);
	Interrupt_register(INT_SPIA, &spi_interrupt_irq_handler);
	Interrupt_enable(INT_SPIA);

	SPI_resetTxFIFO(SPI_BASE);
	SPI_resetRxFIFO(SPI_BASE);
}
