/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    board_cfg.h
*   @brief   board level configurations
*
*/

#ifndef __BOARD_CFG_H__
#define __BOARD_CFG_H__

#ifdef __cplusplus
extern "C"{
#endif

/**
  * @brief Configuration of the CRG
  */

/* ʹⲿپ */
#define __HSE_ENABLE                    1      /*!< hse_enable                           */

/* ⲿ: 0 Դ, 1 Դ, 2 Զ(ⲿѭ, ʺϳڲ) */
#define __HSE_CLOCK_TYPE                0

/* 趨PLLʱԴƵ: 10MHz IRC10MHz/20MHzⲿ */
#if __HSE_ENABLE == 0
#define DEVICE_OSCSRC_FREQ          (10*1000*1000U)
#else
#define DEVICE_OSCSRC_FREQ          (20*1000*1000U)
#endif

/* ϵͳʱ ֲȷƵ */
#define DEVICE_SYSCLK_FREQ          (300*1000*1000U)
/* ϵͳʱӷƵ 1,2,4,8 */
#define DEVICE_SYSCLK_DIV           (2)
/* PLLʱ 120MHz ~ 800MHz */
#define DEVICE_PLLCLK_FREQ          (DEVICE_SYSCLK_FREQ * DEVICE_SYSCLK_DIV)
/* AHBʱӷƵ 1,2,4 */
#define DEVICE_AHBCLK_DIV           (2)
/* AHBʱƵ MHz */
#define DEVICE_AHBCLK_FREQ          (DEVICE_SYSCLK_FREQ/DEVICE_AHBCLK_DIV)      // <= 100MHz
/* APBʱӷƵ 1,2,4,8 */
#define DEVICE_APBCLK_DIV           (4)
/* APBʱƵ MHz */
#define DEVICE_APBCLK_FREQ          (DEVICE_SYSCLK_FREQ/DEVICE_APBCLK_DIV)      // <= 100MHz
/* ʱʱƵʵAPBʱƵ */
#define SOC_TIMER_FREQ              (DEVICE_APBCLK_FREQ)

/**
  * @brief Configuration of the LED pins
  */
#define GPIO_PIN_LED1                   86U  // GPIO number for LED4
#define GPIO_PIN_LED2                   87U  // GPIO number for LED5
#define GPIO_CFG_LED1                   GPIO_86_GPIO86  // "pinConfig" for LED4
#define GPIO_CFG_LED2                   GPIO_87_GPIO87  // "pinConfig" for LED5

/**
  * @brief Configuration of the SCI pins
  */
#if (GS32_PART_NUM==0x0374 || GS32_PART_NUM==0x0377 || GS32_PART_NUM==0x0379)
#define SCIA_TX_PIN                 GPIO_84_SCIA_TX
#define SCIA_RX_PIN                 GPIO_85_SCIA_RX
#elif (GS32_PART_NUM==0x0650)
#define SCIA_TX_PIN                 GPIO_12_SCIA_TX
#define SCIA_RX_PIN                 GPIO_13_SCIA_RX
#elif (GS32_PART_NUM==0x0388A)
#define SCIA_TX_PIN                 GPIO_29_SCIA_TX
#define SCIA_RX_PIN                 GPIO_28_SCIA_RX
#endif

#define SCIB_TX_PIN                 GPIO_14_SCIB_TX
#define SCIB_RX_PIN                 GPIO_15_SCIB_RX
//
// Defines for debug print SCI pins
//
#define LOG_TX_PIN						SCIB_TX_PIN
#define LOG_RX_PIN						SCIB_RX_PIN
#define LOG_TX_PIN_NUM					(14U)
#define LOG_RX_PIN_NUM					(15U)

#define LOG_SCI_BASE                    SCIB_BASE

//
// Define for boot mode device
// 0: FDP_MEM_FLASH
// 1: FDP_DEV_UART
// 2: FDP_DEV_CAN_CTRL
// 3: FDP_DEV_I2C
// 4: FDP_DEV_SPI
//
#define PIN_VAL (1)

//
// Define for placing a variable into special memory section
//
#define APP_STARTM_T				__attribute__((section(".app_start")))
#define APP_ENDM_T					__attribute__((section(".app_end")))
#define BOOTAPP_SHARE_BSS_T			__attribute__((section(".shared_bootapp_bss")))

#ifdef __cplusplus
}
#endif

#endif  /* __BOARD_CFG_H__ */
