/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef APP_INFO_H_
#define APP_INFO_H_

#include <stdint.h>

#define FDP_APP_INFO	__attribute__((section(".fdp_app_info")))

typedef __attribute__((aligned(4)))struct fdp_app_image_info {
	uint32_t key;
	uint32_t key_check;
	uint32_t image_check;
	uint32_t image_size;
	uint32_t version;
	uint32_t offset;
	uint32_t app_start_addr;
	/* reserved for customer */
	uint32_t app_info_reserved[53];
	uint32_t App_Start_Mark[4];
} fdp_app_image_info_t;

typedef struct {
    Uint16 Rx_flag;
    Uint32 Rx_cmd;
    Uint32 Rx_addr;
    Uint32 Rx_len;
} IPC;

/* IPC CMD info. */
#define TICK_REQUEST_CMD_IMM		(0xE0)
#define TICK_REQUEST_CMD			(0xE1)
#define TICK_RESPONSE_CMD			(0xE2)

#endif /* APP_INFO_H_ */
