/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <stdint.h>

#include "fdp_mem.h"
#include "fdp.h"
#include "fdp_defconfig.h"

__attribute__((aligned(8))) fdp_record_stat_t fdp_current_stat;
__attribute__((aligned(8))) uint8_t FDP_FRAME_BUFFER[FDP_CONFIG_FRAME_BUFFER_SIZE];
__attribute__((aligned(8))) uint8_t FDP_RECV_BUFFER[FDP_CONFIG_FRAME_BUFFER_SIZE];
__attribute__((aligned(8))) uint8_t FDP_CHECK_BUFFER[FDP_CMD_TRANSFER_CHECK_LENGTH];

fdp_record_stat_t *fdp_get_current_stat(void)
{
	return &fdp_current_stat;
}

uint8_t *fdp_get_frame_buffer(void)
{
	return FDP_FRAME_BUFFER;
}

uint8_t *fdp_get_check_buffer(void)
{
	return FDP_CHECK_BUFFER;
}

uint8_t *fdp_get_recv_buffer(void)
{
	return FDP_RECV_BUFFER;
}
