/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    board_cfg.h
*   @brief   board level configurations
*
*/

#ifndef __BOARD_CFG_H__
#define __BOARD_CFG_H__

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */


/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/****************************************************
    GS32_PART_NUM == 0x0039; => 0039
    GS32_PART_NUM == 0x0049; => 0049
    GS32_PART_NUM == 0x0025A; => 0025A

    GS32_PIN_COUNT == 100 => 100pin
    GS32_PIN_COUNT == 80 =>  80pin
    GS32_PIN_COUNT == 64 =>  64pin
******************************************************/

/**
  * @brief Configuration of the CRG
  */

/* ʹⲿپ */
#define __HSE_ENABLE                    1      /*!< hse_enable                           */

/* ⲿ: 0 Դ, 1 Դ, 2 Զ(ⲿѭ, ʺϳڲ) */
#define __HSE_CLOCK_TYPE                0

/* 趨PLLʱԴƵ: 10MHz IRC10MHz/20MHzⲿ */
#if __HSE_ENABLE == 0
#define DEVICE_OSCSRC_FREQ          (10*1000*1000U)
#else
#define DEVICE_OSCSRC_FREQ          (20*1000*1000U)
#endif

/* ϵͳʱ ֲȷƵ */
#define DEVICE_SYSCLK_FREQ              (180*1000*1000U)

/* ϵͳʱӷƵ */
#define DEVICE_SYSCLK_DIV               (2)

/* PLLʱ */
#define DEVICE_PLLCLK_FREQ              (DEVICE_SYSCLK_FREQ * DEVICE_SYSCLK_DIV)

/* AHBʱӷƵ */
#define DEVICE_AHBCLK_DIV               (2)

/* AHBʱӵϵͳʱ */
#define DEVICE_AHBCLK_FREQ              (DEVICE_SYSCLK_FREQ/DEVICE_AHBCLK_DIV)

/* APBʱӷƵ = 1248 */
#define DEVICE_APBCLK_DIV               (4)

/* APBʱƵ MHz */
#define DEVICE_APBCLK_FREQ              (DEVICE_SYSCLK_FREQ/DEVICE_APBCLK_DIV)

/* ʱʱƵʵAPBʱƵ */
#define SOC_TIMER_FREQ                  (DEVICE_APBCLK_FREQ)

/**
  * @brief Configuration of the LED pins
  */
#if (GS32_PART_NUM==0x00137)
#define GPIO_PIN_LED1                   20U  // GPIO number for LED8
#define GPIO_PIN_LED2                   12U  // GPIO number for LED9   GPIO22ҪSCIB RX PIN뽫GPIO12ͨ߷P6-2, LED8
#define GPIO_CFG_LED1                   GPIO_20_GPIO20  // "pinConfig" for LED8
#define GPIO_CFG_LED2                   GPIO_12_GPIO12  // "pinConfig" for LED9
#elif (GS32_PART_NUM==0x00157)
#define GPIO_PIN_LED1                   34U  // GPIO number for LED3
#define GPIO_PIN_LED2                   31U  // GPIO number for LED4
#define GPIO_CFG_LED1                   GPIO_34_GPIO34  // "pinConfig" for LED3
#define GPIO_CFG_LED2                   GPIO_31_GPIO31  // "pinConfig" for LED4
#endif

/**
  * @brief Configuration of the SCI pins
  */
#define SCIA_TX_PIN                     GPIO_29_SCIA_TX
#define SCIA_RX_PIN                     GPIO_28_SCIA_RX
#if (GS32_PART_NUM==0x00137)
#define SCIB_TX_PIN                     GPIO_22_SCIB_TX  // GS32F00157̬壬P6 GPIO22 GPIO22_BPð
#define SCIB_RX_PIN                     GPIO_23_SCIB_RX
#elif (GS32_PART_NUM==0x00157)
#define SCIB_TX_PIN                     GPIO_22_SCIB_TX
#define SCIB_RX_PIN                     GPIO_23_SCIB_RX
#endif

//
// Defines for debug print SCI pins
//
#define LOG_TX_PIN						SCIB_TX_PIN
#define LOG_RX_PIN						SCIB_RX_PIN
#define LOG_TX_PIN_NUM					(22U)
#define LOG_RX_PIN_NUM					(23U)
#define LOG_SCI_BASE                    SCIB_BASE

//
// Define for boot mode device
// 0: FDP_MEM_FLASH
// 1: FDP_DEV_UART
// 2: FDP_DEV_CAN_CTRL
// 3: FDP_DEV_I2C
// 4: FDP_DEV_SPI
//
#define PIN_VAL (1)

//
// Define for placing a variable into special memory section
//
#define APP_STARTM_T				__attribute__((section(".app_start")))
#define APP_ENDM_T					__attribute__((section(".app_end")))
#define BOOTAPP_SHARE_BSS_T			__attribute__((section(".shared_bootapp_bss")))

//
// Define or calculate total package transfer cost.
//
//#define MONITOR_PACKAGE    (1)

#ifdef __cplusplus
}
#endif

#endif  /* __BOARD_CFG_H__ */
