/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef APP_INFO_H_
#define APP_INFO_H_

#include <stdint.h>

#define FDP_APP_INFO	__attribute__((section(".fdp_app_info")))

typedef __attribute__((aligned(4)))struct fdp_app_image_info {
	uint32_t key;
	uint32_t key_check;
	uint32_t image_check;
	uint32_t image_size;
	uint32_t version;
	uint32_t offset;
	uint32_t app_start_addr;
	/* reserved for customer */
	uint32_t app_info_reserved[53];
	uint32_t App_Start_Mark[4];
} fdp_app_image_info_t;

typedef enum {
	/* FDP running successfully. */
	FDP_SUCCESS		= 0,
	/* FDP access memory error. */
	FDP_ERRMEMO		= 1,
	/* FDP received data or commands error. */
	FDP_ERRRECV		= 2,
	/* FDP transmit data or commands error. */
	FDP_ERRTRAN		= 3,
	/* FDP input paramters error. */
	FDP_ERRINPARAM	= 4,
	/* FDP continues running. no error. */
	FDP_CONTINUE	= 5,
	/* FDP check paramters error. */
	FDP_CHECKERR	= 6,
} fdp_error_type_t;
/* CPU cache lines. */
#define FDP_CPU_CACHE_LINES_SIZE				32U

/* Flash address info. */

#define BANK0_BASE_ADDR		0x08000000U
#define BANK_MIN_ADDR		0x08000000U
#define BANK_MAX_ADDR		0x08200000U
#endif /* APP_INFO_H_ */
