/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __FDP_APP_INFO_H__
#define __FDP_APP_INFO_H__

#include <stdint.h>

/**
 * @brief Application IMAGE information section.
 * This section needs to be filled in the link script.
 * 
 */
#define FDP_APP_INFO	__attribute__((section(".fdp_app_info")))

#define FDP_BOOT_UPDATE_FLAG		0x9E8F6C2AU
#define FDP_BOOT_UPDATE_DISABLE		0x5A5A5A5AU

extern uint32_t FLASH_ENDM_ADDR;
extern uint32_t FLASH_APP_ADDR;

/**
 * @brief Application IMAGE information structure.
 * This structure should be customized by the user.
 * Default save key, key crc32 value, image crc32 vaule,
 * size of image, image version and address of first instruction for image.
 * 
 * @param key User defined. The key value store some key value.
 * @param key_check Verification value of key value.
 * @param image_check Verification value of image.
 * @param version Verison of image.
 * @param offset App information size from start to app_start_addr.
 * @param app_start_addr First instruction of image program.
 */
typedef __attribute__((aligned(4)))struct fdp_app_image_info {
	uint32_t key;
	uint32_t key_check;
	uint32_t image_check;
	uint32_t image_size;
	uint32_t version;
	uint32_t offset;
	uint32_t app_start_addr;
	/* reserved for customer */
	uint32_t app_info_reserved[53];
	uint32_t App_Start_Mark[4];
} fdp_app_image_info_t;

int fdp_check_jtag_app(uintptr_t info_addr);

int fdp_check_image_info(uintptr_t info_addr);

int fdp_check_image_base_on_info(uintptr_t info_addr);

bool fdp_is_entry_load_mode(void);

void fdp_set_entry_load_mode(bool enable);

#endif
