/*
 * pm_tformat_main.c
 *
 *  Created on: 2024 Oct 17
 *      Author: Gejian
 */

#include "tformat.h"
#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "clb.h"

/*
 * @brief Globals used by the tformat library
 * - tformatData structure to track key parameters.
 * - tformatRxData to receive data from SPI rxFIFO
 * - Lookup table for CRC calculations
 *
 * @note It must be done!
 *
 */
PM_tformat_DataStruct tformatData;
volatile uint16_t tformatRxData[PM_TFORMAT_FIELDS_MAX];

#if defined(PM_TFORMAT_CRC_TABLE)
	uint16_t tformatCRCtable[PM_TFORMAT_CRCTABLE_SIZE];
#endif

/*
 * @brief These structures are used to display the received
 * data in Code Composer Studio's Expressions window during
 * development.
 *
 * Because the structure is set, but never used,
 * the pragma RETAIN has been applied.
 * Volatile is used for the tformatSpiRxIsrTicker since
 * it is updated within the SPI ISR.
 *
 * @note Users can choose for themselves!
 *
 */
#pragma RETAIN (encoderData);
#pragma RETAIN (errorData);
#pragma RETAIN (commandData);

PM_tformat_encoderStruct encoderData;
PM_tformat_errorStruct errorData;
PM_tformat_commandStruct commandData;
volatile uint32_t tformatSpiRxIsrTicker;

int16_t main(void)
{
	/*
	 * @brief Disable global interrupt
	 */
    __disable_irq();

    /*
     * @brief Initialization Device
     */
    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);
    printf("tformat_f00xx_comms_demo start\r\n");

    /*
     * @brief Initializes the associated peripherals
     *
     * Initialization routine for the T-Format Encoder Interface.
     * Configures and enables clocks.
     * Configures GPIO, XBAR, SPI and CLB.
     * Registers the SPI RX interrupt.
     *
     * @note If you do not use interrupts, you clear them yourself
     * 		 after the function has finished executing.
     */
    tformat_init();

	/*
	 * @brief Enable global interrupt
	 */
    __enable_irq();

    /*
     * @brief initialization the error and encoder data structures.
     */
    errorData = (struct PM_tformat_errorStruct) {0};
    encoderData = (struct PM_tformat_encoderStruct) {0};
    tformatSpiRxIsrTicker = 0;

#if TFORMAT_RUN_IDD_ID6

    /*
     * @brief Test read/write to the encoder's EEPROM memory
     */
    tformat_testEEPROMCommands();
#endif

    /*
     * @brief Test all other commands in an infinite loop
     */
    tformat_exCommands();
}

/*
 * @brief End of file
 */
