/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

.equ STL_SUCCESS,0x0
.equ STL_ERR_CHECK_FAILED,0x7

.section .text
.global stl_mbist_march_x_algorithm
.type stl_mbist_march_x_algorithm, @function
stl_mbist_march_x_algorithm:
    /* Function prologue - save registers */
    addi sp, sp, -32
    sw ra, 28(sp)
    sw s0, 24(sp)
    sw s1, 20(sp)
    sw s2, 16(sp)

    /* Parameters: a0 = address, a1 = size */
    mv s0, a0
    mv s1, a1

    li t0, 100
    blt s1, t0, 1f
    mv s1, t0
1:
    /* Allocate stack space for cache_mem (100 bytes) */
    addi sp, sp, -100

    /* Memory backup (memcpy) */
    mv a0, sp   /* Destination address (cache_mem) */
    mv a1, s0   /* Source address */
    mv a2, s1   /* Size */
    call memcpy

	/* Comparison check (memcmp) */
    mv a0, sp
    mv a1, s0
    mv a2, s1
    call memcmp
    bnez a0, fail1

	/* Write 0 (memset) */
    mv a0, s0
    li a1, 0
    mv a2, s1
    call memset

    /* First loop: Check 0 and write 0xff (low to high) */
    li t0, 0
    mv t1, s0
1:
    lbu t2, 0(t1)
    bnez t2, fail1

    li t2, 0xff
    sb t2, 0(t1)

    addi t0, t0, 1
    addi t1, t1, 1
    blt t0, s1, 1b

    /* Second loop: Check 0xff and write 0 (high to low) */
    mv t0, s1
    add t1, s0, s1
1:
    addi t1, t1, -1
    addi t0, t0, -1

    lbu t2, 0(t1)
    li t3, 0xff
    bne t2, t3, fail1

    li t2, 0x00
    sb t2, 0(t1)

    bnez t0, 1b

    /* Third loop: Check all 0 */
    li t0, 0
    mv t1, s0
1:
    lbu t2, 0(t1)
    bnez t2, fail1

    addi t0, t0, 1
    addi t1, t1, 1
    blt t0, s1, 1b

    /* Restore memory */
    mv a0, s0
    mv a1, sp
    mv a2, s1
    call memcpy

    /* Final comparison check */
    mv a0, s0
    mv a1, sp
    mv a2, s1
    call memcmp
    bnez a0, fail1

    /* Success return */
    li a0, STL_SUCCESS
    j exit1

fail1:
    li a0, STL_ERR_CHECK_FAILED

exit1:
    /* Restore stack space */
    addi sp, sp, 100
    /* Restore registers */
    lw ra, 28(sp)
    lw s0, 24(sp)
    lw s1, 20(sp)
    lw s2, 16(sp)
    addi sp, sp, 32
    ret

.global stl_mbist_march_c_algorithm
.type stl_mbist_march_c_algorithm, @function
stl_mbist_march_c_algorithm:
    /* Function prologue - save registers */
    addi sp, sp, -32
    sw ra, 28(sp)
    sw s0, 24(sp)
    sw s1, 20(sp)
    sw s2, 16(sp)

    /* Parameters: a0 = address, a1 = size */
    mv s0, a0   /* Save address to s0 */
    mv s1, a1   /* Save size to s1 */

    /* Limit max size to 100 */
    li t0, 100
    blt s1, t0, 1f
    mv s1, t0
1:
    /* Allocate stack space for cache_mem (100 bytes) */
    addi sp, sp, -100

    /* Memory backup (memcpy) */
    mv a0, sp
    mv a1, s0
    mv a2, s1
    call memcpy

    /* Comparison check (memcmp) */
    mv a0, sp
    mv a1, s0
    mv a2, s1
    call memcmp
    bnez a0, fail2

    /* Write 0 (memset) */
    mv a0, s0
    li a1, 0
    mv a2, s1
    call memset

    /* First loop: Check 0 and write 0xff (low to high) */
    li t0, 0
    mv t1, s0
1:
    lbu t2, 0(t1)
    bnez t2, fail2

    li t2, 0xff
    sb t2, 0(t1)

    addi t0, t0, 1
    addi t1, t1, 1
    blt t0, s1, 1b

    /* Second loop: Check 0xff and write 0 (low to high) */
    li t0, 0
    mv t1, s0
1:
    lbu t2, 0(t1)
    li t3, 0xff
    bne t2, t3, fail2

    li t2, 0x00    /* Write 0x00 */
    sb t2, 0(t1)

    addi t0, t0, 1
    addi t1, t1, 1
    blt t0, s1, 1b

    /* Third loop: Check 0 and write 0xff (high to low) */
    mv t0, s1
    add t1, s0, s1
1:
    addi t1, t1, -1
    addi t0, t0, -1

    lbu t2, 0(t1)
    bnez t2, fail2

    li t2, 0xff
    sb t2, 0(t1)

    bnez t0, 1b

    /* Fourth loop: Check 0xff and write 0 (high to low) */
    mv t0, s1
    add t1, s0, s1
1:
    addi t1, t1, -1
    addi t0, t0, -1

    lbu t2, 0(t1)
    li t3, 0xff
    bne t2, t3, fail2

    li t2, 0x00    /* Write 0x00 */
    sb t2, 0(t1)

    bnez t0, 1b

    /* Final check: Verify all 0 */
    li t0, 0
    mv t1, s0
final_check:
    lbu t2, 0(t1)
    bnez t2, fail2

    addi t0, t0, 1
    addi t1, t1, 1
    blt t0, s1, final_check

    /* Restore memory */
    mv a0, s0
    mv a1, sp
    mv a2, s1
    call memcpy

    /* Final comparison check */
    mv a0, s0
    mv a1, sp
    mv a2, s1
    call memcmp
    bnez a0, fail2

    /* Success return */
    li a0, STL_SUCCESS
    j exit2

fail2:
    li a0, STL_ERR_CHECK_FAILED

exit2:
    /* Restore stack space */
    addi sp, sp, 100
    /* Restore registers */
    lw ra, 28(sp)
    lw s0, 24(sp)
    lw s1, 20(sp)
    lw s2, 16(sp)
    addi sp, sp, 32
    ret
